/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

final class StringStateValue
extends TmfStateValue {
    private final String value;

    public StringStateValue(String valueAsString) {
        this.value = valueAsString;
    }

    @Override
    public ITmfStateValue.Type getType() {
        return ITmfStateValue.Type.STRING;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof StringStateValue)) {
            return false;
        }
        StringStateValue other = (StringStateValue)object;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String unboxStr() {
        return this.value;
    }

    @Override
    public int compareTo(@Nullable ITmfStateValue other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        switch (other.getType()) {
            case DOUBLE: {
                throw new StateValueTypeException("A String state value cannot be compared to a Double state value.");
            }
            case INTEGER: {
                throw new StateValueTypeException("A String state value cannot be compared to an Integer state value.");
            }
            case LONG: {
                throw new StateValueTypeException("A String state value cannot be compared to a Long state value.");
            }
            case NULL: {
                return 1;
            }
            case STRING: {
                StringStateValue otherStringValue = (StringStateValue)other;
                return this.value.compareTo(otherStringValue.value);
            }
        }
        throw new StateValueTypeException("A String state value cannot be compared to the type " + (Object)((Object)other.getType()));
    }

    @Override
    public @Nullable Object unboxValue() {
        return this.value;
    }
}

