/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.ocl.core.internal.evaluator;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.emf.facet.efacet.core.query.IQueryImplementation;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.DerivedTypedElement;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.ParameterValue;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.emf.facet.query.ocl.core.util.OclQueryUtil;
import org.eclipse.emf.facet.query.ocl.metamodel.oclquery.OclQuery;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.expressions.OCLExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OclQueryImplementation
implements IQueryImplementation {
    public void setValue(Query query, DerivedTypedElement feature, EObject source, List<ParameterValue> parameterValues, Object newValue) throws DerivedTypedElementException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public boolean isCheckResultType() {
        return true;
    }

    public Object getValue(Query query, DerivedTypedElement feature, EObject source, List<ParameterValue> parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        if (!(query instanceof OclQuery)) {
            throw new IllegalArgumentException("The given DerivedTypedElement does not have a OclQuery");
        }
        try {
            return OclQueryImplementation.executeOclQuery(source, parameterValues, (OclQuery)query);
        }
        catch (Exception e) {
            throw new DerivedTypedElementException((Throwable)e);
        }
    }

    protected static Object executeOclQuery(EObject source, List<ParameterValue> parameterValues, OclQuery oclQuery) throws ParserException {
        Object evaluateQuery = null;
        OCLExpression<EClassifier> oclExpression = null;
        String stringExpression = oclQuery.getOclExpression();
        EClassifier context = oclQuery.getContext();
        if (stringExpression != null) {
            if (parameterValues != null) {
                for (ParameterValue paramValue : parameterValues) {
                    String tmp = stringExpression;
                    String name = paramValue.getParameter().getName();
                    Object value = paramValue.getValue();
                    String string = value == null ? "null" : value.toString();
                    stringExpression = tmp.replaceAll(name, string);
                }
            }
            oclExpression = OclQueryUtil.createOCLExpression(context, stringExpression);
        }
        if (oclExpression != null) {
            evaluateQuery = OclQueryUtil.evaluateQuery(context, oclExpression, source);
        }
        return evaluateQuery;
    }
}

