/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.TreeOpsBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.core.utils.NativeSQLUtils;
import org.eclipse.jubula.client.ui.rcp.actions.TransactionWrapper;
import org.eclipse.jubula.client.ui.rcp.controllers.MultipleTCBTracker;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractRefactorHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.ui.handlers.HandlerUtil;

public class ExtractTestCaseHandler
extends AbstractRefactorHandler {
    public Object executeImpl(ExecutionEvent event) {
        AbstractTestCaseEditor editor = (AbstractTestCaseEditor)HandlerUtil.getActivePart((ExecutionEvent)event);
        String newTestCaseName = this.getNewTestCaseName(event);
        if (newTestCaseName == null) {
            return null;
        }
        editor.getEditorHelper().getClipboard().clearContents();
        INodePO node = (INodePO)editor.getEditorHelper().getEditSupport().getOriginal();
        if (node != null) {
            this.validateNode(node);
            IExecTestCasePO exec = this.performExtraction(newTestCaseName, node, this.getSelection());
            try {
                editor.reOpenEditor((IPersistentObject)node);
                editor.getTreeViewer().setSelection((ISelection)new StructuredSelection(editor.getEntityManager().find(exec.getClass(), (Object)exec.getId())));
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForEditor(e, editor);
            }
        } else {
            ErrorHandlingUtil.createMessageDialog((JBException)new JBException(Messages.EditorWillBeClosed, MessageIDs.E_DELETED_TC), null, null);
            try {
                GeneralStorage.getInstance().reloadMasterSession((IProgressMonitor)new NullProgressMonitor());
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
            }
        }
        return null;
    }

    private void validateNode(INodePO node) {
        Assert.verify((node instanceof ISpecTestCasePO || node instanceof ITestSuitePO ? 1 : 0) != 0, (String)Messages.ExtractTestCaseOperateISpecTestCasePO);
    }

    private IExecTestCasePO performExtraction(String newTcName, INodePO node, IStructuredSelection selection) {
        ArrayList<INodePO> modNodes = new ArrayList<INodePO>(selection.size());
        for (Object next : selection) {
            if (!(next instanceof INodePO)) continue;
            modNodes.add((INodePO)next);
        }
        if (modNodes.isEmpty()) {
            return null;
        }
        ExtractOperation op = new ExtractOperation(node, modNodes, newTcName);
        boolean succ = TransactionWrapper.executeOperation(op);
        if (!succ) {
            return null;
        }
        op.getMapper().updateStandardMapperAndCleanup(node.getParentProjectId());
        IExecTestCasePO newExec = op.getExec();
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)node, DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.all);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newExec, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        ISpecTestCasePO newSpecTC = newExec.getSpecTestCase();
        newSpecTC = (ISpecTestCasePO)GeneralStorage.getInstance().getMasterSession().find(newSpecTC.getClass(), (Object)newSpecTC.getId());
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newSpecTC, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        TestCaseBrowser tcb = MultipleTCBTracker.getInstance().getMainTCB();
        if (tcb != null) {
            tcb.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)newSpecTC), true);
        }
        return newExec;
    }

    private static class ExtractOperation
    implements TransactionSupport.ITransaction {
        private List<IPersistentObject> m_lock = null;
        private List<INodePO> m_modNodes;
        private INodePO m_owner;
        private IExecTestCasePO m_exec;
        private String m_specName;
        private ParamNameBPDecorator m_mapper = new ParamNameBPDecorator((IParamNameMapper)ParamNameBP.getInstance());
        private ISpecObjContPO m_cont = GeneralStorage.getInstance().getProject().getSpecObjCont();

        public ExtractOperation(INodePO owner, List<INodePO> modNodes, String name) {
            this.m_modNodes = modNodes;
            this.m_owner = owner;
            this.m_specName = name;
        }

        public Collection<? extends IPersistentObject> getToLock() {
            this.m_lock = new ArrayList<IPersistentObject>(2);
            this.m_lock.add((IPersistentObject)this.m_cont);
            this.m_lock.add((IPersistentObject)this.m_owner);
            return this.m_lock;
        }

        public Collection<? extends IPersistentObject> getToRefresh() {
            return this.m_lock;
        }

        public Collection<? extends IPersistentObject> getToMerge() {
            ArrayList<ISpecTestCasePO> toMerge = new ArrayList<ISpecTestCasePO>();
            toMerge.add(this.m_exec.getSpecTestCase());
            return toMerge;
        }

        public void run(EntityManager sess) throws PMException {
            ArrayList<INodePO> nodesToRef = new ArrayList<INodePO>();
            this.getModNodesFromCurrentSession(sess, nodesToRef);
            this.m_exec = TreeOpsBP.extractTestCase((String)this.m_specName, (INodePO)this.m_owner, nodesToRef, (EntityManager)sess, (ParamNameBPDecorator)this.m_mapper);
            ISpecTestCasePO newSpecTc = this.m_exec.getSpecTestCase();
            ExtractTestCaseHandler.registerParamNamesToSave(newSpecTc, this.m_mapper);
            this.m_mapper.persist(sess, GeneralStorage.getInstance().getProject().getId());
            NativeSQLUtils.addNodeAFFECTS((EntityManager)sess, (INodePO)this.m_exec.getSpecTestCase(), (IPersistentObject)this.m_cont);
        }

        private void getModNodesFromCurrentSession(EntityManager s, List<INodePO> nodesToRef) {
            if (this.m_modNodes.isEmpty()) {
                return;
            }
            INodePO spec = this.m_modNodes.get(0).getSpecAncestor();
            spec = (INodePO)s.find(spec.getClass(), (Object)spec.getId());
            Iterator it = spec.getAllNodeIter();
            while (it.hasNext()) {
                it.next();
            }
            for (INodePO node : this.m_modNodes) {
                INodePO object = (INodePO)s.find(node.getClass(), (Object)node.getId());
                if (object == null) continue;
                nodesToRef.add(object);
            }
        }

        public ParamNameBPDecorator getMapper() {
            return this.m_mapper;
        }

        public IExecTestCasePO getExec() {
            return this.m_exec;
        }
    }
}

