/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractShowWhereUsedQuery;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;

public class ShowWhereUsedTestSuiteQuery
extends AbstractShowWhereUsedQuery {
    private ITestSuitePO m_testSuite;

    public ShowWhereUsedTestSuiteQuery(ITestSuitePO testSuite) {
        super(null);
        this.m_testSuite = testSuite;
    }

    public IStatus run(IProgressMonitor monitor) {
        this.calculateReuseOfTestSuite(this.m_testSuite, monitor);
        return Status.OK_STATUS;
    }

    private void calculateReuseOfTestSuite(ITestSuitePO testSuite, IProgressMonitor monitor) {
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        List reuseList = NodePM.getInternalRefTestSuites((String)testSuite.getGuid(), (long)currentProject.getId());
        INodePO[] reuse = new INodePO[reuseList.size()];
        reuseList.toArray(reuse);
        monitor.beginTask("Searching for reusage of Test Suite", reuseList.size());
        List<BasicSearchResult.SearchResultElement> reuseLoc = this.getResultElementsFromNodes(monitor, reuse);
        this.setSearchResult(reuseLoc);
        monitor.done();
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp());
        sb.append(":");
        sb.append(" ");
        sb.append(Messages.UIJobSearchingTestSuites);
        sb.append(" \"");
        sb.append(this.m_testSuite.getName());
        sb.append("\"");
        return sb.toString();
    }
}

