/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.actions;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.OpenRepositoryTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.OpenRepositoryTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.internal.team.ui.LinkedTaskInfo;
import org.eclipse.mylyn.internal.team.ui.actions.Messages;
import org.eclipse.mylyn.internal.team.ui.templates.CommitTemplateManager;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.team.ui.AbstractTaskReference;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TaskFinder {
    private static final String PREFIX_HTTP = "http://";
    private static final String PREFIX_HTTPS = "https://";
    private final AbstractTaskReference reference;
    private ITask task;
    private long timestamp;

    public static String getTaskIdFromLegacy07Label(String comment) {
        String PREFIX_DELIM = ":";
        String PREFIX_START_1 = Messages.OpenCorrespondingTaskAction_Progress_on;
        String PREFIX_START_2 = Messages.OpenCorrespondingTaskAction_Completed;
        String usedPrefix = PREFIX_START_1;
        int firstDelimIndex = comment.indexOf(PREFIX_START_1);
        if (firstDelimIndex == -1) {
            firstDelimIndex = comment.indexOf(PREFIX_START_2);
            usedPrefix = PREFIX_START_2;
        }
        if (firstDelimIndex != -1) {
            int idStart = firstDelimIndex + usedPrefix.length();
            int idEnd = comment.indexOf(PREFIX_DELIM, firstDelimIndex + usedPrefix.length());
            if (idEnd != -1 && idStart < idEnd) {
                String id = comment.substring(idStart, idEnd);
                if (id != null) {
                    return id.trim();
                }
            } else {
                return comment.substring(0, firstDelimIndex);
            }
        }
        return null;
    }

    public static String getUrlFromComment(String comment) {
        int httpIndex = comment.indexOf(PREFIX_HTTP);
        int httpsIndex = comment.indexOf(PREFIX_HTTPS);
        int idStart = -1;
        if (httpIndex != -1) {
            idStart = httpIndex;
        } else if (httpsIndex != -1) {
            idStart = httpsIndex;
        }
        if (idStart != -1) {
            int idEnd = idStart;
            while (idEnd < comment.length() && !Character.isWhitespace(comment.charAt(idEnd))) {
                ++idEnd;
            }
            return comment.substring(idStart, idEnd);
        }
        return null;
    }

    private static AbstractTaskReference reconcile(AbstractTaskReference info) {
        CommitTemplateManager commitTemplateManager;
        long timestamp;
        ITask task;
        if (info instanceof LinkedTaskInfo) {
            task = ((LinkedTaskInfo)info).getTask();
            timestamp = ((LinkedTaskInfo)info).getTimestamp();
        } else {
            task = null;
            timestamp = 0L;
        }
        if (task != null) {
            return info;
        }
        String repositoryUrl = info.getRepositoryUrl();
        String taskId = info.getTaskId();
        String taskFullUrl = info.getTaskUrl();
        String comment = info.getText();
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        TaskRepository repository = null;
        if (repositoryUrl != null) {
            repository = repositoryManager.getRepository(repositoryUrl);
        }
        if (taskFullUrl == null && comment != null) {
            taskFullUrl = TaskFinder.getUrlFromComment(comment);
        }
        AbstractRepositoryConnector connector = null;
        if (taskFullUrl != null) {
            connector = repositoryManager.getConnectorForRepositoryTaskUrl(taskFullUrl);
        }
        if (connector == null && repository != null) {
            connector = repositoryManager.getRepositoryConnector(repository.getConnectorKind());
        }
        if (repositoryUrl == null && connector != null) {
            repositoryUrl = connector.getRepositoryUrlFromTaskUrl(taskFullUrl);
            if (repository == null) {
                repository = repositoryManager.getRepository(repositoryUrl);
            }
        }
        if (taskId == null && connector != null) {
            taskId = connector.getTaskIdFromTaskUrl(taskFullUrl);
        }
        if (taskId == null && comment != null) {
            Collection<Object> connectors = connector != null ? Collections.singletonList(connector) : TasksUi.getRepositoryManager().getRepositoryConnectors();
            block0: for (AbstractRepositoryConnector abstractRepositoryConnector : connectors) {
                List<TaskRepository> repositories = repository != null ? Collections.singletonList(repository) : TasksUi.getRepositoryManager().getRepositories(abstractRepositoryConnector.getConnectorKind());
                for (TaskRepository r : repositories) {
                    String[] ids = abstractRepositoryConnector.getTaskIdsFromComment(r, comment);
                    if (ids == null || ids.length <= 0) continue;
                    taskId = ids[0];
                    connector = abstractRepositoryConnector;
                    repository = r;
                    repositoryUrl = r.getRepositoryUrl();
                    break block0;
                }
            }
        }
        if (taskId == null && comment != null && (taskId = (commitTemplateManager = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager()).getTaskIdFromCommentOrLabel(comment)) == null) {
            taskId = TaskFinder.getTaskIdFromLegacy07Label(comment);
        }
        if (taskFullUrl == null && repositoryUrl != null && taskId != null && connector != null) {
            taskFullUrl = connector.getTaskUrl(repositoryUrl, taskId);
        }
        if (task == null) {
            if (taskId != null && repositoryUrl != null && !taskId.contains("-")) {
                task = TasksUiInternal.getTaskList().getTask(repositoryUrl, taskId);
            }
            if (task == null && taskFullUrl != null) {
                task = TasksUiInternal.getTaskByUrl((String)taskFullUrl);
            }
        }
        return new LinkedTaskInfo(repositoryUrl, taskId, taskFullUrl, comment, timestamp, task);
    }

    public TaskFinder(Object element) {
        this.reference = this.initialize(element);
    }

    public AbstractTaskReference getReference() {
        return this.reference;
    }

    public ITask getTask() {
        return this.task;
    }

    private AbstractTaskReference initialize(Object element) {
        AbstractTaskReference info = null;
        if (element instanceof AbstractTaskReference) {
            info = (AbstractTaskReference)element;
        } else if (element instanceof IAdaptable) {
            info = (AbstractTaskReference)((IAdaptable)element).getAdapter(AbstractTaskReference.class);
        }
        if (info == null) {
            info = (AbstractTaskReference)Platform.getAdapterManager().getAdapter(element, AbstractTaskReference.class);
        }
        if (info != null && (info = TaskFinder.reconcile(info)) instanceof LinkedTaskInfo) {
            this.task = ((LinkedTaskInfo)info).getTask();
            this.timestamp = ((LinkedTaskInfo)info).getTimestamp();
        }
        return info;
    }

    public EditorHandle openTaskByKey(IWorkbenchPage page) {
        String taskUrl;
        if (this.reference != null && (taskUrl = this.reference.getTaskUrl()) != null && this.openTaskByKey(page, taskUrl)) {
            return new EditorHandle(Status.OK_STATUS);
        }
        return null;
    }

    public IStatus open() {
        if (this.reference != null) {
            String taskFullUrl;
            if (this.task != null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TasksUiUtil.openTask((ITask)TaskFinder.this.task);
                    }
                });
                return Status.OK_STATUS;
            }
            if (this.reference.getRepositoryUrl() != null && this.reference.getTaskId() != null) {
                AbstractRepositoryConnectorUi connectorUi;
                TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(this.reference.getRepositoryUrl());
                String taskId = this.reference.getTaskId();
                if (repository != null && taskId != null && (connectorUi = TasksUiPlugin.getConnectorUi((String)repository.getConnectorKind())) != null) {
                    TasksUiInternal.openRepositoryTask((String)connectorUi.getConnectorKind(), (String)repository.getRepositoryUrl(), (String)taskId, null, (long)this.timestamp);
                    return Status.OK_STATUS;
                }
            }
            if ((taskFullUrl = this.reference.getTaskUrl()) != null) {
                if (!this.openTaskByKey(this.getActivePage(), taskFullUrl)) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TasksUiUtil.openUrl((String)taskFullUrl);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                boolean openDialog = MessageDialog.openQuestion((Shell)window.getShell(), (String)Messages.OpenCorrespondingTaskAction_Open_Task, (String)Messages.OpenCorrespondingTaskAction_Unable_to_match_task);
                if (openDialog) {
                    new OpenRepositoryTaskAction().run(null);
                }
            }
        });
        return Status.OK_STATUS;
    }

    private boolean openTaskByKey(IWorkbenchPage page, String taskFullUrl) {
        AbstractRepositoryConnector connector;
        String taskKey = null;
        TaskRepository repository = this.guessRepository(taskFullUrl);
        if (repository != null && (connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind())) != null) {
            taskKey = TaskFinder.guessTaskKey(connector, repository, taskFullUrl);
        }
        if (taskKey != null && page != null) {
            new OpenRepositoryTaskJob(repository, taskKey, taskFullUrl, page).schedule();
            return true;
        }
        return false;
    }

    private IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    private TaskRepository guessRepository(String taskFullUrl) {
        for (TaskRepository repository : TasksUi.getRepositoryManager().getAllRepositories()) {
            if (!taskFullUrl.startsWith(repository.getRepositoryUrl())) continue;
            return repository;
        }
        return null;
    }

    private static String guessTaskKey(AbstractRepositoryConnector connector, TaskRepository repository, String taskFullUrl) {
        ITask task;
        URL browserUrl;
        Set tasks = ((TaskList)TasksUiInternal.getTaskList()).getTasks(repository.getRepositoryUrl());
        if (!tasks.isEmpty() && (browserUrl = connector.getBrowserUrl(repository, (IRepositoryElement)(task = (ITask)tasks.iterator().next()))) != null) {
            return TaskFinder.guessTaskKey(taskFullUrl, browserUrl.toExternalForm(), task.getTaskKey());
        }
        return null;
    }

    public static String guessTaskKey(String taskFullUrl, String knownTaskUrl, String knownTaskKey) {
        int index = knownTaskUrl.indexOf(knownTaskKey);
        if (index != -1) {
            String prefix = knownTaskUrl.substring(0, index);
            String postfix = knownTaskUrl.substring(index + knownTaskKey.length());
            return TaskFinder.extractTaskId(taskFullUrl, prefix, postfix);
        }
        return null;
    }

    public static String extractTaskId(String taskFullUrl, String prefix, String postfix) {
        if (!prefix.isEmpty() && taskFullUrl.startsWith(prefix) && taskFullUrl.endsWith(postfix)) {
            return taskFullUrl.substring(prefix.length(), taskFullUrl.length() - postfix.length());
        }
        return null;
    }
}

