/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.actions;

import java.util.List;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;

public class DiagramDirectEditActionHandler
extends SapphireActionHandler {
    protected Object run(Presentation context) {
        DiagramPresentation presentation = (DiagramPresentation)context;
        SapphireDiagramEditor diagramEditor = presentation.getConfigurationManager().getDiagramEditor();
        if (diagramEditor != null) {
            List<ISapphirePart> parts = diagramEditor.getSelectedParts();
            DiagramModel model = diagramEditor.getDiagramModel();
            if (parts.size() == 1) {
                ISapphirePart part = parts.get(0);
                if (part instanceof DiagramNodePart) {
                    model.handleDirectEditing((DiagramNodePart)part);
                } else if (part instanceof ShapePart) {
                    model.handleDirectEditing((ShapePart)part);
                } else if (part instanceof DiagramConnectionPart && ((DiagramConnectionPart)part).removable()) {
                    model.handleDirectEditing((DiagramConnectionPart)part);
                }
            }
        }
        return null;
    }
}

