/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.actions;

import java.util.List;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.diagram.def.IDiagramConnectionDef;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.internal.DiagramNodeConnectionCreationTool;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramNodePresentation;

public class NodeCreateConnectionActionHandler
extends SapphireActionHandler {
    private IDiagramConnectionDef connectionDef;

    public NodeCreateConnectionActionHandler(IDiagramConnectionDef connectionDef) {
        this.connectionDef = connectionDef;
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        String label = (String)this.connectionDef.getToolPaletteLabel().content();
        String tooltip = (String)this.connectionDef.getToolPaletteDescription().content();
        if (label != null) {
            this.setLabel(label);
        }
        if (tooltip != null) {
            this.setToolTip(tooltip);
        }
        SapphireDiagramEditorPagePart pagePart = (SapphireDiagramEditorPagePart)action.getPart().nearest(SapphireDiagramEditorPagePart.class);
        List conns = pagePart.getConnectionPalettes();
        ImageData connImage = null;
        for (SapphireDiagramEditorPagePart.ConnectionPalette conn : conns) {
            if (conn.getConnectionDef() != this.connectionDef) continue;
            connImage = conn.getSmallIcon();
            break;
        }
        if (connImage == null) {
            connImage = this.getAction().getImage(16);
        }
        if (connImage != null) {
            this.addImage(connImage);
        }
    }

    protected Object run(Presentation context) {
        DiagramNodePresentation nodePresentation = (DiagramNodePresentation)context;
        SapphireDiagramEditor diagramEditor = nodePresentation.getConfigurationManager().getDiagramEditor();
        if (diagramEditor != null) {
            GraphicalEditPart sourceEditPart = diagramEditor.getGraphicalEditPart((ISapphirePart)nodePresentation.part());
            DefaultEditDomain editDomain = diagramEditor.getEditDomain();
            DiagramNodeConnectionCreationTool connectionTool = new DiagramNodeConnectionCreationTool();
            connectionTool.setEditDomain((EditDomain)editDomain);
            editDomain.setActiveTool((Tool)connectionTool);
            connectionTool.continueConnection((EditPart)sourceEditPart, diagramEditor, this.connectionDef);
        }
        return null;
    }
}

