/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.swt.gef.commands.BendPointCommand;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;

public class MoveBendPointCommand
extends BendPointCommand {
    public boolean canExecute() {
        List<DiagramNodeModel> nodes = this.getDiagramConnectionModel().getDiagramModel().getNodes();
        Point location = this.getLocation();
        for (DiagramNodeModel node : nodes) {
            if (!this.pointInBounds(location, node.getShapePresentation().getFigure().getBounds())) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        this.getDiagramConnectionModel().getModelPart().updateBendpoint(this.getIndex(), this.getLocation().x, this.getLocation().y);
        super.execute();
    }

    protected boolean pointInBounds(Point p, Bounds bounds) {
        int x = bounds.getX();
        int y = bounds.getY();
        int x2 = x + bounds.getWidth();
        int y2 = y + bounds.getHeight();
        return x <= p.x && p.x <= x2 && y <= p.y && p.y <= y2;
    }
}

