/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.contextbuttons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonPad;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.ContextButtonPadData;
import org.eclipse.sapphire.ui.swt.gef.contextbuttons.StandardContextButtonPadDeclaration;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.parts.DiagramNodeEditPart;
import org.eclipse.sapphire.ui.swt.gef.parts.ShapeEditPart;

public class ContextButtonManager {
    private static final String DIAGRAM_NODE_DEFAULT_ACTION = "Sapphire.Diagram.Node.Default";
    private static final String DIAGRAM_DELETE_ALL_BEND_POINTS = "Sapphire.Diagram.DeleteAllBendPoints";
    protected static final double MINIMUM_ZOOM_LEVEL = 0.75;
    private SapphireDiagramEditor editor;
    private Map<IFigure, EditPart> figure2EditPart = new HashMap<IFigure, EditPart>();
    private ContextButtonPad activeContextButtonPad;
    private ZoomListener zoomListener = new ZoomListener(){

        public void zoomChanged(double newZoom) {
            ContextButtonManager.this.handleZoomChanged();
        }
    };
    private FigureListener figureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            ContextButtonManager.this.refresh();
        }
    };

    public ContextButtonManager(SapphireDiagramEditor editor) {
        this.editor = editor;
        ZoomManager zoomMgr = (ZoomManager)this.getEditor().getGraphicalViewer().getProperty(ZoomManager.class.toString());
        if (zoomMgr != null) {
            zoomMgr.addZoomListener(this.zoomListener);
        }
    }

    public SapphireDiagramEditor getEditor() {
        return this.editor;
    }

    private Map<IFigure, EditPart> getFigure2EditPart() {
        return this.figure2EditPart;
    }

    private ContextButtonPad getActiveContextButtonPad() {
        return this.activeContextButtonPad;
    }

    private void setActiveContextButtonPad(ContextButtonPad contextButtonPad) {
        this.activeContextButtonPad = contextButtonPad;
    }

    public void register(GraphicalEditPart graphicalEditPart) {
        this.getFigure2EditPart().put(graphicalEditPart.getFigure(), (EditPart)graphicalEditPart);
        graphicalEditPart.getFigure().addFigureListener(this.figureListener);
    }

    public void deRegister(GraphicalEditPart graphicalEditPart) {
        this.getFigure2EditPart().remove(graphicalEditPart.getFigure());
        graphicalEditPart.getFigure().removeFigureListener(this.figureListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideContextButtonsInstantly() {
        if (this.getActiveContextButtonPad() != null) {
            ContextButtonManager contextButtonManager = this;
            synchronized (contextButtonManager) {
                ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getEditor().getGraphicalViewer().getRootEditPart();
                IFigure feedbackLayer = rootEditPart.getLayer((Object)"Handle Layer");
                feedbackLayer.remove((IFigure)this.getActiveContextButtonPad());
                this.setActiveContextButtonPad(null);
            }
        }
    }

    private void handleZoomChanged() {
        this.refresh();
    }

    private ContextButtonPadData getContextButtonPad(List<GraphicalEditPart> editParts) {
        SapphireAction action;
        ContextButtonPadData contextButtonPadData = new ContextButtonPadData();
        DiagramNodeEditPart nodeEditPart = ((ShapeEditPart)editParts.get(0)).getNodeEditPart();
        if (nodeEditPart == null) {
            return contextButtonPadData;
        }
        Rectangle bounds = nodeEditPart.getFigure().getBounds();
        Point loc = bounds.getLocation();
        Point botRight = bounds.getBottomRight();
        contextButtonPadData.getPadLocation().set(loc.x, loc.y, botRight.x - loc.x, botRight.y - loc.y);
        SapphireActionGroup actionGroup = null;
        if (editParts.size() == 1) {
            ShapeEditPart shapeEditPart = (ShapeEditPart)editParts.get(0);
            if (shapeEditPart instanceof DiagramNodeEditPart) {
                DiagramNodePart nodePart = nodeEditPart.getCastedModel().getModelPart();
                actionGroup = nodePart.getActions("Sapphire.Diagram.Node");
            } else {
                ShapePart shapePart = (ShapePart)((ShapeModel)shapeEditPart.getModel()).getSapphirePart();
                actionGroup = shapePart.getActions("Sapphire.Diagram.Node.Shape");
            }
        } else {
            SapphireDiagramEditorPagePart pagePart = this.getEditor().getPart();
            actionGroup = pagePart.getActions("Sapphire.Diagram.MultipleParts");
        }
        List originalActions = actionGroup.getActions();
        ArrayList<SapphireAction> actions = new ArrayList<SapphireAction>(originalActions.size());
        for (SapphireAction action2 : originalActions) {
            if (action2.getId().equals(DIAGRAM_NODE_DEFAULT_ACTION) || action2.getId().equals(DIAGRAM_DELETE_ALL_BEND_POINTS) || action2.getActiveHandlers().size() <= 0) continue;
            actions.add(action2);
        }
        int numOfActions = actions.size();
        int half = numOfActions / 2;
        LinkedHashMap<String, ArrayList<SapphireAction>> buckets = new LinkedHashMap<String, ArrayList<SapphireAction>>();
        for (SapphireAction action3 : actions) {
            String group = MiscUtil.normalizeToEmptyString((String)action3.getGroup());
            ArrayList<SapphireAction> bucket = (ArrayList<SapphireAction>)buckets.get(group);
            if (bucket == null) {
                bucket = new ArrayList<SapphireAction>();
                buckets.put(group, bucket);
            }
            bucket.add(action3);
        }
        int numTopActions = 0;
        if (buckets.size() < 2) {
            numTopActions = half;
        } else {
            int i = 0;
            for (List bucket : buckets.values()) {
                if (buckets.size() == 2 || (numTopActions += bucket.size()) >= half || i == buckets.size() - 2) break;
                ++i;
            }
        }
        int i = numTopActions - 1;
        while (i >= 0) {
            action = (SapphireAction)actions.get(i);
            contextButtonPadData.getTopContextButtons().add(action);
            --i;
        }
        i = numTopActions;
        while (i < numOfActions) {
            action = (SapphireAction)actions.get(i);
            contextButtonPadData.getRightContextButtons().add(action);
            ++i;
        }
        return contextButtonPadData;
    }

    public void refresh() {
        this.refreshInternal();
    }

    private void refreshInternal() {
        this.hideContextButtonsInstantly();
        if (this.getEditor().isDirectEditingActive()) {
            return;
        }
        List<ISapphirePart> selectedParts = this.getEditor().getSelectedParts();
        if (selectedParts.size() == 0) {
            return;
        }
        HashSet<DiagramNodePart> selectedNodes = new HashSet<DiagramNodePart>();
        for (ISapphirePart part : selectedParts) {
            if (part instanceof DiagramConnectionPart || part instanceof SapphireDiagramEditorPagePart) {
                return;
            }
            DiagramNodePart nodePart = (DiagramNodePart)part.nearest(DiagramNodePart.class);
            if (selectedNodes.contains(nodePart)) continue;
            selectedNodes.add(nodePart);
        }
        if (selectedNodes.size() > 1) {
            return;
        }
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)this.getEditor().getGraphicalViewer().getRootEditPart();
        double zoom = rootEditPart.getZoomManager().getZoom();
        if (zoom < 0.75) {
            return;
        }
        ContextButtonPadData contextButtonPadData = this.getContextButtonPad(this.getEditor().getSelectedEditParts());
        if (contextButtonPadData.getRightContextButtons().size() == 0 && contextButtonPadData.getTopContextButtons().size() == 0) {
            return;
        }
        StandardContextButtonPadDeclaration declaration = new StandardContextButtonPadDeclaration(contextButtonPadData);
        ContextButtonPad contextButtonPad = new ContextButtonPad(declaration, zoom, this.getEditor(), this.getEditor().getSelectedEditParts());
        this.setActiveContextButtonPad(contextButtonPad);
        IFigure feedbackLayer = rootEditPart.getLayer((Object)"Handle Layer");
        feedbackLayer.add((IFigure)contextButtonPad);
    }
}

