/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.figures;

import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ui.LineStyle;
import org.eclipse.sapphire.ui.diagram.shape.def.BorderComponent;
import org.eclipse.sapphire.ui.swt.gef.figures.FigureUtil;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.RectanglePresentation;

public class RectangleBorder
extends AbstractBorder {
    private RectanglePresentation rectPresentation;
    private DiagramResourceCache resourceCache;
    private boolean hasUniformBorders;

    public RectangleBorder(RectanglePresentation rectPresentation, DiagramResourceCache resourceCache) {
        this.rectPresentation = rectPresentation;
        this.resourceCache = resourceCache;
        this.hasUniformBorders = this.hasUniformBorders();
    }

    public Insets getInsets(IFigure figure) {
        int tw = (Integer)this.rectPresentation.getTopBorder().getWeight().content();
        int bw = (Integer)this.rectPresentation.getBottomBorder().getWeight().content();
        int lw = (Integer)this.rectPresentation.getLeftBorder().getWeight().content();
        int rw = (Integer)this.rectPresentation.getRightBorder().getWeight().content();
        return new Insets(tw, lw, bw, rw);
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(RectangleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        BorderComponent borderDef = this.rectPresentation.getTopBorder();
        if (this.hasUniformBorders && (Integer)borderDef.getWeight().content() > 0) {
            int w = (Integer)borderDef.getWeight().content();
            rectangle = FigureUtil.getAdjustedRectangle(rectangle, 1.0, w);
            int cornerRadius = this.rectPresentation.getCornerRadius();
            float cornerWidth = cornerRadius;
            float cornerHeight = cornerRadius;
            if (cornerRadius > 0) {
                cornerHeight = Math.max(1.0f, cornerHeight - ((float)w + cornerHeight / 64.0f));
                cornerWidth = Math.max(1.0f, cornerWidth - ((float)w + cornerWidth / 64.0f));
            }
            graphics.setLineWidth(((Integer)borderDef.getWeight().content()).intValue());
            graphics.setForegroundColor(this.resourceCache.getColor((Color)borderDef.getColor().content()));
            graphics.setLineStyle(FigureUtil.convertLineStyle((LineStyle)borderDef.getStyle().content()));
            graphics.drawRoundRectangle(rectangle, Math.max(0, (int)cornerWidth), Math.max(0, (int)cornerHeight));
        } else {
            int y2;
            int x2;
            int y;
            int x;
            int inset;
            int w;
            if ((Integer)borderDef.getWeight().content() > 0) {
                w = (Integer)borderDef.getWeight().content();
                graphics.setLineWidth(w);
                graphics.setForegroundColor(this.resourceCache.getColor((Color)borderDef.getColor().content()));
                graphics.setLineStyle(FigureUtil.convertLineStyle((LineStyle)borderDef.getStyle().content()));
                inset = Math.max(1, w >> 1);
                x = rectangle.x;
                y = rectangle.y + inset;
                x2 = rectangle.x + rectangle.width;
                graphics.drawLine(x, y, x2, y);
            }
            if ((Integer)(borderDef = this.rectPresentation.getBottomBorder()).getWeight().content() > 0) {
                w = (Integer)borderDef.getWeight().content();
                graphics.setLineWidth(w);
                graphics.setForegroundColor(this.resourceCache.getColor((Color)borderDef.getColor().content()));
                graphics.setLineStyle(FigureUtil.convertLineStyle((LineStyle)borderDef.getStyle().content()));
                inset = Math.max(1, w >> 1);
                x = rectangle.x;
                y = rectangle.y + rectangle.height - inset;
                x2 = rectangle.x + rectangle.width;
                graphics.drawLine(x, y, x2, y);
            }
            if ((Integer)(borderDef = this.rectPresentation.getLeftBorder()).getWeight().content() > 0) {
                w = (Integer)borderDef.getWeight().content();
                graphics.setLineWidth(w);
                graphics.setForegroundColor(this.resourceCache.getColor((Color)borderDef.getColor().content()));
                graphics.setLineStyle(FigureUtil.convertLineStyle((LineStyle)borderDef.getStyle().content()));
                inset = Math.max(1, w >> 1);
                x = rectangle.x + inset;
                y = rectangle.y;
                y2 = rectangle.y + rectangle.height;
                graphics.drawLine(x, y, x, y2);
            }
            if ((Integer)(borderDef = this.rectPresentation.getRightBorder()).getWeight().content() > 0) {
                w = (Integer)borderDef.getWeight().content();
                graphics.setLineWidth(w);
                graphics.setForegroundColor(this.resourceCache.getColor((Color)borderDef.getColor().content()));
                graphics.setLineStyle(FigureUtil.convertLineStyle((LineStyle)borderDef.getStyle().content()));
                inset = Math.max(1, w >> 1);
                x = rectangle.x + rectangle.width - inset;
                y = rectangle.y;
                y2 = rectangle.y + rectangle.height;
                graphics.drawLine(x, y, x, y2);
            }
        }
    }

    private boolean hasUniformBorders() {
        Color tc = (Color)this.rectPresentation.getTopBorder().getColor().content();
        Color bc = (Color)this.rectPresentation.getBottomBorder().getColor().content();
        Color lc = (Color)this.rectPresentation.getLeftBorder().getColor().content();
        Color rc = (Color)this.rectPresentation.getRightBorder().getColor().content();
        if (!(tc.equals((Object)bc) && tc.equals((Object)lc) && tc.equals((Object)rc))) {
            return false;
        }
        int tw = (Integer)this.rectPresentation.getTopBorder().getWeight().content();
        int bw = (Integer)this.rectPresentation.getBottomBorder().getWeight().content();
        int lw = (Integer)this.rectPresentation.getLeftBorder().getWeight().content();
        int rw = (Integer)this.rectPresentation.getRightBorder().getWeight().content();
        if (tw != bw || tw != lw || tw != rw) {
            return false;
        }
        LineStyle ts = (LineStyle)this.rectPresentation.getTopBorder().getStyle().content();
        LineStyle bs = (LineStyle)this.rectPresentation.getBottomBorder().getStyle().content();
        LineStyle ls = (LineStyle)this.rectPresentation.getLeftBorder().getStyle().content();
        LineStyle rs = (LineStyle)this.rectPresentation.getRightBorder().getStyle().content();
        return ts == bs && ts == ls && ts == rs;
    }
}

