/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.sapphire.ui.Point;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.SapphireDiagramEditor;
import org.eclipse.sapphire.ui.swt.gef.layout.NodeJoiningDirectedGraphLayout;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;

public abstract class DiagramGraphLayout {
    private static final int PADDING = 36;

    public abstract int getGraphDirection();

    public void layout(SapphireDiagramEditor diagramEditor) {
        this.layout(diagramEditor, false);
    }

    public void layout(SapphireDiagramEditor diagramEditor, boolean autoLayout) {
        DirectedGraph graph = this.mapDiagramToGraph(diagramEditor);
        graph.setDefaultPadding(new Insets(36));
        new NodeJoiningDirectedGraphLayout().visit(graph);
        this.mapGraphCoordinatesToDiagram(graph, diagramEditor, autoLayout);
    }

    private DirectedGraph mapDiagramToGraph(SapphireDiagramEditor diagramEditor) {
        DiagramModel diagramModel = diagramEditor.getDiagramModel();
        HashMap<DiagramNodeModel, Node> shapeToNode = new HashMap<DiagramNodeModel, Node>();
        DirectedGraph dg = new DirectedGraph();
        dg.setDirection(this.getGraphDirection());
        EdgeList edgeList = new EdgeList();
        NodeList nodeList = new NodeList();
        List<DiagramNodeModel> children = diagramModel.getNodes();
        for (DiagramNodeModel child : children) {
            Node node = new Node();
            Rectangle bounds = child.getShapePresentation().getFigure().getBounds();
            node.x = bounds.x;
            node.y = bounds.y;
            node.width = bounds.width;
            node.height = bounds.height;
            node.data = child;
            shapeToNode.put(child, node);
            nodeList.add((Object)node);
        }
        List<DiagramConnectionModel> connections = diagramModel.getConnections();
        for (DiagramConnectionModel connection : connections) {
            DiagramNodeModel targetNode;
            DiagramNodeModel sourceNode = connection.getSourceNode();
            if (sourceNode == (targetNode = connection.getTargetNode())) continue;
            Edge edge = new Edge((Object)connection, (Node)shapeToNode.get(sourceNode), (Node)shapeToNode.get(targetNode));
            edge.weight = 2;
            edge.data = connection;
            edgeList.add((Object)edge);
        }
        dg.nodes = nodeList;
        dg.edges = edgeList;
        return dg;
    }

    private void mapGraphCoordinatesToDiagram(DirectedGraph graph, SapphireDiagramEditor diagramEditor, boolean autoLayout) {
        diagramEditor.getConfigurationManager().getConnectionRouter().clear();
        this.mapGraphNodeCoordinatesToDiagram(graph, autoLayout);
        this.mapGraphEdgeCoordinatesToDiagram(graph, diagramEditor, autoLayout);
    }

    private void mapGraphNodeCoordinatesToDiagram(DirectedGraph graph, boolean autoLayout) {
        NodeList myNodes = new NodeList();
        myNodes.addAll((Collection)graph.nodes);
        for (Object object : myNodes) {
            Node node = (Node)object;
            DiagramNodeModel nodeModel = (DiagramNodeModel)node.data;
            DiagramNodePart nodePart = nodeModel.getModelPart();
            nodePart.setNodeBounds(node.x, node.y, autoLayout, false);
        }
    }

    private void mapGraphEdgeCoordinatesToDiagram(DirectedGraph graph, SapphireDiagramEditor diagramEditor, boolean autoLayout) {
        EdgeList myEdges = new EdgeList();
        myEdges.addAll((Collection)graph.edges);
        DiagramConfigurationManager configManager = diagramEditor.getConfigurationManager();
        for (Object object : myEdges) {
            Edge edge = (Edge)object;
            if (!(edge.data instanceof DiagramConnectionModel)) continue;
            DiagramConnectionModel conn = (DiagramConnectionModel)edge.data;
            NodeList nodes = edge.vNodes;
            DiagramConnectionPart connPart = conn.getModelPart();
            ArrayList<Point> connBendPoints = new ArrayList<Point>();
            if (nodes != null) {
                int i = 0;
                while (i < nodes.size()) {
                    Node vn = nodes.getNode(i);
                    int x = vn.x;
                    int y = vn.y;
                    if (this.getGraphDirection() == 16) {
                        if (edge.isFeedback()) {
                            connBendPoints.add(new Point(x + vn.width, y));
                            connBendPoints.add(new Point(x, y));
                        } else {
                            connBendPoints.add(new Point(x, y));
                            connBendPoints.add(new Point(x + vn.width, y));
                        }
                    } else if (edge.isFeedback()) {
                        connBendPoints.add(new Point(x, y + vn.height));
                        connBendPoints.add(new Point(x, y));
                    } else {
                        connBendPoints.add(new Point(x, y));
                        connBendPoints.add(new Point(x, y + vn.height));
                    }
                    ++i;
                }
            } else {
                org.eclipse.draw2d.geometry.Point bendPoint = configManager.getConnectionRouter().route(conn);
                if (bendPoint != null) {
                    connBendPoints.add(new Point(bendPoint.x, bendPoint.y));
                }
            }
            connPart.resetBendpoints(connBendPoints);
            connPart.setLabelPosition(null);
        }
    }
}

