/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ActionsSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.FactsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.InfoSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ProblemsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ProblemsSectionAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.PropertyEditorAssistDialog;
import org.eclipse.sapphire.ui.assist.internal.ResetActionsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.RestoreInitialValueActionsAssistContributor;
import org.eclipse.sapphire.ui.assist.internal.ShowInSourceActionAssistContributor;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.ValidationMarkerContentEvent;
import org.eclipse.sapphire.ui.diagram.editor.ValidationMarkerPart;
import org.eclipse.sapphire.ui.diagram.shape.def.ValidationMarkerSize;
import org.eclipse.sapphire.ui.forms.swt.SwtResourceCache;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.ui.swt.gef.figures.SmoothImageFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ValidationMarkerPresentation
extends ShapePresentation {
    private static final ImageDescriptor IMG_ERROR_SMALL = SwtUtil.createImageDescriptor(SmoothImageFigure.class, (String)"error_small.png");
    private static final ImageDescriptor IMG_ERROR = SwtUtil.createImageDescriptor(SmoothImageFigure.class, (String)"error.gif");
    private static final ImageDescriptor IMG_WARNING_SMALL = SwtUtil.createImageDescriptor(SmoothImageFigure.class, (String)"warning_small.png");
    private static final ImageDescriptor IMG_WARNING = SwtUtil.createImageDescriptor(SmoothImageFigure.class, (String)"warning.gif");
    private static final List<Class<? extends PropertyEditorAssistContributor>> SYSTEM_CONTRIBUTORS = new ArrayList<Class<? extends PropertyEditorAssistContributor>>();
    private SwtResourceCache imageCache;
    private PropertyEditorAssistContext assistContext;
    private IFigure validationMarkerFigure;
    private Status problem;
    private final List<PropertyEditorAssistContributor> contributors;
    private Listener validationListener;

    static {
        SYSTEM_CONTRIBUTORS.add(InfoSectionAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(FactsAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ProblemsSectionAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ActionsSectionAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ResetActionsAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(RestoreInitialValueActionsAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ShowInSourceActionAssistContributor.class);
        SYSTEM_CONTRIBUTORS.add(ProblemsAssistContributor.class);
    }

    public ValidationMarkerPresentation(DiagramPresentation parent, ValidationMarkerPart validationMarkerPart, DiagramResourceCache resourceCache) {
        super(parent, (ShapePart)validationMarkerPart, resourceCache);
        DiagramNodePart nodePart = (DiagramNodePart)validationMarkerPart.nearest(DiagramNodePart.class);
        this.imageCache = nodePart.getSwtResourceCache();
        this.contributors = new ArrayList<PropertyEditorAssistContributor>();
        ArrayList<Class<? extends PropertyEditorAssistContributor>> contributorClasses = new ArrayList<Class<? extends PropertyEditorAssistContributor>>();
        contributorClasses.addAll(SYSTEM_CONTRIBUTORS);
        for (Class clazz : contributorClasses) {
            try {
                this.contributors.add((PropertyEditorAssistContributor)clazz.newInstance());
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
        }
        Listener listener = new Listener(){

            public void handle(Event event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ValidationMarkerPresentation.this.refreshAssistContext();
                    }
                });
            }
        };
        for (PropertyEditorAssistContributor contributor : this.contributors) {
            try {
                contributor.init(this.getContainerPart());
            }
            catch (Exception e) {
                ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
            }
            contributor.attach(listener);
        }
        Collections.sort(this.contributors, new Comparator<PropertyEditorAssistContributor>(){

            @Override
            public int compare(PropertyEditorAssistContributor c1, PropertyEditorAssistContributor c2) {
                return c1.getPriority() - c2.getPriority();
            }
        });
        this.validationListener = new FilteredListener<ValidationMarkerContentEvent>(){

            protected void handleTypedEvent(ValidationMarkerContentEvent event) {
                ValidationMarkerPresentation.this.refresh();
            }
        };
        this.part().attach(this.validationListener);
        this.refresh();
    }

    public ValidationMarkerPart part() {
        return (ValidationMarkerPart)super.part();
    }

    public ValidationMarkerSize getSize() {
        return this.part().getSize();
    }

    @Override
    public void dispose() {
        this.part().detach(this.validationListener);
    }

    @Override
    public void render() {
        this.refresh();
        this.setFigure(this.validationMarkerFigure);
    }

    private SapphirePart getContainerPart() {
        return this.part().getContainerParent();
    }

    private void refresh() {
        this.refreshAssistContext();
        Image image = null;
        Status status = this.part().content();
        ValidationMarkerSize size = this.getSize();
        if (this.part().visible()) {
            if (status.severity() == Status.Severity.WARNING) {
                image = size == ValidationMarkerSize.SMALL ? this.imageCache.image(IMG_WARNING_SMALL) : this.imageCache.image(IMG_WARNING);
            } else if (status.severity() == Status.Severity.ERROR) {
                image = size == ValidationMarkerSize.SMALL ? this.imageCache.image(IMG_ERROR_SMALL) : this.imageCache.image(IMG_ERROR);
            }
        }
        if (image != null) {
            this.validationMarkerFigure = new SmoothImageFigure(image);
            this.addMouseListener();
        } else {
            this.validationMarkerFigure = null;
        }
    }

    public IFigure getValidationMarkerFigure() {
        return this.validationMarkerFigure;
    }

    private void addMouseListener() {
        this.validationMarkerFigure.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ValidationMarkerPresentation.this.validationMarkerFigure.setCursor(Display.getCurrent().getSystemCursor(21));
            }
        });
        this.validationMarkerFigure.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                me.consume();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ValidationMarkerPresentation.this.openAssistDialog();
                    }
                });
            }
        });
    }

    private void openAssistDialog() {
        PropertyEditorAssistContext assistContext = this.getAssistContext();
        if (assistContext != null && !assistContext.isEmpty()) {
            this.getConfigurationManager().getDiagramEditor().getContextButtonManager().hideContextButtonsInstantly();
            Rectangle decoratorControlBounds = this.getFigure().getBounds().getCopy();
            Point draw2dPosition = new Point(decoratorControlBounds.x + decoratorControlBounds.width + 2, decoratorControlBounds.y + 2);
            FigureCanvas canvas = this.getConfigurationManager().getDiagramEditor().getFigureCanvas();
            this.getFigure().translateToAbsolute((Translatable)draw2dPosition);
            org.eclipse.swt.graphics.Point swtPosition = new org.eclipse.swt.graphics.Point(draw2dPosition.x, draw2dPosition.y);
            swtPosition = canvas.getDisplay().map((Control)canvas, null, swtPosition);
            PropertyEditorAssistDialog dialog = new PropertyEditorAssistDialog(this.getConfigurationManager().getDiagramEditor().getEditorSite().getShell(), swtPosition, this.assistContext);
            dialog.open();
        }
    }

    private PropertyEditorAssistContext getAssistContext() {
        if (this.assistContext == null) {
            SapphirePart parentPart = this.getContainerPart();
            this.assistContext = new PropertyEditorAssistContext(parentPart, this.page().getSite().getShell());
            this.problem = this.part().content();
            for (PropertyEditorAssistContributor c : this.contributors) {
                c.contribute(this.assistContext);
            }
            if (this.assistContext.isEmpty()) {
                this.assistContext = null;
            } else {
                Status.Severity valResultSeverity = this.problem.severity();
                if (valResultSeverity != Status.Severity.ERROR && valResultSeverity != Status.Severity.WARNING) {
                    this.problem = null;
                }
            }
        }
        return this.assistContext;
    }

    private void refreshAssistContext() {
        this.assistContext = null;
    }
}

