/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.viatra.query.runtime.registry.IDefaultRegistryView;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IRegistrySourceConnector;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFactory;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.impl.QuerySpecificationRegistryImpl;

public class QuerySpecificationRegistry
implements IQuerySpecificationRegistry {
    private static final QuerySpecificationRegistry INSTANCE = new QuerySpecificationRegistry();
    private final QuerySpecificationRegistryImpl internalRegistry = new QuerySpecificationRegistryImpl();
    private final Set<IRegistrySourceConnector> delayedConnectors = Sets.newHashSet();

    public static IQuerySpecificationRegistry getInstance() {
        return INSTANCE;
    }

    protected QuerySpecificationRegistry() {
    }

    protected IQuerySpecificationRegistry getInternalRegistry() {
        if (!this.delayedConnectors.isEmpty()) {
            ImmutableSet delayed = ImmutableSet.copyOf(this.delayedConnectors);
            for (IRegistrySourceConnector connector : delayed) {
                this.internalRegistry.addSource(connector);
                this.delayedConnectors.remove(connector);
            }
        }
        return this.internalRegistry;
    }

    protected void addDelayedSourceConnector(IRegistrySourceConnector connector) {
        this.delayedConnectors.add(connector);
    }

    @Override
    public boolean addSource(IRegistrySourceConnector connector) {
        return this.getInternalRegistry().addSource(connector);
    }

    @Override
    public boolean removeSource(IRegistrySourceConnector connector) {
        return this.getInternalRegistry().removeSource(connector);
    }

    @Override
    public IDefaultRegistryView getDefaultView() {
        return this.getInternalRegistry().getDefaultView();
    }

    @Override
    public IRegistryView createView() {
        return this.getInternalRegistry().createView();
    }

    @Override
    public IRegistryView createView(IRegistryViewFilter filter) {
        return this.getInternalRegistry().createView(filter);
    }

    @Override
    public IRegistryView createView(IRegistryViewFactory factory) {
        return this.getInternalRegistry().createView(factory);
    }
}

