/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.arrowtype.AbstractArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowType;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowtypePackage;
import org.eclipse.gef.dot.internal.language.arrowtype.DeprecatedArrowShape;
import org.eclipse.gef.dot.internal.language.arrowtype.PrimitiveShape;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotArrowTypeJavaValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class DotArrowTypeJavaValidator
extends AbstractDotArrowTypeJavaValidator {
    @Check
    public void checkOpenModifier(ArrowShape arrowShape) {
        PrimitiveShape shape = arrowShape.getShape();
        if (arrowShape.isOpen() && (PrimitiveShape.CROW.equals((Object)shape) || PrimitiveShape.CURVE.equals((Object)shape) || PrimitiveShape.ICURVE.equals((Object)shape) || PrimitiveShape.NONE.equals((Object)shape) || PrimitiveShape.TEE.equals((Object)shape) || PrimitiveShape.VEE.equals((Object)shape))) {
            this.reportRangeBasedWarning("The open modifier 'o' may not be combined with primitive shape '" + (Object)((Object)shape) + "'.", arrowShape, (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__OPEN);
        }
    }

    @Check
    public void checkSideModifier(ArrowShape arrowShape) {
        PrimitiveShape shape = arrowShape.getShape();
        if (arrowShape.getSide() != null && (PrimitiveShape.DOT.equals((Object)shape) || PrimitiveShape.NONE.equals((Object)shape))) {
            this.reportRangeBasedWarning("The side modifier '" + arrowShape.getSide() + "' may not be combined with primitive shape '" + (Object)((Object)shape) + "'.", arrowShape, (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__SIDE);
        }
    }

    @Check
    public void checkDeprecatedArrowShape(DeprecatedArrowShape arrowShape) {
        this.reportRangeBasedWarning("The shape '" + (Object)((Object)arrowShape.getShape()) + "' is deprecated.", arrowShape, (EStructuralFeature)ArrowtypePackage.Literals.DEPRECATED_ARROW_SHAPE__SHAPE);
    }

    @Check
    public void checkIfNoneIsTheLastArrowShape(ArrowType arrowType) {
        AbstractArrowShape lastShape;
        int numberOfArrowShapes = arrowType.getArrowShapes().size();
        if (numberOfArrowShapes > 1 && (lastShape = (AbstractArrowShape)arrowType.getArrowShapes().get(numberOfArrowShapes - 1)) instanceof ArrowShape && ((ArrowShape)lastShape).getShape() == PrimitiveShape.NONE) {
            this.warning("The shape '" + (Object)((Object)PrimitiveShape.NONE) + "' may not be the last shape.", lastShape, (EStructuralFeature)ArrowtypePackage.Literals.ARROW_SHAPE__SHAPE);
        }
    }

    private void reportRangeBasedWarning(String message, EObject object, EStructuralFeature feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        String code = null;
        String[] issueData = null;
        if (object instanceof DeprecatedArrowShape) {
            DeprecatedArrowShape arrowShape = (DeprecatedArrowShape)object;
            issueData = new String[]{arrowShape.getShape().toString()};
        }
        this.getMessageAcceptor().acceptWarning(message, object, offset, length, code, issueData);
    }
}

