/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.presentation.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jwt.we.conf.presentation.i18n.ConfEditorMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DevtimeEcoreExtendedLoadResourceDialog
extends LoadResourceAction.LoadResourceDialog {
    protected static final Object RESOURCE_URI_SEPARATOR = "  ";
    protected Set<EPackage> registeredPackages = new LinkedHashSet<EPackage>();

    public DevtimeEcoreExtendedLoadResourceDialog(Shell parent, EditingDomain domain) {
        super(parent, domain);
    }

    protected boolean processResource(Resource resource) {
        ResourceSet resourceSet = this.domain.getResourceSet();
        if (!resourceSet.getResources().contains((Object)resource)) {
            EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
            for (EPackage ePackage : this.getAllPackages(resource)) {
                packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                this.registeredPackages.add(ePackage);
            }
        }
        return true;
    }

    public Set<EPackage> getRegisteredPackages() {
        return this.registeredPackages;
    }

    protected Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
            }
        };
        while (j.hasNext()) {
            Object content = j.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite buttonComposite = (Composite)composite.getChildren()[0];
        Button browseRegisteredPackagesButton = new Button(buttonComposite, 8);
        browseRegisteredPackagesButton.setText(ConfEditorMessages.browseRegisteredPackages);
        this.prepareBrowseRegisteredPackagesButton(browseRegisteredPackagesButton);
        FormData data = new FormData();
        Control[] children = buttonComposite.getChildren();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(children[0], -10);
        browseRegisteredPackagesButton.setLayoutData((Object)data);
        return composite;
    }

    protected void prepareBrowseRegisteredPackagesButton(Button browseRegisteredPackagesButton) {
        browseRegisteredPackagesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RegisteredPackageDialog registeredPackageDialog = new RegisteredPackageDialog(DevtimeEcoreExtendedLoadResourceDialog.this.getShell());
                registeredPackageDialog.open();
                Object[] result = registeredPackageDialog.getResult();
                if (result != null) {
                    List<Object> nsURIs = Arrays.asList(result);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                    StringBuffer uris = new StringBuffer();
                    Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
                    int i = 0;
                    int length = result.length;
                    while (i < length) {
                        URI location = (URI)ePackageNsURItoGenModelLocationMap.get(result[i]);
                        Resource resource = resourceSet.getResource(location, true);
                        EcoreUtil.resolveAll((Resource)resource);
                        ++i;
                    }
                    block1: for (Resource resource : resourceSet.getResources()) {
                        for (EPackage ePackage : DevtimeEcoreExtendedLoadResourceDialog.this.getAllPackages(resource)) {
                            if (!nsURIs.contains(ePackage.getNsURI())) continue;
                            uris.append(resource.getURI());
                            uris.append(RESOURCE_URI_SEPARATOR);
                            continue block1;
                        }
                    }
                    DevtimeEcoreExtendedLoadResourceDialog.this.uriField.setText((String.valueOf(DevtimeEcoreExtendedLoadResourceDialog.this.uriField.getText()) + RESOURCE_URI_SEPARATOR + uris.toString()).trim());
                }
            }
        });
    }

    public static class RegisteredPackageDialog
    extends ElementListSelectionDialog {
        protected boolean isDevelopmentTimeVersion = true;

        public RegisteredPackageDialog(Shell parent) {
            super(parent, (ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.INSTANCE.getImage("full/obj16/EPackage"));
                }
            });
            this.setMultipleSelection(true);
            this.setMessage(ConfEditorMessages.selectRegisteredPackageUri);
            this.setFilter("*");
            this.setTitle(ConfEditorMessages.packageSelection);
        }

        protected void updateElements() {
            Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap();
            Object[] result = ePackageNsURItoGenModelLocationMap.keySet().toArray(new Object[ePackageNsURItoGenModelLocationMap.size()]);
            Arrays.sort(result);
            this.setListElements(result);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            this.updateElements();
            return result;
        }
    }
}

