/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.AgentLoader2;
import org.eclipse.mat.ibmvm.acquire.BaseProvider;
import org.eclipse.mat.ibmvm.acquire.DumpType;
import org.eclipse.mat.ibmvm.acquire.HprofDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMHeapDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMJavaDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMSystemDumpProvider;
import org.eclipse.mat.ibmvm.acquire.IBMVmInfo;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="IBM Dump (using attach API)")
@Help(value="help for IBM Dump (using attach API)")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/acquiringheapdump.html#task_acquiringheapdump__2")
public class IBMDumpProvider
extends BaseProvider {
    private static File agentJar;

    public IBMDumpProvider() {
        try {
            Class.forName("com.ibm.jvm.Dump");
        }
        catch (ClassNotFoundException e) {
            this.defaultType = DumpType.HPROF;
        }
    }

    String dumpName() {
        return new File("ibmdump.dmp").getAbsolutePath();
    }

    int files() {
        return 1;
    }

    File jextract(File preferredDump, boolean compress, List<File> dumps, File udir, File javahome, IProgressListener listener) throws IOException, InterruptedException, SnapshotException {
        File original = dumps.get(0);
        if (original.renameTo(preferredDump)) {
            return preferredDump;
        }
        return original;
    }

    long averageFileSize(Collection<File> files) {
        long l = 0L;
        int i = 0;
        for (File f : files) {
            if (!f.isFile()) continue;
            l += f.length();
            ++i;
        }
        return l / (long)i;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File acquireDump(VmInfo info, File preferredLocation, IProgressListener listener) throws SnapshotException {
        IBMVmInfo vminfo = (IBMVmInfo)info;
        IBMDumpProvider helper = this.getDumpProvider(vminfo);
        if (helper != this) {
            return helper.acquireDump(info, preferredLocation, listener);
        }
        listener.beginTask(Messages.getString("IBMDumpProvider.GeneratingDump"), 1980);
        try {
            listener.subTask(MessageFormat.format(Messages.getString("IBMDumpProvider.AttachingToVM"), vminfo.getPidName()));
            VirtualMachine vm = VirtualMachine.attach(vminfo.getPidName());
            try {
                File udir;
                Properties props = vm.getSystemProperties();
                String javah = props.getProperty("java.home", System.getProperty("java.home"));
                File javahome = new File(javah);
                if (vminfo.dumpdir == null) {
                    udir = null;
                    if (vminfo.type == DumpType.HPROF) {
                        udir = preferredLocation.getParentFile();
                    }
                    if (udir == null) {
                        String userdir = this.guessDumpLocation(props);
                        udir = new File(userdir);
                    }
                    vminfo.dumpdir = udir;
                } else {
                    udir = vminfo.dumpdir;
                }
                File[] f1 = udir.listFiles();
                if (f1 == null) {
                    throw new FileNotFoundException(udir.getPath());
                }
                HashSet<File> previous = new HashSet<File>(Arrays.asList(f1));
                long avg = this.averageFileSize(previous);
                String jar = IBMDumpProvider.getAgentJar().getAbsolutePath();
                listener.subTask(Messages.getString("IBMDumpProvider.StartingAgent"));
                AgentLoader t = new AgentLoader(jar, vm, vminfo.agentCommand(new File(udir, preferredLocation.getName())));
                t.start();
                List<File> newFiles = this.progress(udir, previous, this.files(), avg, t, listener);
                if (listener.isCanceled()) {
                    t.interrupt();
                    return null;
                }
                if (t.failed()) {
                    t.throwFailed(listener);
                }
                listener.done();
                if (newFiles.isEmpty()) {
                    String msg = MessageFormat.format(Messages.getString("IBMDumpProvider.UnableToFindDump"), udir.getAbsoluteFile());
                    throw new FileNotFoundException(msg);
                }
                File file = this.jextract(preferredLocation, vminfo.compress, newFiles, udir, javahome, listener);
                return file;
            }
            catch (InterruptedException e) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.getString("IBMDumpProvider.Interrupted"), (Throwable)e);
                throw new SnapshotException(Messages.getString("IBMDumpProvider.Interrupted"), (Throwable)e);
            }
            finally {
                vm.detach();
            }
        }
        catch (IOException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.getString("IBMDumpProvider.UnableToGenerateDump"), (Throwable)e);
            throw new SnapshotException(Messages.getString("IBMDumpProvider.UnableToGenerateDump"), (Throwable)e);
        }
        catch (SnapshotException e) {
            throw e;
        }
        catch (AttachNotSupportedException e) {
            info.setHeapDumpEnabled(false);
            String msg = MessageFormat.format(Messages.getString("IBMDumpProvider.UnsuitableVM"), info.toString());
            listener.sendUserMessage(IProgressListener.Severity.WARNING, msg, (Throwable)e);
            throw new SnapshotException(msg, (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<File> progress(File udir, Collection<File> previous, int nfiles, long avg, AgentLoader2 loader, IProgressListener listener) throws InterruptedException, FileNotFoundException {
        listener.subTask(Messages.getString("IBMDumpProvider.WaitingForDumpFiles"));
        newFiles = new ArrayList<File>();
        l = 0L;
        worked = 0;
        start = System.currentTimeMillis();
        i = 0;
        while ((l = this.fileLengths(udir, previous, newFiles, nfiles)) == 0L && i < 60 && (t = System.currentTimeMillis()) < start + 30000L) {
            Thread.sleep(500L);
            if (listener.isCanceled() || loader.failed()) {
                return null;
            }
            towork = (int)Math.min((t - start) / 500L, 60L);
            listener.worked(towork - worked);
            worked = towork;
            ++i;
        }
        listener.worked(60 - worked);
        worked = 60;
        l0 = l - 1L;
        iFile = 0;
        start = System.currentTimeMillis();
        i = 0;
        j = 0;
        ** GOTO lbl38
        {
            listener.subTask(MessageFormat.format(Messages.getString("IBMDumpProvider.WritingFile"), new Object[]{newFiles.get(iFile++)}));
            do {
                if (iFile < newFiles.size()) continue block1;
                if (l0 != l) {
                    j = 0;
                    towork = (int)(l * 1320L / avg);
                    listener.worked(towork - worked);
                    worked = towork;
                    l0 = l;
                }
                Thread.sleep(500L);
                if (listener.isCanceled() || loader.failed()) {
                    return null;
                }
                listener.worked(1);
                ++i;
lbl38:
                // 2 sources

            } while (((l = this.fileLengths(udir, previous, newFiles, nfiles)) != l0 || j++ < 10 || newFiles.size() > iFile) && i < 600 && (t = System.currentTimeMillis()) < start + 300000L);
        }
        it = newFiles.iterator();
        while (it.hasNext()) {
            f = (File)it.next();
            if (f.exists()) continue;
            it.remove();
        }
        return newFiles;
    }

    private static synchronized File getAgentJar() throws IOException {
        if (agentJar == null || !agentJar.canRead()) {
            agentJar = IBMDumpProvider.makeAgentJar();
        }
        return agentJar;
    }

    private static File makeAgentJar() throws IOException, FileNotFoundException {
        String jarname = "org.eclipse.mat.ibmdumps";
        String[] agents = new String[]{"org.eclipse.mat.ibmvm.agent.DumpAgent"};
        Class[] cls = new Class[]{};
        return IBMDumpProvider.makeJar(jarname, "Agent-class: ", agents, cls);
    }

    List<File> files(File udir, Collection<File> previousFiles, List<File> newFiles) throws FileNotFoundException {
        File[] f2 = udir.listFiles(new NewFileFilter(previousFiles));
        if (f2 == null) {
            throw new FileNotFoundException(udir.getPath());
        }
        List<File> new2 = Arrays.asList(f2);
        Collections.sort(new2, new FileComparator());
        previousFiles.addAll(new2);
        newFiles.addAll(new2);
        return newFiles;
    }

    long fileLengths(File udir, Collection<File> previous, List<File> newFiles, int maxFiles) throws FileNotFoundException {
        List<File> nw = this.files(udir, previous, newFiles);
        long l = 0L;
        int i = 0;
        for (File f : nw) {
            if (!f.exists()) continue;
            if (++i > maxFiles) break;
            l += f.length();
        }
        return l;
    }

    public List<IBMVmInfo> getAvailableVMs(IProgressListener listener) {
        try {
            return this.getAvailableVMs1(listener);
        }
        catch (LinkageError e) {
            return null;
        }
    }

    private List<IBMVmInfo> getAvailableVMs1(IProgressListener listener) {
        int totalwork = 24;
        int provwork = 4;
        listener.beginTask(Messages.getString("IBMDumpProvider.ListingIBMVMs"), totalwork);
        int y = 0;
        int vmcount = VirtualMachine.list().size();
        int x = 0;
        ArrayList<IBMVmInfo> jvms = new ArrayList<IBMVmInfo>();
        List<AttachProvider> provs = AttachProvider.providers();
        int provcount = provs.size();
        block0: for (AttachProvider prov : provs) {
            listener.subTask(MessageFormat.format(Messages.getString("IBMDumpProvider.ListingFirst"), prov.name()));
            List<VirtualMachineDescriptor> list = prov.listVirtualMachines();
            int workp = ++y * provwork / provcount - (y - 1) * provwork / provcount;
            listener.worked(workp);
            listener.subTask(MessageFormat.format(Messages.getString("IBMDumpProvider.ListingDetails"), prov.name()));
            for (VirtualMachineDescriptor vmd : list) {
                IBMVmInfo ifo = this.getVmInfo(vmd);
                jvms.add(ifo);
                int workv = ++x * (totalwork - provwork) / vmcount - (x - 1) * (totalwork - provwork) / vmcount;
                listener.worked(workv);
                if (!listener.isCanceled()) continue;
                this.listAttach = false;
                continue block0;
            }
        }
        listener.done();
        return jvms;
    }

    private IBMVmInfo getVmInfo(VirtualMachineDescriptor vmd) {
        boolean usable = true;
        String unusableCause = "";
        String dir = null;
        String displayName = vmd.displayName();
        if ((vmd.id().equals(displayName) || "".equals(displayName)) && this.listAttach) {
            try {
                VirtualMachine vm = vmd.provider().attachVirtualMachine(vmd);
                try {
                    Properties p = vm.getSystemProperties();
                    dir = p.getProperty("user.dir");
                    displayName = p.getProperty("java.class.path");
                    if (displayName == null || displayName.equals("")) {
                        displayName = dir;
                    }
                    dir = this.guessDumpLocation(p);
                }
                finally {
                    try {
                        vm.detach();
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                try {
                    vm.loadAgent(null, null);
                }
                catch (AgentLoadException p) {
                }
                catch (AgentInitializationException p) {
                }
                catch (LinkageError e) {
                    usable = false;
                    unusableCause = e.getLocalizedMessage();
                }
                catch (NullPointerException e) {
                }
                catch (IOException e) {}
            }
            catch (IOException e) {
                usable = false;
                unusableCause = e.getLocalizedMessage();
            }
            catch (AttachNotSupportedException e) {
                usable = false;
                unusableCause = e.getLocalizedMessage();
            }
        }
        String desc = MessageFormat.format(Messages.getString("IBMDumpProvider.VMDescription"), vmd.provider().name(), vmd.provider().type(), displayName);
        if (!usable) {
            desc = String.valueOf(unusableCause) + " : " + desc;
        }
        IBMVmInfo ifo = new IBMVmInfo(vmd.id(), desc, usable, null, this);
        if (vmd.provider().name().equals("sun")) {
            ifo.type = DumpType.HPROF;
            dir = null;
        } else {
            ifo.type = this.defaultType;
        }
        ifo.live = this.defaultLive;
        ifo.compress = this.defaultCompress;
        if (dir != null) {
            ifo.dumpdir = new File(dir);
        }
        ifo.setHeapDumpEnabled(usable);
        return ifo;
    }

    private String guessDumpLocation(Properties props) {
        File tdira;
        File tracefile;
        File tdir;
        String dir = props.getProperty("user.dir", System.getProperty("user.dir"));
        String tracefilename = props.getProperty("system.trace.file");
        if (tracefilename != null && (tdir = (tracefile = new File(tracefilename)).getParentFile()) != null && tdir.equals(tdira = tdir.getAbsoluteFile())) {
            dir = tdir.getPath();
        }
        return dir;
    }

    public static void main(String[] s) throws Exception {
        IBMDumpProvider prov = new IBMDumpProvider();
        if (s.length < 5 && s.length > 0) {
            prov.listAttach = Boolean.parseBoolean(s[0]);
        }
        StderrProgressListener ii = new StderrProgressListener();
        List<IBMVmInfo> vms = prov.getAvailableVMs1(ii);
        for (VmInfo vmInfo : vms) {
            DumpType tp;
            IBMVmInfo vminfo = (IBMVmInfo)vmInfo;
            String vm = vminfo.getPidName();
            String dir = vminfo.dumpdir != null ? vminfo.dumpdir.getAbsolutePath() : "";
            String proposedFile = vmInfo.getProposedFileName();
            proposedFile = "";
            String vm2 = String.valueOf(vm) + INFO_SEPARATOR + vmInfo.isHeapDumpEnabled() + INFO_SEPARATOR + (Object)((Object)vminfo.type) + INFO_SEPARATOR + proposedFile + INFO_SEPARATOR + dir + INFO_SEPARATOR + vmInfo.getDescription();
            if (s.length < 5) {
                System.out.println(vm2);
                continue;
            }
            if (!vm.equals(s[1])) continue;
            vminfo.type = tp = DumpType.valueOf(s[0]);
            vminfo.live = Boolean.parseBoolean(s[2]);
            vminfo.compress = Boolean.parseBoolean(s[3]);
            if (s.length > 5) {
                vminfo.dumpdir = new File(s[5]);
            }
            File f2 = vminfo.getHeapDumpProvider().acquireDump(vmInfo, new File(s[4]), (IProgressListener)ii);
            System.out.println(f2.getAbsolutePath());
            return;
        }
        if (s.length > 1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("IBMDumpProvider.NoVMFound"), s[1]));
        }
    }

    IBMDumpProvider getDumpProvider(IBMVmInfo info) {
        if (this.getClass() != IBMDumpProvider.class) {
            return this;
        }
        if (info.type == DumpType.SYSTEM) {
            return new IBMSystemDumpProvider();
        }
        if (info.type == DumpType.HEAP) {
            return new IBMHeapDumpProvider();
        }
        if (info.type == DumpType.JAVA) {
            return new IBMJavaDumpProvider();
        }
        if (info.type == DumpType.HPROF) {
            return new HprofDumpProvider();
        }
        return this;
    }

    File mergeFileNames(File preferredDump, File actual) {
        File ret;
        String fn1 = preferredDump.getName();
        String fn1a = fn1.replaceAll("\\d", "#");
        String fn2 = actual.getName();
        String fn2a = fn2.replaceAll("\\d", "#");
        int fi = fn1a.indexOf(fn2a = fn2a.substring(0, fn2a.lastIndexOf(35) + 1));
        if (fi >= 0) {
            String newfn = String.valueOf(fn1.substring(0, fi)) + fn2.substring(0, fn2a.length()) + fn1.substring(fi + fn2a.length());
            ret = new File(preferredDump.getParentFile(), newfn);
        } else {
            ret = preferredDump;
        }
        return ret;
    }

    static class AgentInitializationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AgentInitializationException(Throwable e) {
            super(String.valueOf(e.getMessage()) + " returnValue=" + VirtualMachine.call(e, "returnValue", new Object[0]));
            this.initCause(e);
        }

        int returnValue() {
            return (Integer)VirtualMachine.call(this.getCause(), "returnValue", new Object[0]);
        }
    }

    static class AgentLoadException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AgentLoadException(Throwable e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }

    private static final class AgentLoader
    extends Thread
    implements AgentLoader2 {
        private final String jar;
        private final VirtualMachine vm;
        private final String command;
        private AgentLoadException e1;
        private AgentInitializationException e2;
        private IOException e3;
        private boolean fail;

        private AgentLoader(String jar, VirtualMachine vm, String command) {
            this.jar = jar;
            this.vm = vm;
            this.command = command;
        }

        public void run() {
            try {
                this.vm.loadAgent(this.jar, this.command);
            }
            catch (AgentLoadException e2) {
                this.e1 = e2;
                this.setFailed();
            }
            catch (AgentInitializationException e) {
                this.e2 = e;
                this.setFailed();
            }
            catch (IOException e3) {
                this.e3 = e3;
                this.setFailed();
            }
        }

        public synchronized boolean failed() {
            return this.fail;
        }

        private synchronized void setFailed() {
            this.fail = true;
        }

        public void throwFailed(IProgressListener listener) throws SnapshotException, IOException {
            if (this.e1 != null) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.getString("IBMDumpProvider.AgentLoad"), (Throwable)this.e1);
                throw new SnapshotException(Messages.getString("IBMDumpProvider.AgentLoad"), (Throwable)this.e1);
            }
            if (this.e2 != null) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, Messages.getString("IBMDumpProvider.AgentInitialization"), (Throwable)this.e2);
                throw new SnapshotException(Messages.getString("IBMDumpProvider.AgentInitialization"), (Throwable)this.e2);
            }
            if (this.e3 != null) {
                throw this.e3;
            }
        }
    }

    static class AttachNotSupportedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AttachNotSupportedException(Throwable e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }

    static class AttachOperationFailedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        AttachOperationFailedException(Throwable e) {
            super(e.getMessage());
            this.initCause(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttachProvider {
        Object ap;
        private static Class<?> attCls;

        AttachProvider(Object o) {
            this.ap = o;
        }

        VirtualMachine attachVirtualMachine(VirtualMachineDescriptor vmd) throws IOException, AttachNotSupportedException {
            Object o;
            try {
                o = VirtualMachine.call(this.ap, "attachVirtualMachine", vmd.vmd);
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getCause();
                if (VirtualMachine.isSubclassOf(t, "AttachNotSupportedException")) {
                    throw new AttachNotSupportedException(t);
                }
                if (VirtualMachine.isSubclassOf(t, "AttachOperationFailedException")) {
                    throw new AttachOperationFailedException(t);
                }
                if (t instanceof IOException) {
                    if (t.getMessage().contains("not attach to current VM") || t.getMessage().contains("jdk.attach.allowAttachSelf")) {
                        throw new AttachNotSupportedException(t);
                    }
                    throw (IOException)t;
                }
                throw e;
            }
            return new VirtualMachine(o);
        }

        String name() {
            return (String)VirtualMachine.call(this.ap, "name", new Object[0]);
        }

        String type() {
            return (String)VirtualMachine.call(this.ap, "type", new Object[0]);
        }

        private static Class<?> getStaticClass() throws LinkageError {
            if (attCls == null) {
                attCls = VirtualMachine.getClass("com.ibm.tools.attach.spi.AttachProvider", "com.sun.tools.attach.spi.AttachProvider");
            }
            return attCls;
        }

        static List<AttachProvider> providers() {
            Class<?> apc = AttachProvider.getStaticClass();
            List l = (List)VirtualMachine.call(apc, "providers", new Object[0]);
            ArrayList<AttachProvider> ret = new ArrayList<AttachProvider>(l.size());
            for (Object o : l) {
                AttachProvider ap = new AttachProvider(o);
                ret.add(ap);
            }
            return ret;
        }

        List<VirtualMachineDescriptor> listVirtualMachines() {
            List l = (List)VirtualMachine.call(this.ap, "listVirtualMachines", new Object[0]);
            ArrayList<VirtualMachineDescriptor> ret = new ArrayList<VirtualMachineDescriptor>(l.size());
            for (Object o : l) {
                VirtualMachineDescriptor vmd = new VirtualMachineDescriptor(o);
                ret.add(vmd);
            }
            return ret;
        }

        public String toString() {
            return String.valueOf(this.name()) + " " + this.type();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = -3725792252276130382L;

        private FileComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NewFileFilter
    implements FileFilter {
        private final Collection<File> previousFiles;

        private NewFileFilter(Collection<File> previousFiles) {
            this.previousFiles = previousFiles;
        }

        @Override
        public boolean accept(File f) {
            return !this.previousFiles.contains(f);
        }
    }

    private static final class StderrProgressListener
    implements IProgressListener {
        private StderrProgressListener() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void sendUserMessage(IProgressListener.Severity severity, String message, Throwable exception) {
        }

        public void setCanceled(boolean value) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
            int i = 0;
            while (i < work) {
                System.err.print('.');
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VirtualMachine {
        Object vm;
        private static Class<?> clsVM;
        static URLClassLoader urlcl;

        static boolean isSubclassOf(Throwable e, String classname) {
            Class<?> o = e.getClass();
            while (o != null) {
                if (o.getSimpleName().equals(classname)) {
                    return true;
                }
                o = o.getSuperclass();
            }
            return false;
        }

        static Object call(Object o, String method, Object ... args) {
            Object ret;
            Method[] ms;
            Class[] types = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                types[i] = args[i] != null ? args[i].getClass() : null;
                ++i;
            }
            Method m = null;
            Class<?> cls = o instanceof Class ? (Class<?>)o : o.getClass();
            while (!Modifier.isPublic(cls.getModifiers()) || cls.getPackage().getName().startsWith("ibm.") || cls.getPackage().getName().startsWith("sun.") || cls.getPackage().getName().startsWith("com.ibm.tools.attach.attacher") || cls.getPackage().getName().startsWith("org.")) {
                cls = cls.getSuperclass();
            }
            Method[] methodArray = ms = cls.getMethods();
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                block16: {
                    Method m1 = methodArray[n2];
                    int mods = m1.getModifiers();
                    if (m1.getName().equals(method) && m1.getParameterTypes().length == types.length && Modifier.isPublic(mods) && Modifier.isPublic(m1.getDeclaringClass().getModifiers())) {
                        int i2 = 0;
                        while (i2 < types.length) {
                            Class<?> t = m1.getParameterTypes()[i2];
                            if (types[i2] == null || t.isAssignableFrom(types[i2])) {
                                ++i2;
                                continue;
                            }
                            break block16;
                        }
                        if (m == null) {
                            m = m1;
                        } else {
                            m = null;
                            break;
                        }
                    }
                }
                ++n2;
            }
            if (m == null) {
                try {
                    m = o instanceof Class ? ((Class)o).getMethod(method, types) : o.getClass().getMethod(method, types);
                }
                catch (NoSuchMethodException e) {
                    LinkageError l = new LinkageError();
                    l.initCause(e);
                    throw l;
                }
            }
            try {
                ret = m.invoke(o, args);
            }
            catch (IllegalAccessException e) {
                IllegalArgumentException e2 = new IllegalArgumentException("Object:" + o + " method:" + m + " exception:" + e);
                e2.initCause(e);
                throw e2;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new UndeclaredThrowableException(e.getCause());
            }
            return ret;
        }

        VirtualMachine(Object o) {
            this.vm = o;
        }

        static List<VirtualMachineDescriptor> list() {
            Class<?> c1 = VirtualMachine.getStaticClass();
            List l = (List)VirtualMachine.call(c1, "list", new Object[0]);
            ArrayList<VirtualMachineDescriptor> ret = new ArrayList<VirtualMachineDescriptor>();
            for (Object o : l) {
                VirtualMachineDescriptor vmd1 = new VirtualMachineDescriptor(o);
                ret.add(vmd1);
            }
            return ret;
        }

        public void loadAgent(String jar, String command) throws IOException, AgentLoadException, AgentInitializationException {
            try {
                VirtualMachine.call(this.vm, "loadAgent", jar, command);
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getCause();
                if (VirtualMachine.isSubclassOf(t, "AgentLoadException")) {
                    throw new AgentLoadException(t);
                }
                if (VirtualMachine.isSubclassOf(t, "AgentInitializationException")) {
                    throw new AgentInitializationException(t);
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
        }

        public void loadAgentLibrary(String lib, String command) throws IOException, AgentLoadException, AgentInitializationException {
            try {
                VirtualMachine.call(this.vm, "loadAgentLibrary", lib, command);
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getCause();
                if (VirtualMachine.isSubclassOf(t, "AgentLoadException")) {
                    throw new AgentLoadException(t);
                }
                if (VirtualMachine.isSubclassOf(t, "AgentInitializationException")) {
                    throw new AgentInitializationException(t);
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
        }

        static VirtualMachine attach(String nm) throws IOException, AttachNotSupportedException {
            Object o;
            Class<?> c1 = VirtualMachine.getStaticClass();
            try {
                o = VirtualMachine.call(c1, "attach", nm);
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getCause();
                if (VirtualMachine.isSubclassOf(t, "AttachNotSupportedException")) {
                    throw new AttachNotSupportedException(t);
                }
                if (t instanceof IOException) {
                    if (t.getMessage().contains("not attach to current VM") || t.getMessage().contains("jdk.attach.allowAttachSelf")) {
                        throw new AttachNotSupportedException(t);
                    }
                    throw (IOException)t;
                }
                throw e;
            }
            return new VirtualMachine(o);
        }

        private static Class<?> getStaticClass() throws LinkageError {
            if (clsVM == null) {
                clsVM = VirtualMachine.getClass("com.ibm.tools.attach.VirtualMachine", "com.sun.tools.attach.VirtualMachine");
            }
            return clsVM;
        }

        static Class<?> getClass(String cn1, String cn2) throws LinkageError {
            Class<?> c1;
            try {
                c1 = Class.forName(cn1);
            }
            catch (ClassNotFoundException e) {
                try {
                    c1 = Class.forName(cn2);
                }
                catch (ClassNotFoundException e2) {
                    File f = new File(System.getProperty("java.home"));
                    f = f.getParentFile();
                    if (f != null) {
                        f = new File(f, "lib");
                        if ((f = new File(f, "tools.jar")).canRead()) {
                            try {
                                if (urlcl == null) {
                                    urlcl = new URLClassLoader(new URL[]{f.toURI().toURL()});
                                }
                                try {
                                    return urlcl.loadClass(cn2);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                }
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                        }
                    }
                    LinkageError l = new LinkageError();
                    l.initCause(e2);
                    throw l;
                }
            }
            return c1;
        }

        Properties getAgentProperties() throws IOException {
            try {
                return (Properties)VirtualMachine.call(this.vm, "getAgentProperties", new Object[0]);
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
        }

        Properties getSystemProperties() throws IOException {
            try {
                return (Properties)VirtualMachine.call(this.vm, "getSystemProperties", new Object[0]);
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
        }

        void detach() throws IOException {
            try {
                VirtualMachine.call(this.vm, "detach", new Object[0]);
            }
            catch (UndeclaredThrowableException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw e;
            }
        }
    }

    static class VirtualMachineDescriptor {
        String name;
        String id;
        String displayName;
        AttachProvider pr;
        Object vmd;

        VirtualMachineDescriptor(Object vmd) {
            this.vmd = vmd;
            this.pr = new AttachProvider(VirtualMachine.call(vmd, "provider", new Object[0]));
            this.id = (String)VirtualMachine.call(vmd, "id", new Object[0]);
            this.displayName = (String)VirtualMachine.call(vmd, "displayName", new Object[0]);
        }

        String displayName() {
            return this.displayName;
        }

        String id() {
            return this.id;
        }

        AttachProvider provider() {
            return this.pr;
        }
    }
}

