/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.color;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.SystemColors;
import org.eclipse.sirius.viewpoint.description.UserFixedColor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ColorManager {
    private static final List<SystemColors> GRAYED_COLORS = Arrays.asList(SystemColors.BLACK_LITERAL, SystemColors.DARK_GRAY_LITERAL, SystemColors.GRAY_LITERAL, SystemColors.LIGHT_GRAY_LITERAL, SystemColors.WHITE_LITERAL);
    private static final List<SystemColors> RAINBOW_COLORS = Arrays.asList(SystemColors.DARK_RED_LITERAL, SystemColors.RED_LITERAL, SystemColors.LIGHT_RED_LITERAL, SystemColors.DARK_CHOCOLATE_LITERAL, SystemColors.CHOCOLATE_LITERAL, SystemColors.LIGHT_CHOCOLATE_LITERAL, SystemColors.DARK_ORANGE_LITERAL, SystemColors.ORANGE_LITERAL, SystemColors.LIGHT_ORANGE_LITERAL, SystemColors.DARK_YELLOW_LITERAL, SystemColors.YELLOW_LITERAL, SystemColors.LIGHT_YELLOW_LITERAL, SystemColors.DARK_GREEN_LITERAL, SystemColors.GREEN_LITERAL, SystemColors.LIGHT_GREEN_LITERAL, SystemColors.DARK_BLUE_LITERAL, SystemColors.BLUE_LITERAL, SystemColors.LIGHT_BLUE_LITERAL, SystemColors.DARK_PURPLE_LITERAL, SystemColors.PURPLE_LITERAL, SystemColors.LIGHT_PURPLE_LITERAL);
    private static ColorManager defaultInstance;
    private Map<String, Color> lighterColorCache = new HashMap<String, Color>();

    protected ColorManager() {
    }

    public static ColorManager getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new ColorManager();
        }
        return defaultInstance;
    }

    public Color getLighterColor(RGBValues colorToLight) {
        String key = this.getKey(colorToLight);
        if (!this.lighterColorCache.containsKey(key)) {
            Color newLighterColor = FigureUtilities.mixColors((Color)VisualBindingManager.getDefault().getColorFromRGBValues(colorToLight), (Color)ColorConstants.white, (double)0.4);
            this.lighterColorCache.put(key, newLighterColor);
        }
        return this.lighterColorCache.get(key);
    }

    private String getKey(RGBValues color) {
        StringBuilder sb = new StringBuilder("Color");
        if (color != null) {
            sb.append("_r:");
            sb.append(color.getRed());
            sb.append("_g:");
            sb.append(color.getGreen());
            sb.append("_b:");
            sb.append(color.getBlue());
        }
        return sb.toString();
    }

    public Map<String, RGB> collectVsmAndDefaultColors(Session session) {
        List palettes = session.getSelectedViewpoints(true).stream().map(EObject::eContainer).map(Group.class::cast).flatMap(group -> group.getUserColorsPalettes().stream()).collect(Collectors.toList());
        Map<String, RGB> vsmColors = palettes.stream().flatMap(palette -> palette.getEntries().stream()).filter(UserFixedColor.class::isInstance).map(UserFixedColor.class::cast).collect(Collectors.toMap(c -> c.getName(), c -> new RGB(c.getRed(), c.getGreen(), c.getBlue()), (rgb1, rgb2) -> rgb1));
        Map systemColors = VisualBindingManager.getDefault().getSystemPalette();
        LinkedHashMap<String, RGB> colors = new LinkedHashMap<String, RGB>();
        for (SystemColors color : GRAYED_COLORS) {
            colors.put(color.getName(), (RGB)systemColors.get(color.getName()));
        }
        for (String colorName : vsmColors.keySet()) {
            colors.put(colorName, vsmColors.get(colorName));
        }
        for (SystemColors color : RAINBOW_COLORS) {
            colors.put(color.getName(), (RGB)systemColors.get(color.getName()));
        }
        return colors;
    }
}

