/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.dot.dot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GraphType implements Enumerator
{
    GRAPH(0, "graph", "graph"),
    DIGRAPH(1, "digraph", "digraph");

    public static final int GRAPH_VALUE = 0;
    public static final int DIGRAPH_VALUE = 1;
    private static final GraphType[] VALUES_ARRAY;
    public static final List<GraphType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GraphType[]{GRAPH, DIGRAPH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GraphType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GraphType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GraphType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GraphType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GraphType get(int value) {
        switch (value) {
            case 0: {
                return GRAPH;
            }
            case 1: {
                return DIGRAPH;
            }
        }
        return null;
    }

    private GraphType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

