/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task.operations;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.tool.Navigation;
import org.eclipse.sirius.diagram.tools.api.command.view.CreateDiagramWithInitialOperation;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class NavigationTask
extends AbstractOperationTask {
    private final Navigation operation;
    private final UICallBack uiCallback;

    public NavigationTask(CommandContext context, ModelAccessor extPackage, Navigation operation, IInterpreter interpreter, UICallBack uiCallback) {
        super(context, extPackage, interpreter);
        this.operation = operation;
        this.uiCallback = uiCallback;
    }

    public void execute() {
        if (this.operation != null) {
            EObject element = this.getElement();
            if (element instanceof DDiagramElement) {
                DDiagramElement ddiagramElement = (DDiagramElement)element;
                for (EObject semanticEObject : ddiagramElement.getSemanticElements()) {
                    if (!this.openRepresentation(semanticEObject)) continue;
                    return;
                }
            } else {
                this.openRepresentation(element);
            }
        }
    }

    private boolean openRepresentation(EObject semanticEObject) {
        DiagramDescription diagramDescriptionToOpen = this.operation.getDiagramDescription();
        Session session = SessionManager.INSTANCE.getSession(semanticEObject);
        Collection otherRepresentations = DialectManager.INSTANCE.getRepresentations(semanticEObject, session);
        DRepresentation findOpenableRepresentation = this.findOpenableRepresentation(otherRepresentations, diagramDescriptionToOpen, session);
        boolean representationOpened = false;
        if (findOpenableRepresentation != null) {
            this.uiCallback.openRepresentation(session, findOpenableRepresentation);
            representationOpened = true;
        } else if (this.operation.isCreateIfNotExistent()) {
            CreateDiagramWithInitialOperation createDiagramWithInitialOperation = new CreateDiagramWithInitialOperation(diagramDescriptionToOpen, semanticEObject, this.uiCallback, (IProgressMonitor)new NullProgressMonitor());
            createDiagramWithInitialOperation.execute();
            otherRepresentations = DialectManager.INSTANCE.getRepresentations(semanticEObject, session);
            findOpenableRepresentation = this.findOpenableRepresentation(otherRepresentations, diagramDescriptionToOpen, session);
            if (findOpenableRepresentation != null) {
                this.uiCallback.openRepresentation(session, findOpenableRepresentation);
                representationOpened = true;
            }
        }
        return representationOpened;
    }

    private DRepresentation findOpenableRepresentation(Collection<DRepresentation> otherRepresentations, DiagramDescription diagramDescriptionToOpen, Session session) {
        for (DRepresentation representation : otherRepresentations) {
            DDiagram ddiagram;
            if (!(representation instanceof DDiagram) || (ddiagram = (DDiagram)representation).getDescription() == null || !ddiagram.getDescription().equals(diagramDescriptionToOpen)) continue;
            return representation;
        }
        return null;
    }

    public String getLabel() {
        return null;
    }

    private EObject getElement() {
        return this.context.getCurrentTarget();
    }
}

