/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.config;

import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.util.List;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.internal.TaskingConfigurationStore;
import org.eclipse.tea.core.services.TaskingConfigurationExtension;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.core.ui.Activator;
import org.eclipse.tea.core.ui.config.TaskingEclipsePreferenceStore;

public class TaskingPreferenceInitializer
extends AbstractPreferenceInitializer {
    @Inject
    @Service
    private List<TaskingConfigurationExtension> extensions;
    @Inject
    private TaskingLog log;

    public TaskingPreferenceInitializer() {
        ContextInjectionFactory.inject((Object)((Object)this), (IEclipseContext)TaskingInjectionHelper.createConfiguredContext((TaskingConfigurationStore)new TaskingEclipsePreferenceStore()));
    }

    public void initializeDefaultPreferences() {
        for (TaskingConfigurationExtension ext : this.extensions) {
            Field[] fieldArray = ext.getClass().getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    Field f = fieldArray[n2];
                    TaskingConfigurationExtension.TaskingConfigProperty config = f.getAnnotation(TaskingConfigurationExtension.TaskingConfigProperty.class);
                    if (config != null) {
                        String propertyName = TaskingConfigurationStore.getPropertyName((Field)f);
                        try {
                            Object v = f.get(ext);
                            if (v == null) break block10;
                            if (f.getType().equals(String.class)) {
                                Activator.getInstance().getPreferenceStore().setDefault(propertyName, (String)v);
                                break block10;
                            }
                            if (f.getType().equals(Integer.class) || f.getType().equals(Integer.TYPE)) {
                                Activator.getInstance().getPreferenceStore().setDefault(propertyName, ((Integer)v).intValue());
                                break block10;
                            }
                            if (f.getType().equals(Long.class) || f.getType().equals(Long.TYPE)) {
                                Activator.getInstance().getPreferenceStore().setDefault(propertyName, ((Long)v).longValue());
                                break block10;
                            }
                            if (f.getType().equals(Boolean.class) || f.getType().equals(Boolean.TYPE)) {
                                Activator.getInstance().getPreferenceStore().setDefault(propertyName, ((Boolean)v).booleanValue());
                                break block10;
                            }
                            if (Enum.class.isAssignableFrom(f.getType())) {
                                Activator.getInstance().getPreferenceStore().setDefault(propertyName, ((Enum)v).name());
                                break block10;
                            }
                            throw new RuntimeException("Unsupported configuration property type" + String.valueOf(f.getType()));
                        }
                        catch (Exception e) {
                            this.log.error("Error while initializing default preferences", (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

