/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.interfaces.ITerminalsView;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderManager;
import org.eclipse.tm.terminal.view.ui.view.TerminalsView;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;

public class ConsoleManager {
    private final IPerspectiveListener perspectiveListener = new ConsoleManagerPerspectiveListener();
    private final IPartListener2 partListener = new ConsoleManagerPartListener();
    String lastActiveViewId = null;
    String lastActiveSecondaryViewId = null;

    public static ConsoleManager getInstance() {
        return LazyInstanceHolder.fInstance;
    }

    ConsoleManager() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(this.perspectiveListener);
            IPartService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService();
            service.addPartListener(this.partListener);
        }
    }

    private final IWorkbenchPage getActiveWorkbenchPage() {
        if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        return null;
    }

    public ITerminalsView findConsoleView(String id, String secondaryId) {
        IViewPart part;
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        ITerminalsView view = null;
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null && (part = this.getTerminalsViewWithSecondaryId(id != null ? id : "org.eclipse.tm.terminal.view.ui.TerminalsView", secondaryId, true)) instanceof ITerminalsView) {
            view = (ITerminalsView)part;
        }
        return view;
    }

    private IViewPart getTerminalsViewWithSecondaryId(String id, String secondaryId, boolean restore) {
        Assert.isNotNull((Object)id);
        IViewReference[] iViewReferenceArray = this.getActiveWorkbenchPage().getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals(id)) {
                String refSecondaryId = ref.getSecondaryId();
                if ("*".equals(secondaryId) || Objects.equals(secondaryId, refSecondaryId)) {
                    return ref.getView(restore);
                }
            }
            ++n2;
        }
        return null;
    }

    private IViewPart getActiveTerminalsView(String id, String secondaryId) {
        String finalSecondaryId;
        Assert.isNotNull((Object)id);
        IViewPart part = null;
        if (id.equals(this.lastActiveViewId) && ("last".equals(secondaryId) || Objects.equals(secondaryId, this.lastActiveSecondaryViewId))) {
            part = this.getTerminalsViewWithSecondaryId(this.lastActiveViewId, this.lastActiveSecondaryViewId, false);
        }
        if (part == null && (part = this.getTerminalsViewWithSecondaryId(id, finalSecondaryId = "last".equals(secondaryId) ? "*" : secondaryId, true)) != null) {
            this.lastActiveViewId = part.getViewSite().getId();
            this.lastActiveSecondaryViewId = part.getViewSite().getSecondaryId();
        }
        return part;
    }

    public String getNextTerminalSecondaryId(String id) {
        Assert.isNotNull((Object)id);
        HashMap<String, IViewReference> terminalViews = new HashMap<String, IViewReference>();
        int maxNumber = 0;
        IViewReference[] iViewReferenceArray = this.getActiveWorkbenchPage().getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals(id)) {
                if (ref.getSecondaryId() != null) {
                    terminalViews.put(ref.getSecondaryId(), ref);
                    int scondaryIdInt = Integer.parseInt(ref.getSecondaryId());
                    if (scondaryIdInt > maxNumber) {
                        maxNumber = scondaryIdInt;
                    }
                } else {
                    terminalViews.put(Integer.toString(0), ref);
                }
            }
            ++n2;
        }
        if (terminalViews.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < maxNumber) {
            String secondaryIdStr = Integer.toString(i);
            if (!terminalViews.keySet().contains(secondaryIdStr)) {
                if (i == 0) {
                    return null;
                }
                return Integer.toString(i);
            }
            ++i;
        }
        return Integer.toString(i + 1);
    }

    public IViewPart showConsoleView(String id, String secondaryId) {
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null) {
            try {
                IViewPart part = this.getActiveTerminalsView(id != null ? id : "org.eclipse.tm.terminal.view.ui.TerminalsView", secondaryId);
                if (part == null) {
                    String finalSecondaryId = "last".equals(secondaryId) || "*".equals(secondaryId) ? null : secondaryId;
                    part = page.showView(id != null ? id : "org.eclipse.tm.terminal.view.ui.TerminalsView", finalSecondaryId, 1);
                }
                page.bringToTop((IWorkbenchPart)part);
                return part;
            }
            catch (PartInitException e) {
                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                UIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return null;
    }

    private IViewPart bringToTop(String id, String secondaryId, boolean activate) {
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null) {
            IViewPart activePart = this.getActiveTerminalsView(id != null ? id : "org.eclipse.tm.terminal.view.ui.TerminalsView", secondaryId);
            if (activePart == null) {
                IViewPart newPart = this.showConsoleView(id != null ? id : "org.eclipse.tm.terminal.view.ui.TerminalsView", this.getNextTerminalSecondaryId("org.eclipse.tm.terminal.view.ui.TerminalsView"));
                return newPart;
            }
            if (activate) {
                page.activate((IWorkbenchPart)activePart);
            } else {
                page.bringToTop((IWorkbenchPart)activePart);
            }
            return activePart;
        }
        return null;
    }

    @Deprecated
    public CTabItem openConsole(String id, String title, String encoding, ITerminalConnector connector, Object data, Map<String, Boolean> flags) {
        return this.openConsole(id, "last", title, encoding, connector, data, flags);
    }

    public CTabItem openConsole(String id, String secondaryId, String title, String encoding, ITerminalConnector connector, Object data, Map<String, Boolean> flags) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        boolean activate = flags != null && flags.containsKey("activate") ? flags.get("activate") : false;
        boolean forceNew = flags != null && flags.containsKey("terminal.forceNew") ? flags.get("terminal.forceNew") : false;
        IViewPart part = this.bringToTop(id, secondaryId, activate);
        if (!(part instanceof ITerminalsView)) {
            return null;
        }
        ITerminalsView view = (ITerminalsView)part;
        TabFolderManager manager = (TabFolderManager)((Object)view.getAdapter(TabFolderManager.class));
        if (manager == null) {
            return null;
        }
        String secId = ((IViewSite)part.getSite()).getSecondaryId();
        CTabItem item = this.findConsole(id, secId, title, connector, data);
        view.switchToTabFolderControl();
        if (item == null || forceNew) {
            if (UIPlugin.getScopedPreferences().getBoolean("terminals.removeTerminatedTerminals")) {
                manager.removeTerminatedItems();
                view.switchToTabFolderControl();
            }
            item = manager.createTabItem(title, encoding, connector, data, flags);
        }
        if (item == null) {
            return null;
        }
        manager.bringToTop(item);
        view.setFocus();
        return item;
    }

    public CTabItem findConsole(String id, String secondaryId, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        ITerminalsView view = this.findConsoleView(id, secondaryId);
        if (view == null) {
            return null;
        }
        TabFolderManager manager = (TabFolderManager)((Object)view.getAdapter(TabFolderManager.class));
        if (manager == null) {
            return null;
        }
        return manager.findTabItem(title, connector, data);
    }

    /*
     * Unable to fully structure code
     */
    public CTabItem findConsole(ITerminalControl control) {
        Assert.isNotNull((Object)control);
        item = null;
        page = this.getActiveWorkbenchPage();
        if (page != null) {
            var7_4 = page.getViewReferences();
            var6_5 = var7_4.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                ref = var7_4[var5_6];
                v0 = part = ref != null ? ref.getView(false) : null;
                if (part instanceof ITerminalsView) {
                    tabFolder = (CTabFolder)part.getAdapter(CTabFolder.class);
                    if (tabFolder != null) {
                        var14_14 = candidates = tabFolder.getItems();
                        var13_13 = candidates.length;
                        var12_12 = 0;
                        while (var12_12 < var13_13) {
                            candidate = var14_14[var12_12];
                            data = candidate.getData();
                            if (data instanceof ITerminalControl && control.equals(data)) {
                                item = candidate;
                                ** break;
                            }
                            ++var12_12;
                        }
                    }
                } else if (item != null) break;
                ++var5_6;
            }
        }
        return item;
    }

    private CTabItem findConsoleForTerminalConnector(String id, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        IWorkbenchPage page = this.getActiveWorkbenchPage();
        if (page != null) {
            IViewReference[] refs;
            IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item;
                TabFolderManager manager;
                IViewPart part;
                IViewReference ref = iViewReferenceArray[n2];
                if (ref.getId().equals(id) && (part = ref.getView(true)) instanceof ITerminalsView && (manager = (TabFolderManager)((Object)part.getAdapter(TabFolderManager.class))) != null && (item = manager.findTabItem(title, connector, data)) != null) {
                    return item;
                }
                ++n2;
            }
        }
        return null;
    }

    public void closeConsole(String id, String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem console = this.findConsoleForTerminalConnector(id, title, connector, data);
        if (console != null) {
            console.dispose();
        }
    }

    public void terminateConsole(String id, String title, ITerminalConnector connector, Object data) {
        ITerminalViewControl terminal;
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        Assert.isNotNull((Object)Display.findDisplay((Thread)Thread.currentThread()));
        CTabItem console = this.findConsoleForTerminalConnector(id, title, connector, data);
        if (console != null && !console.isDisposed() && (terminal = (ITerminalViewControl)console.getData()) != null && !terminal.isDisposed()) {
            terminal.disconnectTerminal();
        }
    }

    class ConsoleManagerPartListener
    implements IPartListener2 {
        ConsoleManagerPartListener() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof ITerminalsView) {
                ConsoleManager.this.lastActiveViewId = ((ITerminalsView)part).getViewSite().getId();
                ConsoleManager.this.lastActiveSecondaryViewId = ((ITerminalsView)part).getViewSite().getSecondaryId();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }

    static class ConsoleManagerPerspectiveListener
    extends PerspectiveAdapter {
        private final List<IViewReference> references = new ArrayList<IViewReference>();

        ConsoleManagerPerspectiveListener() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if (this.references.isEmpty()) {
                return;
            }
            ArrayList<IViewReference> oldReferences = new ArrayList<IViewReference>(this.references);
            ArrayList<IViewReference> references = new ArrayList<IViewReference>(Arrays.asList(page.getViewReferences()));
            for (IViewReference reference : oldReferences) {
                if (references.contains(reference)) continue;
                try {
                    page.showView(reference.getId(), reference.getSecondaryId(), 2);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        }

        public void perspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            this.references.clear();
            IViewReference[] iViewReferenceArray = page.getViewReferences();
            int n = iViewReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference reference = iViewReferenceArray[n2];
                IViewPart part = reference.getView(false);
                if (part instanceof TerminalsView && !this.references.contains(reference)) {
                    this.references.add(reference);
                }
                ++n2;
            }
        }
    }

    private static class LazyInstanceHolder {
        public static ConsoleManager fInstance = new ConsoleManager();

        private LazyInstanceHolder() {
        }
    }
}

