/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared;

import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.ui.dialogs.filteredtree.FilteredTable;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.internal.ui.shared.CachedCheckboxTableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FilteredCheckboxTable
extends FilteredTable {
    private static final long FILTER_DELAY = 400L;
    private final FormToolkit toolkit;

    public FilteredCheckboxTable(Composite parent, FormToolkit toolkit) {
        this(parent, toolkit, 0);
    }

    public FilteredCheckboxTable(Composite parent, FormToolkit toolkit, int tableStyle) {
        this(parent, toolkit, tableStyle, new PatternFilter());
    }

    public FilteredCheckboxTable(Composite parent, FormToolkit toolkit, int tableStyle, PatternFilter filter) {
        super(parent);
        this.parent = parent;
        this.toolkit = toolkit;
        this.init(tableStyle, filter);
    }

    protected TableViewer doCreateTableViewer(Composite parent, int style) {
        int tableStyle = style | 0x20 | 2 | 0x200 | 0x100 | 0x800;
        Table table = null;
        table = this.toolkit != null ? this.toolkit.createTable(parent, tableStyle) : new Table(parent, tableStyle);
        return new CachedCheckboxTableViewer(table);
    }

    protected Job doCreateRefreshJob() {
        Job filterJob = super.doCreateRefreshJob();
        filterJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FilteredCheckboxTable.this.getDisplay().asyncExec(() -> {
                    if (FilteredCheckboxTable.this.getViewer().getTable().isDisposed()) {
                        return;
                    }
                    FilteredCheckboxTable.this.getViewer().restoreCachedState();
                });
            }
        });
        return filterJob;
    }

    protected Text doCreateFilterText(Composite parent) {
        Text parentText = super.doCreateFilterText(parent);
        if (this.toolkit != null) {
            int style = parentText.getStyle();
            parentText.dispose();
            return this.toolkit.createText(parent, null, style);
        }
        return parentText;
    }

    public CachedCheckboxTableViewer getViewer() {
        return (CachedCheckboxTableViewer)super.getViewer();
    }

    protected long getRefreshJobDelay() {
        return 400L;
    }

    protected String getFilterString() {
        String original = super.getFilterString();
        String asterisk = "*";
        if (original != null && !original.equals(this.getInitialText()) && !original.startsWith(asterisk)) {
            return asterisk + original;
        }
        return original;
    }
}

