/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class QuoteBlock
extends Block {
    static final Pattern startPattern = Pattern.compile("bq\\.\\s+(.*)");
    private int blockLineCount = 0;
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            offset = this.matcher.start(1);
            this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, attributes);
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        }
        if (this.markupLanguage.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount != 0) {
            this.builder.lineBreak();
        }
        ++this.blockLineCount;
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.matcher = startPattern.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        return this.matcher.matches();
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

