/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.core.target;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.launchbar.core.internal.Activator;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;

public class LaunchTargetUtils {
    private static final Pattern INVALID_NAME_PATTERN = Pattern.compile("[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]]");
    private static final char[] DISALLOWED_CONFIG_NAME_CHARS;

    static {
        char[] cArray = new char[12];
        cArray[0] = 64;
        cArray[1] = 38;
        cArray[2] = 92;
        cArray[3] = 47;
        cArray[4] = 58;
        cArray[5] = 42;
        cArray[6] = 63;
        cArray[7] = 34;
        cArray[8] = 60;
        cArray[9] = 62;
        cArray[10] = 124;
        DISALLOWED_CONFIG_NAME_CHARS = cArray;
    }

    private LaunchTargetUtils() {
    }

    public static boolean isInvalidName(String name) {
        return INVALID_NAME_PATTERN.matcher(name).find();
    }

    public static String sanitizeName(String name) {
        return INVALID_NAME_PATTERN.matcher(name).replaceAll("_");
    }

    public static String sanitizeLaunchConfigurationName(String name) {
        char[] cArray = DISALLOWED_CONFIG_NAME_CHARS;
        int n = DISALLOWED_CONFIG_NAME_CHARS.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            name = name.replace(element, '_');
            ++n2;
        }
        return name;
    }

    public static List<String> getExistingLaunchTargetNames() {
        List<String> retVal = new ArrayList<String>();
        ILaunchTargetManager manager = Activator.getService(ILaunchTargetManager.class);
        if (manager != null) {
            retVal = Arrays.stream(manager.getLaunchTargets()).map(ILaunchTarget::getId).collect(Collectors.toList());
        }
        return retVal;
    }
}

