/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupFilter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SelectFavoritesDialog
extends AbstractDebugCheckboxSelectionDialog {
    private final LaunchHistory fHistory;
    private final List<ILaunchConfiguration> fCurrentFavoriteSet;

    public SelectFavoritesDialog(Shell parentShell, LaunchHistory history, List<ILaunchConfiguration> favorites) {
        super(parentShell);
        this.fHistory = history;
        this.fCurrentFavoriteSet = favorites;
        this.setTitle(MessageFormat.format(LaunchConfigurationsMessages.FavoritesDialog_0, this.getModeLabel()));
        this.setShowSelectAllButtons(true);
    }

    private String getModeLabel() {
        return DebugUIPlugin.removeAccelerators(this.fHistory.getLaunchGroup().getLabel());
    }

    @Override
    protected String getDialogSettingsId() {
        return "org.eclipse.debug.ui.SELECT_FAVORITESS_DIALOG";
    }

    @Override
    protected Object getViewerInput() {
        return this.fHistory.getLaunchGroup().getMode();
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new LaunchConfigurationContentProvider();
    }

    @Override
    protected String getHelpContextId() {
        return "org.eclipse.debug.ui.select_favorites_dialog";
    }

    @Override
    protected String getViewerLabel() {
        return LaunchConfigurationsMessages.FavoritesDialog_7;
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        final Text filterText = new Text(container, 384);
        filterText.setMessage(LaunchConfigurationsMessages.SelectFavTypeToFilter);
        filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Table table = new Table(container, 2084);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 250;
        table.setLayoutData((Object)gd);
        CheckboxTableViewer viewer = new CheckboxTableViewer(table);
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer2, Object parentElement, Object element) {
                String search = filterText.getText().toLowerCase();
                if (search.isEmpty()) {
                    return true;
                }
                return element.toString().toLowerCase().contains(search);
            }
        };
        viewer.addFilter(filter);
        filterText.addModifyListener(e -> viewer.refresh());
        return viewer;
    }

    protected class LaunchConfigurationContentProvider
    implements IStructuredContentProvider {
        protected LaunchConfigurationContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ILaunchConfiguration[] all = null;
            try {
                all = LaunchConfigurationManager.filterConfigs(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
                return new ILaunchConfiguration[0];
            }
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>(all.length);
            LaunchGroupFilter filter = new LaunchGroupFilter(SelectFavoritesDialog.this.fHistory.getLaunchGroup());
            ILaunchConfiguration[] iLaunchConfigurationArray = all;
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (filter.select(null, null, config)) {
                    list.add(config);
                }
                ++n2;
            }
            list.removeAll(SelectFavoritesDialog.this.fCurrentFavoriteSet);
            Object[] objs = list.toArray();
            Arrays.sort(objs, (o1, o2) -> {
                if (o1 instanceof ILaunchConfiguration) {
                    ILaunchConfiguration launch1 = (ILaunchConfiguration)o1;
                    if (o2 instanceof ILaunchConfiguration) {
                        ILaunchConfiguration launch2 = (ILaunchConfiguration)o2;
                        try {
                            String type1 = launch1.getType().getName();
                            String type2 = launch2.getType().getName();
                            int cmp = type1.compareToIgnoreCase(type2);
                            if (cmp != 0) {
                                return cmp;
                            }
                            return launch1.getName().compareToIgnoreCase(launch2.getName());
                        }
                        catch (CoreException e) {
                            DebugUIPlugin.log(e);
                        }
                    }
                }
                return 0;
            });
            return objs;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

