/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.monitor.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.monitor.ui.IMonitoredWindow;
import org.eclipse.mylyn.internal.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractUserInteractionMonitor
implements ISelectionListener {
    protected Object lastSelectedElement = null;

    public AbstractUserInteractionMonitor() {
        try {
            MonitorUiPlugin.getDefault().addWindowPostSelectionListener(this);
        }
        catch (NullPointerException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.monitor.ui", "Monitors can not be instantiated until the workbench is active", (Throwable)e));
        }
    }

    public void dispose() {
        try {
            MonitorUiPlugin.getDefault().removeWindowPostSelectionListener(this);
        }
        catch (NullPointerException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.monitor.ui", "Could not dispose monitor", (Throwable)e));
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IWorkbenchWindow window;
        if (part.getSite() != null && part.getSite().getWorkbenchWindow() != null && (window = part.getSite().getWorkbenchWindow()) instanceof IMonitoredWindow && !((IMonitoredWindow)window).isMonitored()) {
            return;
        }
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (!ContextCore.getContextManager().isContextActive()) {
            this.handleWorkbenchPartSelection(part, selection, false);
        } else {
            this.handleWorkbenchPartSelection(part, selection, true);
        }
    }

    protected abstract void handleWorkbenchPartSelection(IWorkbenchPart var1, ISelection var2, boolean var3);

    protected InteractionEvent handleElementSelection(IWorkbenchPart part, Object selectedElement, boolean contributeToContext) {
        return this.handleElementSelection(part.getSite().getId(), selectedElement, contributeToContext);
    }

    protected void handleElementEdit(IWorkbenchPart part, Object selectedElement, boolean contributeToContext) {
        this.handleElementEdit(part.getSite().getId(), selectedElement, contributeToContext);
    }

    protected void handleNavigation(IWorkbenchPart part, Object targetElement, String kind, boolean contributeToContext) {
        this.handleNavigation(part.getSite().getId(), targetElement, kind, contributeToContext);
    }

    protected void handleNavigation(String partId, Object targetElement, String kind, boolean contributeToContext) {
        AbstractContextStructureBridge adapter = ContextCore.getStructureBridge((Object)targetElement);
        if (adapter.getContentType() != null) {
            String handleIdentifier = adapter.getHandleIdentifier(targetElement);
            InteractionEvent navigationEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, adapter.getContentType(), handleIdentifier, partId, kind);
            if (handleIdentifier != null && contributeToContext) {
                ContextCore.getContextManager().processInteractionEvent(navigationEvent);
            }
            MonitorUiPlugin.getDefault().notifyInteractionObserved(navigationEvent);
        }
    }

    protected void handleElementEdit(String partId, Object selectedElement, boolean contributeToContext) {
        if (selectedElement == null) {
            return;
        }
        AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)selectedElement);
        String handleIdentifier = bridge.getHandleIdentifier(selectedElement);
        InteractionEvent editEvent = new InteractionEvent(InteractionEvent.Kind.EDIT, bridge.getContentType(), handleIdentifier, partId);
        if (handleIdentifier != null && contributeToContext) {
            ContextCore.getContextManager().processInteractionEvent(editEvent);
        }
        MonitorUiPlugin.getDefault().notifyInteractionObserved(editEvent);
    }

    protected InteractionEvent handleElementSelection(String partId, Object selectedElement, boolean contributeToContext) {
        if (selectedElement == null || selectedElement.equals(this.lastSelectedElement)) {
            return null;
        }
        AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)selectedElement);
        String handleIdentifier = bridge.getHandleIdentifier(selectedElement);
        InteractionEvent selectionEvent = bridge.getContentType() != null ? new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), handleIdentifier, partId) : new InteractionEvent(InteractionEvent.Kind.SELECTION, null, null, partId);
        if (handleIdentifier != null && contributeToContext) {
            ContextCore.getContextManager().processInteractionEvent(selectionEvent);
        }
        MonitorUiPlugin.getDefault().notifyInteractionObserved(selectionEvent);
        return selectionEvent;
    }

    public InteractionEvent.Kind getEventKind() {
        return InteractionEvent.Kind.SELECTION;
    }
}

