/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import org.eclipse.buildship.core.internal.util.gradle.HierarchicalElementUtils;
import org.eclipse.buildship.ui.internal.view.task.FaultyBuildTreeNode;
import org.eclipse.buildship.ui.internal.view.task.ProjectNode;
import org.eclipse.buildship.ui.internal.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.internal.view.task.TaskNode;
import org.eclipse.buildship.ui.internal.view.task.TaskViewState;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.gradle.tooling.model.HierarchicalElement;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class TaskNodeViewerSorter
extends ViewerComparator {
    private final Ordering<ProjectNode> projectNodeOrdering;
    private final Ordering<TaskNode> taskNodeOrdering;
    private final Ordering<FaultyBuildTreeNode> faultyProjectOrdering;

    private TaskNodeViewerSorter(Ordering<ProjectNode> projectNodeOrdering, Ordering<TaskNode> taskNodeOrdering) {
        this.projectNodeOrdering = projectNodeOrdering;
        this.taskNodeOrdering = taskNodeOrdering;
        this.faultyProjectOrdering = TaskNodeViewerSorter.createLexicographicalFaultyProjectOrdering();
    }

    public int compare(Viewer viewer, Object leftNode, Object rightNode) {
        if (leftNode instanceof ProjectNode && rightNode instanceof ProjectNode) {
            ProjectNode left = (ProjectNode)leftNode;
            ProjectNode right = (ProjectNode)rightNode;
            return this.projectNodeOrdering.compare((Object)left, (Object)right);
        }
        if (leftNode instanceof ProjectNode && rightNode instanceof TaskNode) {
            return -1;
        }
        if (leftNode instanceof TaskNode && rightNode instanceof ProjectNode) {
            return 1;
        }
        if (leftNode instanceof ProjectNode && rightNode instanceof TaskGroupNode) {
            return -1;
        }
        if (leftNode instanceof TaskGroupNode && rightNode instanceof ProjectNode) {
            return 1;
        }
        if (leftNode instanceof TaskNode && rightNode instanceof TaskNode) {
            TaskNode left = (TaskNode)leftNode;
            TaskNode right = (TaskNode)rightNode;
            return this.taskNodeOrdering.compare((Object)left, (Object)right);
        }
        if (leftNode instanceof FaultyBuildTreeNode && rightNode instanceof ProjectNode) {
            return 1;
        }
        if (leftNode instanceof ProjectNode && rightNode instanceof FaultyBuildTreeNode) {
            return -1;
        }
        if (leftNode instanceof FaultyBuildTreeNode && rightNode instanceof FaultyBuildTreeNode) {
            FaultyBuildTreeNode left = (FaultyBuildTreeNode)leftNode;
            FaultyBuildTreeNode right = (FaultyBuildTreeNode)rightNode;
            return this.faultyProjectOrdering.compare((Object)left, (Object)right);
        }
        return super.compare(viewer, leftNode, rightNode);
    }

    public static TaskNodeViewerSorter createFor(TaskViewState state) {
        Ordering<ProjectNode> projectOrdering = TaskNodeViewerSorter.createProjectNodeOrdering(state.isProjectHierarchyFlattened());
        Ordering<TaskNode> taskOrdering = TaskNodeViewerSorter.createTaskNodeOrdering(state.isSortByType(), state.isSortByVisibility());
        return new TaskNodeViewerSorter(projectOrdering, taskOrdering);
    }

    private static Ordering<ProjectNode> createProjectNodeOrdering(final boolean isHierarchyFlattened) {
        return new Ordering<ProjectNode>(){

            public int compare(ProjectNode left, ProjectNode right) {
                if (!isHierarchyFlattened) {
                    return left.getDisplayName().compareTo(right.getDisplayName());
                }
                EclipseProject leftRoot = (EclipseProject)HierarchicalElementUtils.getRoot((HierarchicalElement)left.getEclipseProject());
                EclipseProject rightRoot = (EclipseProject)HierarchicalElementUtils.getRoot((HierarchicalElement)right.getEclipseProject());
                if (leftRoot.getProjectIdentifier() == rightRoot.getProjectIdentifier()) {
                    return 0;
                }
                return leftRoot.getName().compareTo(rightRoot.getName());
            }
        };
    }

    private static Ordering<TaskNode> createTaskNodeOrdering(boolean byType, boolean byVisibility) {
        Ordering ord = TaskNodeViewerSorter.createLexicographicalTaskOrdering();
        if (byVisibility) {
            ord = TaskNodeViewerSorter.createByVisibilityOrdering().compound(ord);
        }
        if (byType) {
            ord = TaskNodeViewerSorter.createByTypeOrdering().compound((Comparator)ord);
        }
        return ord;
    }

    private static Ordering<TaskNode> createLexicographicalTaskOrdering() {
        return new Ordering<TaskNode>(){

            public int compare(TaskNode left, TaskNode right) {
                return left.getName().compareTo(right.getName());
            }
        };
    }

    private static Ordering<FaultyBuildTreeNode> createLexicographicalFaultyProjectOrdering() {
        return new Ordering<FaultyBuildTreeNode>(){

            public int compare(FaultyBuildTreeNode left, FaultyBuildTreeNode right) {
                return left.getProjectPath().compareTo(right.getProjectPath());
            }
        };
    }

    private static Ordering<TaskNode> createByVisibilityOrdering() {
        return new Ordering<TaskNode>(){

            public int compare(TaskNode left, TaskNode right) {
                int rightOrdinal;
                int leftOrdinal = this.toOrdinal(left);
                return leftOrdinal < (rightOrdinal = this.toOrdinal(right)) ? -1 : (leftOrdinal == rightOrdinal ? 0 : 1);
            }

            private int toOrdinal(TaskNode node) {
                return node.isPublic() ? 1 : 2;
            }
        };
    }

    private static Ordering<TaskNode> createByTypeOrdering() {
        return new Ordering<TaskNode>(){

            public int compare(TaskNode left, TaskNode right) {
                int rightOrdinal;
                int leftOrdinal = this.toOrdinal(left.getType());
                return leftOrdinal < (rightOrdinal = this.toOrdinal(right.getType())) ? -1 : (leftOrdinal == rightOrdinal ? 0 : 1);
            }

            private int toOrdinal(TaskNode.TaskNodeType type) {
                return type == TaskNode.TaskNodeType.PROJECT_TASK_NODE ? 1 : 2;
            }
        };
    }
}

