/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.widgets.Display;

public abstract class WorkUnit<R, E extends Throwable> {
    private final Class<E> exceptionType;
    private R result;
    private Throwable throwable;

    protected WorkUnit() {
        this(null);
    }

    protected WorkUnit(Class<E> exceptionType) {
        this.exceptionType = exceptionType;
    }

    protected abstract R doExecute() throws E;

    public R execute() throws E {
        return this.execute(UIUtil.getDisplay());
    }

    public R execute(final Display display) throws E {
        if (display.isDisposed()) {
            return null;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                try {
                    WorkUnit.this.result = WorkUnit.this.doExecute();
                }
                catch (Throwable ex) {
                    WorkUnit.this.throwable = ex;
                }
            }
        });
        this.rethrow();
        return this.result;
    }

    protected void rethrow() throws E {
        if (this.throwable != null) {
            if (this.exceptionType == null) {
                if (this.throwable instanceof RuntimeException) {
                    throw (RuntimeException)this.throwable;
                }
                throw new RuntimeException(this.throwable);
            }
            throw (Throwable)this.exceptionType.cast(this.throwable);
        }
    }

    public static abstract class Void<E extends Throwable>
    extends WorkUnit<Object, E> {
        public Void() {
            this(null);
        }

        public Void(Class<E> exceptionType) {
            super(exceptionType);
        }

        @Override
        protected final Object doExecute() throws E {
            this.doProcess();
            return null;
        }

        protected abstract void doProcess() throws E;

        public void process() throws E {
            this.execute();
        }
    }
}

