/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ComboTools;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public abstract class IntegerCombo<T extends Model>
extends Pane<T> {
    private Combo comboBox;
    private PropertyValueModel<String> defaultValueHolder;

    protected IntegerCombo(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected IntegerCombo(Pane<? extends T> parentPane, Composite parent, PropertyValueModel<Boolean> enabledModel) {
        super(parentPane, parent, enabledModel);
    }

    protected IntegerCombo(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected IntegerCombo(Pane<?> parentPane, PropertyValueModel<? extends T> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite parent) {
        super(parentPane, subjectHolder, enabledModel, parent);
    }

    @Override
    protected boolean addsComposite() {
        return false;
    }

    public Combo getControl() {
        return this.comboBox;
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.defaultValueHolder = this.buildDefaultStringHolder();
        this.comboBox = this.addIntegerCombo(container);
        int margin = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth();
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 768;
        gridData.horizontalIndent = margin;
        gridData.grabExcessHorizontalSpace = false;
        this.comboBox.setLayoutData((Object)gridData);
        this.comboBox.addVerifyListener(this.buildVerifyListener());
        ComboTools.handleDefaultValue(this.comboBox);
    }

    protected Combo addIntegerCombo(Composite container) {
        return this.addEditableCombo(container, this.buildDefaultListHolder(), this.buildSelectedItemStringHolder(), TransformerTools.objectToStringTransformer(), this.getHelpId());
    }

    protected VerifyListener buildVerifyListener() {
        return new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                IntegerCombo.this.verifyComboBox(e);
            }
        };
    }

    protected ListValueModel<String> buildDefaultListHolder() {
        return new PropertyListValueModelAdapter(this.defaultValueHolder);
    }

    private PropertyValueModel<String> buildDefaultStringHolder() {
        return new TransformationPropertyValueModel<Integer, String>(this.buildDefaultHolder()){

            protected String transform(Integer value) {
                if (value == null) {
                    return JptCommonUiMessages.NONE_SELECTED;
                }
                return (String)super.transform((Object)value);
            }

            protected String transform_(Integer value) {
                return IntegerCombo.this.getDefaultValueString(value);
            }
        };
    }

    private String getDefaultValueString(Integer defaultValue) {
        return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
    }

    String getDefaultValueString() {
        return (String)this.defaultValueHolder.getValue();
    }

    protected ModifiablePropertyValueModel<String> buildSelectedItemStringHolder() {
        return new TransformationModifiablePropertyValueModel<Integer, String>(this.buildSelectedItemHolder()){

            protected String transform(Integer v) {
                return v == null ? IntegerCombo.this.getDefaultValueString() : v.toString();
            }

            protected Integer reverseTransform_(String v) {
                try {
                    return Integer.valueOf(v);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
        };
    }

    protected abstract String getHelpId();

    protected abstract PropertyValueModel<Integer> buildDefaultHolder();

    protected abstract ModifiablePropertyValueModel<Integer> buildSelectedItemHolder();

    protected void verifyComboBox(VerifyEvent e) {
        if (e.character == '\b') {
            return;
        }
        if (e.text.equals("") || e.text.equals(this.defaultValueHolder.getValue())) {
            return;
        }
        try {
            Integer.parseInt(e.text);
        }
        catch (NumberFormatException numberFormatException) {
            e.doit = false;
        }
    }
}

