/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.security.ICipherProvider;

public class DefaultCipherProvider
implements ICipherProvider {
    private static final String SECRET_KEY_ALGORITHM_DESEDE = "DESede";
    private static final String SECRET_KEY_ALGORITHM_DES = "DES";

    @Override
    public Cipher createEncryptionCipher() throws GeneralSecurityException {
        Key k = this.loadKey();
        if (k == null) {
            return null;
        }
        Cipher c = Cipher.getInstance(k.getAlgorithm());
        c.init(1, k);
        return c;
    }

    @Override
    public Cipher createDecryptionCipher() throws GeneralSecurityException {
        Key k = this.loadKey();
        Cipher c = Cipher.getInstance(k.getAlgorithm());
        c.init(2, k);
        return c;
    }

    private Key loadKey() throws GeneralSecurityException {
        SecretKey secretKey;
        block11: {
            ObjectInputStream ois = null;
            try {
                KeySpec spec = this.getKeySpec();
                String algorithm = this.getDefaultKeyAlgorithm();
                if (spec instanceof SecretKeySpec) {
                    SecretKeySpec secretSpec = (SecretKeySpec)spec;
                    algorithm = secretSpec.getAlgorithm();
                    if (SECRET_KEY_ALGORITHM_DESEDE.equals(algorithm)) {
                        spec = new DESedeKeySpec(secretSpec.getEncoded());
                    } else if (SECRET_KEY_ALGORITHM_DES.equals(algorithm)) {
                        spec = new DESKeySpec(secretSpec.getEncoded());
                    }
                }
                SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
                secretKey = factory.generateSecret(spec);
                if (ois == null) break block11;
            }
            catch (Throwable throwable) {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ois.close();
            }
            catch (IOException iOException) {}
        }
        return secretKey;
    }

    protected String getDefaultKeyAlgorithm() {
        return SECRET_KEY_ALGORITHM_DESEDE;
    }

    protected KeySpec getKeySpec() throws GeneralSecurityException {
        URL url = this.getKeyResource();
        if (url == null) {
            throw new KeyStoreException();
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(url.openStream());
            Object readObject = ois.readObject();
            if (readObject instanceof KeySpec) {
                return (KeySpec)readObject;
            }
            throw new InvalidKeySpecException();
        }
        catch (IOException e) {
            throw new InvalidKeySpecException(e);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    protected URL getKeyResource() {
        return ConnectivityPlugin.getResource("org/eclipse/datatools/connectivity/internal/security/cpkey");
    }
}

