/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.launching;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.debug.core.launch.CoreBuildLaunchConfigDelegate;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.internal.Messages;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.launching.ServicesLaunchSequence;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.launch.ITargetedLaunch;

public class CoreBuildLocalDebugLaunchDelegate
extends CoreBuildLaunchConfigDelegate {
    public ITargetedLaunch getLaunch(ILaunchConfiguration configuration, String mode, ILaunchTarget target) throws CoreException {
        GdbLaunch launch = new GdbLaunch(configuration, mode, null);
        launch.setLaunchTarget(target);
        launch.initialize();
        GdbSourceLookupDirector locator = new GdbSourceLookupDirector(launch.getSession());
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else {
            locator.initializeFromMemento(memento, configuration);
        }
        String type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
        if (type == null) {
            type = configuration.getType().getSourceLocatorId();
        }
        locator.setId(type);
        launch.setSourceLocator((ISourceLocator)locator);
        return launch;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, final IProgressMonitor monitor) throws CoreException {
        IToolChain toolChain;
        Path gdbPath;
        final GdbLaunch gdbLaunch = (GdbLaunch)launch;
        ILaunchTarget target = ((ITargetedLaunch)launch).getLaunchTarget();
        ICBuildConfiguration buildConfig = this.getBuildConfiguration(configuration, mode, target, monitor);
        HashMap buildEnv = new HashMap();
        buildConfig.setBuildEnvironment(buildEnv);
        Properties envProps = new Properties();
        envProps.putAll((Map<?, ?>)buildEnv);
        gdbLaunch.setInitialEnvironment(envProps);
        String debugger = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "gdb");
        Path debuggerPath = Paths.get(debugger, new String[0]);
        if (!debuggerPath.isAbsolute() && (gdbPath = (toolChain = buildConfig.getToolChain()).getCommandPath(debuggerPath)) != null) {
            gdbLaunch.setGDBPath(gdbPath.toString());
        }
        String gdbVersion = gdbLaunch.getGDBVersion();
        gdbLaunch.setProgramPath(this.getProgramPath(configuration, buildConfig));
        gdbLaunch.setServiceFactory((IDsfDebugServicesFactory)new GdbDebugServicesFactory(gdbVersion, configuration));
        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(gdbLaunch.getSession(), gdbLaunch, monitor);
        gdbLaunch.getSession().getExecutor().execute((Runnable)((Object)servicesLaunchSequence));
        try {
            servicesLaunchSequence.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", Messages.CoreBuildLocalDebugLaunchDelegate_FailureLaunching, (Throwable)e));
        }
        gdbLaunch.initializeControl();
        gdbLaunch.addCLIProcess(gdbLaunch.getGDBPath().toOSString() + " (" + gdbVersion + ")");
        Query<Object> ready = new Query<Object>(){

            protected void execute(final DataRequestMonitor<Object> rm) {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getDefault().getBundle().getBundleContext(), gdbLaunch.getSession().getId());
                IGDBControl control = (IGDBControl)tracker.getService(IGDBControl.class);
                tracker.dispose();
                control.completeInitialization((RequestMonitor)new RequestMonitorWithProgress(ImmediateExecutor.getInstance(), monitor){

                    protected void handleCompleted() {
                        if (this.isCanceled()) {
                            rm.cancel();
                        } else {
                            rm.setStatus(this.getStatus());
                        }
                        rm.done();
                    }
                });
            }
        };
        gdbLaunch.getSession().getExecutor().execute((Runnable)ready);
        try {
            ready.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", Messages.CoreBuildLocalDebugLaunchDelegate_FailureStart, (Throwable)e));
        }
    }
}

