/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.CombinationIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JPA;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;

public abstract class SourceAssociationOverrideAnnotation
extends SourceOverrideAnnotation
implements AssociationOverrideAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter(ANNOTATION_NAME);
    public static final DeclarationAnnotationAdapter CONTAINER_DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter(JPA.ASSOCIATION_OVERRIDES);
    private final JoinColumnsAnnotationContainer joinColumnsContainer = new JoinColumnsAnnotationContainer();

    protected SourceAssociationOverrideAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    public String getAnnotationName() {
        return ANNOTATION_NAME;
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.joinColumnsContainer.initializeFromContainerAnnotation(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.joinColumnsContainer.synchronize(astAnnotation);
    }

    @Override
    protected String getNameElementName() {
        return "name";
    }

    @Override
    public ListIterable<JoinColumnAnnotation> getJoinColumns() {
        return this.joinColumnsContainer.getNestedAnnotations();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.joinColumnsContainer.getNestedAnnotationsSize();
    }

    @Override
    public JoinColumnAnnotation joinColumnAt(int index) {
        return (JoinColumnAnnotation)this.joinColumnsContainer.getNestedAnnotation(index);
    }

    @Override
    public JoinColumnAnnotation addJoinColumn(int index) {
        return (JoinColumnAnnotation)this.joinColumnsContainer.addNestedAnnotation(index);
    }

    private JoinColumnAnnotation buildJoinColumn(int index) {
        return SourceJoinColumnAnnotation.buildNestedSourceJoinColumnAnnotation((JavaResourceModel)this, this.annotatedElement, this.buildJoinColumnIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildJoinColumnIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "joinColumns", index, JPA.JOIN_COLUMN);
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        this.joinColumnsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeJoinColumn(int index) {
        this.joinColumnsContainer.removeNestedAnnotation(index);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.joinColumnsContainer.isEmpty();
    }

    protected static IndexedAnnotationAdapter buildAssociationOverrideAnnotationAdapter(AnnotatedElement annotatedElement, IndexedDeclarationAnnotationAdapter idaa) {
        return new ElementIndexedAnnotationAdapter(annotatedElement, idaa);
    }

    protected static IndexedDeclarationAnnotationAdapter buildAssociationOverrideDeclarationAnnotationAdapter(int index) {
        CombinationIndexedDeclarationAnnotationAdapter idaa = new CombinationIndexedDeclarationAnnotationAdapter(DECLARATION_ANNOTATION_ADAPTER, CONTAINER_DECLARATION_ANNOTATION_ADAPTER, index, ANNOTATION_NAME);
        return idaa;
    }

    class JoinColumnsAnnotationContainer
    extends SourceModel.AnnotationContainer<JoinColumnAnnotation> {
        JoinColumnsAnnotationContainer() {
            super((SourceModel)SourceAssociationOverrideAnnotation.this);
        }

        protected String getNestedAnnotationsListName() {
            return "joinColumns";
        }

        protected String getElementName() {
            return "joinColumns";
        }

        protected String getNestedAnnotationName() {
            return JPA.JOIN_COLUMN;
        }

        protected JoinColumnAnnotation buildNestedAnnotation(int index) {
            return SourceAssociationOverrideAnnotation.this.buildJoinColumn(index);
        }
    }
}

