/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands.nav;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.nav.CaretPositionTracker;
import org.eclipse.jst.pagedesigner.commands.nav.HorizontalMoveCommand;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.IMovementMediator;
import org.eclipse.jst.pagedesigner.validation.caret.InlineEditingNavigationMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.EditPartPositionHelper;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.widgets.Caret;

public class VerticalMoveCommand
extends Command {
    private static Logger _log = PDPlugin.getLogger(HorizontalMoveCommand.class);
    IHTMLGraphicalViewer _viewer;
    boolean _up;
    boolean _onlyMoveEnd;

    public VerticalMoveCommand(IHTMLGraphicalViewer viewer, boolean up, boolean c) {
        this._viewer = viewer;
        this._up = up;
        this._onlyMoveEnd = c;
    }

    public void execute() {
        int OFFSET = 2;
        DesignRange range = this._viewer.getRangeSelection();
        if (range == null || !range.isValid()) {
            _log.error("invalid range");
            return;
        }
        InlineEditingNavigationMediator moveMediator = new InlineEditingNavigationMediator(new ActionData(4, null));
        DesignPosition position = range.getEndPosition();
        Caret caret = this._viewer.getCaret();
        Point point = null;
        DesignPosition newPos = position;
        EditPart containerpart = null;
        point = this._up ? new Point(((CaretPositionTracker)((Object)this._viewer)).getXoffset(), caret.getBounds().y) : new Point(((CaretPositionTracker)((Object)this._viewer)).getXoffset(), caret.getBounds().y + caret.getBounds().height);
        EditPart rootpart1 = this.getRootEditablePart(position.getContainerPart(), moveMediator);
        if (rootpart1 == null) {
            return;
        }
        point = this.adjustLocation(rootpart1, point);
        Rectangle bound = EditPartPositionHelper.getAbsoluteBounds(rootpart1);
        do {
            if (this._up) {
                point.y -= OFFSET;
                if (point.y <= bound.y) {
                    newPos = position;
                    break;
                }
            } else {
                point.y += OFFSET;
                if (point.y >= bound.y + bound.height) {
                    newPos = position;
                    break;
                }
            }
            if ((containerpart = moveMediator.getConstainedEditableContainer(position, point, this._viewer)) != null) {
                if (!EditModelQuery.isChild(Target.resolveNode(rootpart1), Target.resolveNode(containerpart))) {
                    containerpart = rootpart1;
                }
            } else {
                newPos = position;
                break;
            }
            bound = EditPartPositionHelper.getAbsoluteBounds(rootpart1);
            newPos = EditPartPositionHelper.findEditPartPositionConstrained(containerpart, point, moveMediator);
        } while (newPos == null || !this.found(newPos, position));
        this.setRange(position, newPos);
    }

    private void setRange(DesignPosition position, DesignPosition newPos) {
        if (!EditModelQuery.isSame(position, newPos)) {
            if (this._onlyMoveEnd) {
                this._viewer.setRangeEndPosition(newPos);
            } else {
                this._viewer.setRange(newPos, newPos);
            }
        }
    }

    private Point adjustLocation(EditPart rootPart, Point point) {
        Point result = point.getCopy();
        Rectangle bounds = EditPartPositionHelper.getAbsoluteBounds(rootPart);
        if (!bounds.contains(point)) {
            if (bounds.getLeft().x > point.x) {
                result.x = bounds.getLeft().x;
            } else if (bounds.getRight().x < point.x) {
                result.x = bounds.getRight().x;
            }
        }
        return result;
    }

    private EditPart getRootEditablePart(EditPart part, IMovementMediator moveMediator) {
        EditPart rootpart = null;
        rootpart = ((InlineEditingNavigationMediator)moveMediator).getRootConstainedEditableContainer(new Target(part));
        if (rootpart == null) {
            rootpart = moveMediator.getEditableContainer(new Target(part));
        }
        return rootpart;
    }

    private boolean found(DesignPosition newPos, DesignPosition prevPos) {
        Rectangle newRec = EditPartPositionHelper.convertToAbsoluteCaretRect(newPos);
        Rectangle prevRec = EditPartPositionHelper.convertToAbsoluteCaretRect(prevPos);
        if (this._up) {
            return this.getYDistance(newRec, prevRec, this._up) < 0;
        }
        return this.getYDistance(newRec, prevRec, this._up) > 0;
    }

    private int getYDistance(Rectangle rec1, Rectangle rec2, boolean top) {
        if (rec1.getCopy().intersect((Rectangle)rec2).height > 0) {
            return 0;
        }
        if (top) {
            return rec1.getTop().y - rec2.getTop().y;
        }
        return rec1.getBottom().y - rec2.getBottom().y;
    }
}

