/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.AbstractBreakpointOrganizerDelegate;
import org.eclipse.debug.ui.BreakpointTypeCategory;
import org.eclipse.debug.ui.IBreakpointTypeCategory;

public class BreakpointTypeOrganizer
extends AbstractBreakpointOrganizerDelegate {
    private final Map<String, IAdaptable[]> fTypes = new HashMap<String, IAdaptable[]>();

    @Override
    public IAdaptable[] getCategories(IBreakpoint breakpoint) {
        IBreakpointTypeCategory category = (IBreakpointTypeCategory)breakpoint.getAdapter(IBreakpointTypeCategory.class);
        if (category != null) {
            return new IAdaptable[]{category};
        }
        String name = DebugPlugin.getDefault().getBreakpointManager().getTypeName(breakpoint);
        if (name != null) {
            IAdaptable[] categories = this.fTypes.get(name);
            if (categories == null) {
                categories = new IAdaptable[]{new BreakpointTypeCategory(name)};
                this.fTypes.put(name, categories);
            }
            return categories;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.fTypes.clear();
    }
}

