/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

class CrossModuleCodeMotion
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(CrossModuleCodeMotion.class.getName());
    private final AbstractCompiler compiler;
    private final JSModuleGraph graph;
    private final Map<JSModule, Node> moduleVarParentMap = new HashMap<JSModule, Node>();
    private final Map<Var, NamedInfo> namedInfo = new LinkedHashMap<Var, NamedInfo>();
    private final Map<Node, InstanceofInfo> instanceofNodes = new LinkedHashMap<Node, InstanceofInfo>();
    private final boolean parentModuleCanSeeSymbolsDeclaredInChildren;

    CrossModuleCodeMotion(AbstractCompiler compiler, JSModuleGraph graph, boolean parentModuleCanSeeSymbolsDeclaredInChildren) {
        this.compiler = compiler;
        this.graph = graph;
        this.parentModuleCanSeeSymbolsDeclaredInChildren = parentModuleCanSeeSymbolsDeclaredInChildren;
    }

    @Override
    public void process(Node externs, Node root) {
        logger.fine("Moving functions + variable into deeper modules");
        if (this.graph != null && this.graph.getModuleCount() > 1) {
            this.collectReferences(root);
            if (this.parentModuleCanSeeSymbolsDeclaredInChildren) {
                this.makeInstanceOfCodeOrderIndependent();
            }
            this.moveCode();
        }
    }

    private void moveCode() {
        for (NamedInfo info : this.namedInfo.values()) {
            JSModule deepestDependency = info.deepestModule;
            if (!info.allowMove || deepestDependency == null) continue;
            Iterator<Declaration> it = info.declarationIterator();
            JSModuleGraph moduleGraph = this.compiler.getModuleGraph();
            while (it.hasNext()) {
                Node declParent;
                Declaration decl = it.next();
                if (decl.module == null || !moduleGraph.dependsOn(deepestDependency, decl.module)) continue;
                Node destParent = this.moduleVarParentMap.get(deepestDependency);
                if (destParent == null) {
                    destParent = this.compiler.getNodeForCodeInsertion(deepestDependency);
                    this.moduleVarParentMap.put(deepestDependency, destParent);
                }
                Preconditions.checkState((!(declParent = decl.node.getParent()).isVar() || declParent.hasOneChild() ? 1 : 0) != 0, (Object)"AST not normalized.");
                declParent.detachFromParent();
                destParent.addChildToFront(declParent);
                this.compiler.reportCodeChange();
            }
        }
    }

    private static boolean hasConditionalAncestor(Node n) {
        for (Node ancestor : n.getAncestors()) {
            switch (ancestor.getType()) {
                case 98: 
                case 105: 
                case 108: 
                case 110: 
                case 113: 
                case 114: 
                case 115: {
                    return true;
                }
            }
        }
        return false;
    }

    private NamedInfo getNamedInfo(Var v) {
        NamedInfo info = this.namedInfo.get(v);
        if (info == null) {
            info = new NamedInfo();
            this.namedInfo.put(v, info);
        }
        return info;
    }

    private void processRead(ReferenceCollectingCallback.Reference ref, NamedInfo info) {
        String name = ref.getNode().getString();
        boolean recursive = false;
        Scope hoistTarget = ref.getScope().getClosestHoistScope();
        if (hoistTarget.isFunctionBlockScope()) {
            Node rootNode = hoistTarget.getRootNode().getParent();
            String scopeFuncName = rootNode.getFirstChild().getString();
            Node scopeFuncParent = rootNode.getParent();
            if (scopeFuncName.equals(name)) {
                recursive = true;
            } else if (scopeFuncParent.isName() && scopeFuncParent.getString().equals(name)) {
                recursive = true;
            } else {
                Scope s = ref.getScope();
                while (s.getParent() != null) {
                    Node curRoot = s.getRootNode();
                    if (curRoot.getParent().isAssign()) {
                        Node owner = curRoot.getParent().getFirstChild();
                        while (owner.isGetProp()) {
                            owner = owner.getFirstChild();
                        }
                        if (owner.isName() && owner.getString().equals(name)) {
                            recursive = true;
                            break;
                        }
                    }
                    s = s.getParent();
                }
            }
        }
        if (!recursive) {
            info.addUsedModule(this.getModule(ref));
        }
    }

    private void collectReferences(Node root) {
        ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, new Predicate<Var>(){

            public boolean apply(Var var) {
                return var.isGlobal() && !CrossModuleCodeMotion.this.compiler.getCodingConvention().isExported(var.getName());
            }
        });
        NodeTraversal.traverseEs6(this.compiler, root, collector);
        for (Var v : collector.getAllSymbols()) {
            ReferenceCollectingCallback.ReferenceCollection refCollection = collector.getReferences(v);
            NamedInfo info = this.getNamedInfo(v);
            for (ReferenceCollectingCallback.Reference ref : refCollection) {
                this.processReference(collector, ref, info);
            }
        }
    }

    private void processReference(ReferenceCollectingCallback collector, ReferenceCollectingCallback.Reference ref, NamedInfo info) {
        Node n = ref.getNode();
        Node parent = n.getParent();
        if (info.allowMove) {
            if (this.maybeProcessDeclaration(collector, ref, info)) {
                if (CrossModuleCodeMotion.hasConditionalAncestor(parent.getParent())) {
                    info.allowMove = false;
                }
            } else if (this.parentModuleCanSeeSymbolsDeclaredInChildren && parent.isInstanceOf() && parent.getLastChild() == n) {
                this.instanceofNodes.put(parent, new InstanceofInfo(this.getModule(ref), info));
            } else {
                this.processRead(ref, info);
            }
        }
    }

    private JSModule getModule(ReferenceCollectingCallback.Reference ref) {
        return this.compiler.getInput(ref.getInputId()).getModule();
    }

    private boolean maybeProcessDeclaration(ReferenceCollectingCallback collector, ReferenceCollectingCallback.Reference ref, NamedInfo info) {
        Node name = ref.getNode();
        Node parent = name.getParent();
        Node grandparent = parent.getParent();
        switch (parent.getType()) {
            case 118: {
                if (CrossModuleCodeMotion.canMoveValue(collector, ref.getScope(), name.getFirstChild())) {
                    return info.addDeclaration(new Declaration(this.getModule(ref), name));
                }
                return false;
            }
            case 105: {
                if (NodeUtil.isFunctionDeclaration(parent)) {
                    return info.addDeclaration(new Declaration(this.getModule(ref), name));
                }
                return false;
            }
            case 33: 
            case 86: {
                Node child = name;
                for (Node current : name.getAncestors()) {
                    if (!current.isGetProp()) {
                        if (current.isAssign() && current.getFirstChild() == child) {
                            Node currentParent = current.getParent();
                            if (currentParent.isExprResult() && CrossModuleCodeMotion.canMoveValue(collector, ref.getScope(), current.getLastChild())) {
                                return info.addDeclaration(new Declaration(this.getModule(ref), current));
                            }
                        } else {
                            return false;
                        }
                    }
                    child = current;
                }
                return false;
            }
            case 37: {
                CodingConvention.SubclassRelationship relationship;
                if (NodeUtil.isExprCall(grandparent) && (relationship = this.compiler.getCodingConvention().getClassesDefinedByCall(parent)) != null && name.getString().equals(relationship.subclassName)) {
                    return info.addDeclaration(new Declaration(this.getModule(ref), parent));
                }
                return false;
            }
        }
        return false;
    }

    private static boolean canMoveValue(ReferenceCollectingCallback collector, Scope scope, Node n) {
        ReferenceCollectingCallback.ReferenceCollection refCollection;
        Var v;
        if (n == null || NodeUtil.isLiteralValue(n, true) || n.isFunction()) {
            return true;
        }
        if (n.isCall()) {
            Node functionName = n.getFirstChild();
            return functionName.isName() && (functionName.getString().equals("JSCompiler_stubMethod") || functionName.getString().equals("JSCompiler_unstubMethod"));
        }
        if (n.isArrayLit() || n.isObjectLit()) {
            boolean isObjectLit = n.isObjectLit();
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                if (CrossModuleCodeMotion.canMoveValue(collector, scope, isObjectLit ? child.getFirstChild() : child)) continue;
                return false;
            }
            return true;
        }
        return n.isName() && (v = scope.getVar(n.getString())) != null && v.isGlobal() && (refCollection = collector.getReferences(v)) != null && refCollection.isWellDefined() && refCollection.isAssignedOnceInLifetime();
    }

    private void makeInstanceOfCodeOrderIndependent() {
        Node tmp = IR.block();
        for (Map.Entry<Node, InstanceofInfo> entry : this.instanceofNodes.entrySet()) {
            Node ref;
            Node ne;
            Node parent;
            Node n = entry.getKey();
            InstanceofInfo info = entry.getValue();
            if (!((InstanceofInfo)info).namedInfo.allowMove || !info.mustBeGuardedByTypeof() || (parent = n.getParent()).isAnd() && parent.getLastChild() == n && parent.getFirstChild().isNE() && (ne = parent.getFirstChild()).getFirstChild().isString() && "undefined".equals(ne.getFirstChild().getString()) && ne.getLastChild().isTypeOf() && (ref = ne.getLastChild().getFirstChild()).isEquivalentTo(n.getLastChild())) continue;
            Node reference = n.getLastChild().cloneNode();
            Preconditions.checkState((boolean)reference.isName());
            n.getParent().replaceChild(n, tmp);
            Node and = IR.and(new Node(13, IR.string("undefined"), new Node(32, reference)), n);
            and.useSourceInfoIfMissingFromForTree(n);
            tmp.getParent().replaceChild(tmp, and);
            this.compiler.reportCodeChange();
        }
    }

    private static class Declaration {
        final JSModule module;
        final Node node;

        Declaration(JSModule module, Node node) {
            this.module = module;
            this.node = node;
        }
    }

    private class InstanceofInfo {
        private final JSModule module;
        private final NamedInfo namedInfo;

        InstanceofInfo(JSModule module, NamedInfo namedInfo) {
            this.module = module;
            this.namedInfo = namedInfo;
        }

        boolean mustBeGuardedByTypeof() {
            return !this.namedInfo.isUsedInOrDependencyOfModule(this.module);
        }
    }

    private class NamedInfo {
        boolean allowMove = true;
        private JSModule deepestModule = null;
        private JSModule declModule = null;
        private final Deque<Declaration> declarations = new ArrayDeque<Declaration>();

        private NamedInfo() {
        }

        void addUsedModule(JSModule m) {
            if (!this.allowMove) {
                return;
            }
            this.deepestModule = this.deepestModule == null ? m : CrossModuleCodeMotion.this.graph.getDeepestCommonDependencyInclusive(m, this.deepestModule);
        }

        boolean isUsedInOrDependencyOfModule(JSModule m) {
            if (this.deepestModule == null || m == null) {
                return false;
            }
            return m == this.deepestModule || CrossModuleCodeMotion.this.graph.dependsOn(m, this.deepestModule);
        }

        boolean addDeclaration(Declaration d) {
            if (this.declModule != null && d.module != this.declModule) {
                return false;
            }
            this.declarations.push(d);
            this.declModule = d.module;
            return true;
        }

        Iterator<Declaration> declarationIterator() {
            return this.declarations.iterator();
        }
    }
}

