/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.templates;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.templates.ITemplateAccess;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.text.templates.TemplateReaderWriter;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ProjectTemplateStore {
    private final ITemplateAccess fTemplateAccess;
    private final TemplateStore fInstanceStore;
    private final TemplateStore fProjectStore;

    public ProjectTemplateStore(ITemplateAccess templateAccess, IProject project) {
        this.fTemplateAccess = templateAccess;
        this.fInstanceStore = templateAccess.getTemplateStore();
        if (project == null || templateAccess instanceof ITemplateAccess.ITemplateAccessInternal) {
            this.fProjectStore = null;
        } else {
            final ITemplateAccess.ITemplateAccessInternal internal = (ITemplateAccess.ITemplateAccessInternal)((Object)templateAccess);
            final ScopedPreferenceStore projectSettings = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), internal.getPreferenceQualifier());
            this.fProjectStore = new TemplateStore((IPreferenceStore)projectSettings, internal.getPreferenceKey()){

                public void add(org.eclipse.text.templates.TemplatePersistenceData data) {
                    this.internalAdd(data);
                }

                public void save() throws IOException {
                    org.eclipse.text.templates.TemplatePersistenceData[] templateData = ProjectTemplateStore.this.getTemplateData();
                    int i = 0;
                    while (i < templateData.length) {
                        if (ProjectTemplateStore.this.isProjectSpecific(templateData[i].getId())) {
                            StringWriter output = new StringWriter();
                            TemplateReaderWriter writer = new TemplateReaderWriter();
                            writer.save((org.eclipse.text.templates.TemplatePersistenceData[])this.getTemplateData(false), (Writer)output);
                            projectSettings.setValue(internal.getPreferenceKey(), output.toString());
                            projectSettings.save();
                            return;
                        }
                        ++i;
                    }
                    projectSettings.setToDefault(internal.getPreferenceKey());
                    projectSettings.save();
                }
            };
        }
    }

    public boolean hasProjectSpecificTempates(IProject project) {
        if (!(this.fTemplateAccess instanceof ITemplateAccess.ITemplateAccessInternal)) {
            return false;
        }
        ITemplateAccess.ITemplateAccessInternal internal = (ITemplateAccess.ITemplateAccessInternal)((Object)this.fTemplateAccess);
        String pref = new ProjectScope(project).getNode(internal.getPreferenceQualifier()).get(internal.getPreferenceKey(), null);
        if (pref != null && pref.trim().length() > 0) {
            StringReader input = new StringReader(pref);
            TemplateReaderWriter reader = new TemplateReaderWriter();
            try {
                org.eclipse.text.templates.TemplatePersistenceData[] datas = reader.read((Reader)input);
                return datas.length > 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public org.eclipse.text.templates.TemplatePersistenceData[] getTemplateData() {
        if (this.fProjectStore != null) {
            return this.fProjectStore.getTemplateData(true);
        }
        return this.fInstanceStore.getTemplateData(true);
    }

    public Template findTemplateById(String id) {
        Template template = null;
        if (this.fProjectStore != null) {
            template = this.fProjectStore.findTemplateById(id);
        }
        if (template == null) {
            template = this.fInstanceStore.findTemplateById(id);
        }
        return template;
    }

    public void load() throws IOException {
        if (this.fProjectStore != null) {
            this.fProjectStore.load();
            HashSet<String> datas = new HashSet<String>();
            TemplatePersistenceData[] data = this.fProjectStore.getTemplateData(false);
            int i = 0;
            while (i < data.length) {
                datas.add(data[i].getId());
                ++i;
            }
            data = this.fInstanceStore.getTemplateData(false);
            i = 0;
            while (i < data.length) {
                TemplatePersistenceData orig = data[i];
                if (!datas.contains(orig.getId())) {
                    org.eclipse.text.templates.TemplatePersistenceData copy = new org.eclipse.text.templates.TemplatePersistenceData(new Template(orig.getTemplate()), orig.isEnabled(), orig.getId());
                    this.fProjectStore.add(copy);
                    copy.setDeleted(true);
                }
                ++i;
            }
        }
    }

    public boolean isProjectSpecific(String id) {
        if (id == null) {
            return false;
        }
        if (this.fProjectStore == null) {
            return false;
        }
        return this.fProjectStore.findTemplateById(id) != null;
    }

    public void setProjectSpecific(String id, boolean projectSpecific) {
        Assert.isNotNull((Object)this.fProjectStore);
        TemplatePersistenceData data = this.fProjectStore.getTemplateData(id);
        if (data == null) {
            return;
        }
        data.setDeleted(!projectSpecific);
    }

    public void restoreDefaults() {
        if (this.fProjectStore == null) {
            this.fInstanceStore.restoreDefaults();
        } else {
            try {
                this.load();
            }
            catch (IOException e) {
                DLTKUIPlugin.log(e);
            }
        }
    }

    public void save() throws IOException {
        if (this.fProjectStore == null) {
            this.fInstanceStore.save();
        } else {
            this.fProjectStore.save();
        }
    }

    public void revertChanges() throws IOException {
        if (this.fProjectStore == null) {
            this.fInstanceStore.load();
        }
    }

    public void addTemplateData(org.eclipse.text.templates.TemplatePersistenceData data) {
        if (this.fProjectStore != null) {
            this.fProjectStore.add(data);
        } else {
            this.fInstanceStore.add(data);
        }
    }

    public void delete(org.eclipse.text.templates.TemplatePersistenceData data) {
        if (this.fProjectStore != null) {
            this.fProjectStore.delete(data);
        } else {
            this.fInstanceStore.delete(data);
        }
    }
}

