/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.saveparticipant;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.PreferencesLookupDelegate;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.ui.editor.saveparticipant.IPostSaveListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Quote;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.core.preferences.PreferencesSupport;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RemoveTrailingWhitespacesSaveParticipant
implements IPostSaveListener {
    public static final String ID = "RemoveTrailingWhitespaces";
    public static final String EDITOR_SAVE_PARTICIPANT_PREFIX = "editor_save_participant_";
    private boolean removeTrailingWhitespacesEnabled = false;
    private boolean ignoreEmptyLines = false;

    public String getName() {
        return "Remove trailing whitespaces";
    }

    public String getId() {
        return ID;
    }

    public void updateSaveActionsState(@Nullable IProject project) {
        PreferencesSupport prefSupport = new PreferencesSupport("org.eclipse.php.ui");
        String doCleanupPref = prefSupport.getPreferencesValue("cleanup.remove_trailing_whitespaces", null, project);
        String ignoreEmptyPref = prefSupport.getPreferencesValue("cleanup.remove_trailing_whitespaces_ignore_empty", null, project);
        this.removeTrailingWhitespacesEnabled = Boolean.parseBoolean(doCleanupPref);
        this.ignoreEmptyLines = Boolean.parseBoolean(ignoreEmptyPref);
    }

    public boolean isEnabled(ISourceModule compilationUnit) {
        return new PreferencesLookupDelegate(compilationUnit.getScriptProject().getProject()).getBoolean("org.eclipse.php.ui", "editor_save_participant_RemoveTrailingWhitespaces");
    }

    public boolean needsChangedRegions(ISourceModule compilationUnit) throws CoreException {
        return false;
    }

    @NonNull
    protected MultiTextEdit computeTextEdit(@NonNull IDocument document, @Nullable Program astRoot) throws BadLocationException {
        List<Object> topMostHeredocs;
        if (astRoot != null) {
            TopMostHeredocFinder visitor = new TopMostHeredocFinder();
            astRoot.accept((Visitor)visitor);
            topMostHeredocs = visitor.getTopMostHeredocs();
        } else {
            topMostHeredocs = new ArrayList();
        }
        int lineCount = document.getNumberOfLines();
        MultiTextEdit multiEdit = new MultiTextEdit();
        int i = 0;
        while (i < lineCount) {
            IRegion region = document.getLineInformation(i);
            if (region.getLength() != 0) {
                int lineStart = region.getOffset();
                int lineExclusiveEnd = lineStart + region.getLength();
                int lineExclusiveDelimiterEnd = lineStart + document.getLineLength(i);
                boolean isInHeredoc = false;
                int j = 0;
                int len = topMostHeredocs.size();
                while (j < len) {
                    Quote heredoc = (Quote)topMostHeredocs.get(j);
                    if (lineExclusiveDelimiterEnd <= heredoc.getStart()) break;
                    if (heredoc.getEnd() <= lineStart) {
                        topMostHeredocs.remove(j);
                        --len;
                        --j;
                    } else if (heredoc.getStart() < lineExclusiveDelimiterEnd && heredoc.getEnd() >= lineExclusiveDelimiterEnd) {
                        isInHeredoc = true;
                        break;
                    }
                    ++j;
                }
                if (!isInHeredoc) {
                    j = lineExclusiveEnd - 1;
                    while (j >= lineStart && Character.isWhitespace(document.getChar(j))) {
                        --j;
                    }
                    if (!(this.ignoreEmptyLines && ++j == lineStart || j >= lineExclusiveEnd)) {
                        multiEdit.addChild((TextEdit)new DeleteEdit(j, lineExclusiveEnd - j));
                    }
                }
            }
            ++i;
        }
        return multiEdit;
    }

    public void saved(ISourceModule compilationUnit, IRegion[] changedRegions, IProgressMonitor monitor) throws CoreException {
        IScriptProject project = compilationUnit.getScriptProject();
        this.updateSaveActionsState(project != null ? project.getProject() : null);
        if (!this.removeTrailingWhitespacesEnabled) {
            return;
        }
        try {
            ASTParser parser = ASTParser.newParser((ISourceModule)compilationUnit);
            Program astRoot = parser.createAST(monitor);
            Document document = new Document(compilationUnit.getSource());
            MultiTextEdit edits = this.computeTextEdit((IDocument)document, astRoot);
            if (edits.hasChildren()) {
                SourceModuleChange change = new SourceModuleChange("Remove trailing whitespaces from " + compilationUnit.getElementName(), compilationUnit);
                change.setSaveMode(4);
                change.setEdit((TextEdit)edits);
                change.perform(monitor);
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", e.toString(), (Throwable)e));
        }
    }

    private static class TopMostHeredocFinder
    extends ApplyAll {
        private List<Quote> topMostHeredocs = new ArrayList<Quote>();

        private TopMostHeredocFinder() {
        }

        protected boolean apply(ASTNode node) {
            if (node instanceof Quote && (((Quote)node).getQuoteType() == 3 || ((Quote)node).getQuoteType() == 2)) {
                this.topMostHeredocs.add((Quote)node);
                return false;
            }
            return true;
        }

        public List<Quote> getTopMostHeredocs() {
            return this.topMostHeredocs;
        }
    }
}

