/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.formatter;

import java.util.List;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterTextNode;

public class FormatterUtils {
    public static boolean isSpace(char c) {
        return c == '\t' || c == ' ';
    }

    public static boolean isLineSeparator(char c) {
        return c == '\r' || c == '\n';
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean isNewLine(IFormatterNode node) {
        if (!(node instanceof IFormatterTextNode)) {
            return false;
        }
        IFormatterTextNode textNode = (IFormatterTextNode)node;
        IFormatterDocument document = node.getDocument();
        int start = textNode.getStartOffset();
        if (start < textNode.getEndOffset()) {
            if (document.charAt(start) == '\n') {
                ++start;
            } else {
                if (document.charAt(start) != '\r') {
                    return false;
                }
                if (++start < textNode.getEndOffset() && document.charAt(start) == '\n') {
                    ++start;
                }
            }
        }
        while (start < textNode.getEndOffset()) {
            if (!FormatterUtils.isSpace(document.charAt(start))) {
                return false;
            }
            ++start;
        }
        return true;
    }

    public static boolean isEmptyText(IFormatterNode node) {
        if (node instanceof IFormatterTextNode) {
            String text = ((IFormatterTextNode)node).getText();
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                if (!Character.isWhitespace(c)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static IFormatterNode[] toTextNodeArray(List<IFormatterNode> list) {
        if (list != null) {
            return list.toArray(new IFormatterNode[list.size()]);
        }
        return null;
    }
}

