/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyCore;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.corext.callhierarchy.CallSearchResultCollector;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;

class CalleeAnalyzerVisitor
extends HierarchicalASTVisitor {
    private final CallSearchResultCollector fSearchResults = new CallSearchResultCollector();
    private final IMember fMember;
    private final CompilationUnit fCompilationUnit;
    private final IProgressMonitor fProgressMonitor;
    private int fMethodEndPosition;
    private int fMethodStartPosition;
    private CallLocation fCalledAt;

    CalleeAnalyzerVisitor(CallLocation calledAt, IMember member, CompilationUnit compilationUnit, IProgressMonitor progressMonitor) {
        this.fCalledAt = calledAt;
        this.fMember = member;
        this.fCompilationUnit = compilationUnit;
        this.fProgressMonitor = progressMonitor;
        try {
            ISourceRange sourceRange = member.getSourceRange();
            this.fMethodStartPosition = sourceRange.getOffset();
            this.fMethodEndPosition = this.fMethodStartPosition + sourceRange.getLength();
        }
        catch (JavaModelException jme) {
            JavaManipulationPlugin.log(jme);
        }
    }

    public Map<String, MethodCall> getCallees() {
        return this.fSearchResults.getCallers();
    }

    @Override
    public boolean visit(ClassInstanceCreation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    @Override
    public boolean visit(ConstructorInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    @Override
    public boolean visit(AbstractTypeDeclaration node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            List bodyDeclarations = node.bodyDeclarations();
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                MethodDeclaration child;
                if (!(bodyDeclaration instanceof MethodDeclaration) || !(child = (MethodDeclaration)bodyDeclaration).isConstructor()) continue;
                this.addMethodCall(child.resolveBinding(), (ASTNode)child.getName());
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        this.progressMonitorWorked(1);
        if (Modifier.isAbstract((int)node.getModifiers()) || node.getParent() instanceof TypeDeclaration && ((TypeDeclaration)node.getParent()).isInterface()) {
            this.addMethodCall(node.resolveBinding(), (ASTNode)node);
        }
        return this.isFurtherTraversalNecessary((ASTNode)node);
    }

    @Override
    public boolean visit(MethodInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveMethodBinding(), (ASTNode)node);
        }
        return true;
    }

    @Override
    public boolean visit(MethodReference node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveMethodBinding(), (ASTNode)node);
        }
        return true;
    }

    @Override
    public boolean visit(SuperConstructorInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveConstructorBinding(), (ASTNode)node);
        }
        return true;
    }

    @Override
    public boolean visit(SuperMethodInvocation node) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)node)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)node)) {
            this.addMethodCall(node.resolveMethodBinding(), (ASTNode)node);
        }
        return true;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        return this.isNodeEnclosingMethod((ASTNode)node);
    }

    protected void addMethodCall(IMethodBinding calledMethodBinding, ASTNode node) {
        try {
            if (calledMethodBinding != null) {
                this.fProgressMonitor.worked(1);
                ITypeBinding calledTypeBinding = calledMethodBinding.getDeclaringClass();
                IType calledType = null;
                calledType = !calledTypeBinding.isAnonymous() ? (IType)calledTypeBinding.getJavaElement() : (!"java.lang.Object".equals(calledTypeBinding.getSuperclass().getQualifiedName()) ? (IType)calledTypeBinding.getSuperclass().getJavaElement() : (IType)calledTypeBinding.getInterfaces()[0].getJavaElement());
                IMethod calledMethod = CalleeAnalyzerVisitor.findIncludingSupertypes(calledMethodBinding, calledType, this.fProgressMonitor);
                ArrayList<Object> referencedMembers = new ArrayList<Object>();
                boolean implementationResults = false;
                if (calledMethod == null) {
                    if (calledMethodBinding.isConstructor() && calledMethodBinding.getParameterTypes().length == 0) {
                        referencedMembers.add(calledType);
                    }
                } else if (node instanceof MethodDeclaration && (calledType.isInterface() || Flags.isAbstract((int)calledType.getFlags()))) {
                    Collection<IJavaElement> implementingMethods = CallHierarchyCore.getDefault().getImplementingMethods(calledMethod);
                    implementationResults = true;
                    for (IJavaElement element : implementingMethods) {
                        if (element instanceof IMethod) {
                            if (this.isIgnoredBySearchScope((IMethod)element)) continue;
                            referencedMembers.add((IMethod)element);
                            continue;
                        }
                        if (!(element instanceof IMember)) continue;
                        referencedMembers.add((IMember)element);
                    }
                } else {
                    referencedMembers.add(calledMethod);
                }
                Optional<CallLocation> calledAt = Optional.ofNullable(this.fCalledAt);
                Integer ignore = -1;
                int position = implementationResults ? calledAt.map(CallLocation::getStart).orElse(ignore).intValue() : node.getStartPosition();
                int number = implementationResults ? calledAt.map(CallLocation::getLineNumber).orElse(ignore).intValue() : this.fCompilationUnit.getLineNumber(position);
                int length = implementationResults ? calledAt.map(c -> c.getEnd() - position).orElse(ignore).intValue() : node.getLength();
                IMember member = implementationResults ? calledAt.map(CallLocation::getMember).orElse(this.fMember) : this.fMember;
                boolean potential = implementationResults;
                referencedMembers.forEach(m -> this.fSearchResults.addMember(member, (IMember)m, position, position + length, number < 1 ? 1 : number, potential));
            }
        }
        catch (JavaModelException jme) {
            JavaManipulationPlugin.log(jme);
        }
    }

    private static IMethod findIncludingSupertypes(IMethodBinding method, IType type, IProgressMonitor pm) throws JavaModelException {
        IMethod inThisType = Bindings.findMethod(method, type);
        if (inThisType != null) {
            return inThisType;
        }
        IType[] iTypeArray = JavaModelUtil.getAllSuperTypes(type, pm);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType superType = iTypeArray[n2];
            IMethod m = Bindings.findMethod(method, superType);
            if (m != null) {
                return m;
            }
            ++n2;
        }
        return null;
    }

    private boolean isIgnoredBySearchScope(IMethod enclosingElement) {
        if (enclosingElement != null) {
            return !this.getSearchScope().encloses((IJavaElement)enclosingElement);
        }
        return false;
    }

    private IJavaSearchScope getSearchScope() {
        return CallHierarchyCore.getDefault().getSearchScope();
    }

    private boolean isNodeWithinMethod(ASTNode node) {
        int nodeStartPosition = node.getStartPosition();
        int nodeEndPosition = nodeStartPosition + node.getLength();
        if (nodeStartPosition < this.fMethodStartPosition) {
            return false;
        }
        return nodeEndPosition <= this.fMethodEndPosition;
    }

    private boolean isNodeEnclosingMethod(ASTNode node) {
        int nodeStartPosition = node.getStartPosition();
        int nodeEndPosition = nodeStartPosition + node.getLength();
        return nodeStartPosition < this.fMethodStartPosition && nodeEndPosition > this.fMethodEndPosition;
    }

    private boolean isFurtherTraversalNecessary(ASTNode node) {
        return this.isNodeWithinMethod(node) || this.isNodeEnclosingMethod(node);
    }

    private void progressMonitorWorked(int work) {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.worked(work);
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }
}

