/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.debug.ui.launchConfigurations.AbstractVMInstallPage;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.StandardVMPage;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.wizard.Wizard;

public abstract class VMInstallWizard
extends Wizard {
    private final VMStandin fEditVM;
    private final String[] fExistingNames;

    public VMInstallWizard(VMStandin editVM, IVMInstall[] currentInstalls) {
        this.fEditVM = editVM;
        ArrayList<String> names = new ArrayList<String>(currentInstalls.length);
        int i = 0;
        while (i < currentInstalls.length) {
            IVMInstall install = currentInstalls[i];
            if (!install.equals(editVM)) {
                names.add(install.getName());
            }
            ++i;
        }
        this.fExistingNames = names.toArray(new String[names.size()]);
    }

    protected VMStandin getVMInstall() {
        return this.fEditVM;
    }

    protected abstract VMStandin getResult();

    public boolean performFinish() {
        return this.getResult() != null;
    }

    public AbstractVMInstallPage getPage(IVMInstallType type) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(JDIDebugUIPlugin.getUniqueIdentifier(), "vmInstallPages");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement element = infos[i];
            String id = element.getAttribute("vmInstallType");
            if (type.getId().equals(id)) {
                try {
                    AbstractVMInstallPage page = (AbstractVMInstallPage)((Object)element.createExecutableExtension("class"));
                    page.setExistingNames(this.fExistingNames);
                    return page;
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
            ++i;
        }
        StandardVMPage standardVMPage = new StandardVMPage();
        standardVMPage.setExistingNames(this.fExistingNames);
        return standardVMPage;
    }
}

