/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.compat.internal;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.compat.internal.ClipboardServiceImpl;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.WorkbenchPart;

public class PartHelper {
    private static final String ORG_ECLIPSE_E4_UI_WORKBENCH_I_PRESENTATION_ENGINE = "org.eclipse.e4.ui.workbench.IPresentationEngine";

    public static IEclipseContext createPartContext(WorkbenchPart part) throws PartInitException {
        IWorkbenchPartSite site = part.getSite();
        IEclipseContext parentContext = (IEclipseContext)site.getService(IEclipseContext.class);
        if (parentContext.get(ORG_ECLIPSE_E4_UI_WORKBENCH_I_PRESENTATION_ENGINE) != null) {
            try {
                IEclipseContext ctx;
                Class clazz = Platform.getBundle((String)"org.eclipse.e4.ui.model.workbench").loadClass("org.eclipse.e4.ui.model.application.ui.basic.MPart");
                Object instance = site.getService(clazz);
                Method m = clazz.getMethod("getContext", new Class[0]);
                IEclipseContext rv = ctx = (IEclipseContext)m.invoke(instance, new Object[0]);
                while (ctx.getParent() != null) {
                    ctx = ctx.getParent();
                }
                ctx.set(IClipboardService.class, (Object)new ClipboardServiceImpl());
                return rv;
            }
            catch (Exception e) {
                throw new PartInitException("Could not create context", (Throwable)e);
            }
        }
        return parentContext.createChild("EditPart('" + part.getPartName() + "')");
    }

    public static <C> C createComponent(Composite parent, IEclipseContext context, Class<C> clazz, WorkbenchPart part) {
        SelectionProviderImpl s = new SelectionProviderImpl();
        context.set(ISelectionProvider.class, (Object)s);
        part.getSite().setSelectionProvider((ISelectionProvider)s);
        IStylingEngine styleEngine = (IStylingEngine)context.get(IStylingEngine.class);
        Composite comp = new Composite(parent, 0);
        comp.setBackgroundMode(1);
        FillLayout layout = new FillLayout();
        comp.setLayout((Layout)layout);
        context.set(Composite.class.getName(), (Object)comp);
        Object component = ContextInjectionFactory.make(clazz, (IEclipseContext)context);
        styleEngine.setClassname((Object)comp, part.getClass().getSimpleName());
        return (C)component;
    }

    public static void disposeContextIfE3(IEclipseContext parentContext, IEclipseContext context) {
        if (parentContext.get(ORG_ECLIPSE_E4_UI_WORKBENCH_I_PRESENTATION_ENGINE) == null) {
            context.dispose();
            context = null;
        }
    }

    static class SelectionProviderImpl
    implements ISelectionProvider {
        private ISelection currentSelection = StructuredSelection.EMPTY;
        private final ListenerList<ISelectionChangedListener> listeners = new ListenerList();

        SelectionProviderImpl() {
        }

        public void setSelection(ISelection selection) {
            this.currentSelection = selection;
            SelectionChangedEvent evt = new SelectionChangedEvent((ISelectionProvider)this, selection);
            for (ISelectionChangedListener l : this.listeners) {
                l.selectionChanged(evt);
            }
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove((Object)listener);
        }

        public ISelection getSelection() {
            return this.currentSelection;
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add((Object)listener);
        }
    }
}

