/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTConverter;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DefaultBindingResolver;
import org.eclipse.jdt.core.dom.FileASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.NameEnvironmentWithProgress;
import org.eclipse.jdt.core.dom.NodeSearcher;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.CancelableNameEnvironment;
import org.eclipse.jdt.internal.core.CancelableProblemFactory;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.INameEnvironmentWithProgress;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.dom.ICompilationUnitResolver;
import org.eclipse.jdt.internal.core.util.BindingKeyResolver;
import org.eclipse.jdt.internal.core.util.CommentRecorderParser;

class CompilationUnitResolver
extends Compiler {
    private static ECJCompilationUnitResolver FACADE;
    public static final int RESOLVE_BINDING = 1;
    public static final int PARTIAL = 2;
    public static final int STATEMENT_RECOVERY = 4;
    public static final int IGNORE_METHOD_BODIES = 8;
    public static final int BINDING_RECOVERY = 16;
    public static final int INCLUDE_RUNNING_VM_BOOTCLASSPATH = 32;
    public static final int FORCE_PROBLEM_DETECTION = 64;
    HashtableOfObject requestedSources;
    HashtableOfObject requestedKeys;
    DefaultBindingResolver.BindingTables bindingTables;
    boolean hasCompilationAborted = false;
    CategorizedProblem abortProblem;
    private final IProgressMonitor monitor;
    boolean fromJavaProject;

    public static synchronized ICompilationUnitResolver getInstance() {
        if (FACADE == null) {
            FACADE = new ECJCompilationUnitResolver();
        }
        return FACADE;
    }

    public CompilationUnitResolver(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions compilerOptions, ICompilerRequestor requestor, IProblemFactory problemFactory, IProgressMonitor monitor, boolean fromJavaProject) {
        super(environment, policy, compilerOptions, requestor, problemFactory);
        this.monitor = monitor;
        this.fromJavaProject = fromJavaProject;
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        SourceTypeElementInfo sourceType = (SourceTypeElementInfo)sourceTypes[0];
        this.accept((org.eclipse.jdt.internal.compiler.env.ICompilationUnit)sourceType.getHandle().getCompilationUnit(), accessRestriction);
    }

    public synchronized void accept(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        super.accept(sourceUnit, accessRestriction);
    }

    protected void beginToCompile(org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] sourceUnits, String[] bindingKeys) {
        CompilationUnitDeclaration parsedUnit;
        int sourceLength = sourceUnits.length;
        int keyLength = bindingKeys.length;
        int maxUnits = sourceLength + keyLength;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[maxUnits];
        int index = 0;
        this.requestedSources = new HashtableOfObject();
        int i = 0;
        while (i < sourceLength) {
            org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = sourceUnits[i];
            CompilationResult unitResult = new CompilationResult(sourceUnit, index++, maxUnits, this.options.maxProblemsPerUnit);
            try {
                if (this.options.verbose) {
                    this.out.println(Messages.bind((String)Messages.compilation_request, (Object[])new String[]{String.valueOf(index++ + 1), String.valueOf(maxUnits), new String(sourceUnit.getFileName())}));
                }
                if (this.parser instanceof CommentRecorderParser) {
                    ((CommentRecorderParser)this.parser).resetComments();
                }
                parsedUnit = this.totalUnits < this.parseThreshold ? this.parser.parse(sourceUnit, unitResult) : this.parser.dietParse(sourceUnit, unitResult);
                this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                this.addCompilationUnit(sourceUnit, parsedUnit);
                this.requestedSources.put(unitResult.getFileName(), (Object)sourceUnit);
                this.worked(1);
            }
            finally {
                sourceUnits[i] = null;
            }
            ++i;
        }
        this.requestedKeys = new HashtableOfObject();
        i = 0;
        while (i < keyLength) {
            BindingKeyResolver resolver = new BindingKeyResolver(bindingKeys[i], this, this.lookupEnvironment);
            resolver.parse(true);
            CompilationUnitDeclaration compilationUnitDeclaration = parsedUnit = resolver.hasTypeName() ? resolver.getCompilationUnitDeclaration() : null;
            if (parsedUnit != null) {
                char[] fileName = parsedUnit.compilationResult.getFileName();
                Object existing = this.requestedKeys.get(fileName);
                if (existing == null) {
                    this.requestedKeys.put(fileName, (Object)resolver);
                } else if (existing instanceof ArrayList) {
                    ((ArrayList)existing).add(resolver);
                } else {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(existing);
                    list.add(resolver);
                    this.requestedKeys.put(fileName, list);
                }
            } else {
                char[] key = resolver.hasTypeName() ? resolver.getKey().toCharArray() : (resolver.hasModuleName() ? resolver.moduleName() : CharOperation.concatWith((char[][])resolver.compoundName(), (char)'.'));
                this.requestedKeys.put(key, (Object)resolver);
            }
            this.worked(1);
            ++i;
        }
        this.lookupEnvironment.completeTypeBindings();
    }

    IBinding createBinding(String key) {
        if (this.bindingTables == null) {
            throw new RuntimeException("Cannot be called outside ASTParser#createASTs(...)");
        }
        BindingKeyResolver keyResolver = new BindingKeyResolver(key, this, this.lookupEnvironment);
        Binding compilerBinding = keyResolver.getCompilerBinding();
        if (compilerBinding == null) {
            return null;
        }
        DefaultBindingResolver resolver = new DefaultBindingResolver(this.lookupEnvironment, null, this.bindingTables, false, this.fromJavaProject);
        return resolver.getBinding(compilerBinding);
    }

    public static CompilationUnit convert(CompilationUnitDeclaration compilationUnitDeclaration, char[] source, int apiLevel, Map options, boolean needToResolveBindings, WorkingCopyOwner owner, DefaultBindingResolver.BindingTables bindingTables, int flags, IProgressMonitor monitor, boolean fromJavaProject) {
        return CompilationUnitResolver.convert(compilationUnitDeclaration, source, apiLevel, options, needToResolveBindings, owner, bindingTables, flags, monitor, fromJavaProject, null);
    }

    public static CompilationUnit convert(CompilationUnitDeclaration compilationUnitDeclaration, char[] source, int apiLevel, Map options, boolean needToResolveBindings, WorkingCopyOwner owner, DefaultBindingResolver.BindingTables bindingTables, int flags, IProgressMonitor monitor, boolean fromJavaProject, IJavaProject project) {
        BindingResolver resolver = null;
        AST ast = AST.newAST(apiLevel, "enabled".equals(options.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures")));
        String sourceModeSetting = (String)options.get("org.eclipse.jdt.core.compiler.source");
        long sourceLevel = CompilerOptions.versionToJdkLevel((String)sourceModeSetting);
        if (sourceLevel == 0L) {
            sourceLevel = CompilerOptions.getFirstSupportedJdkLevel();
        }
        ast.scanner.sourceLevel = sourceLevel;
        String compliance = (String)options.get("org.eclipse.jdt.core.compiler.compliance");
        long complianceLevel = CompilerOptions.versionToJdkLevel((String)compliance);
        if (complianceLevel == 0L) {
            complianceLevel = sourceLevel;
        }
        ast.scanner.complianceLevel = complianceLevel;
        ast.setDefaultNodeFlag(2);
        CompilationUnit compilationUnit = null;
        ASTConverter converter = new ASTConverter(options, needToResolveBindings, monitor);
        if (needToResolveBindings) {
            resolver = new DefaultBindingResolver(compilationUnitDeclaration.scope, owner, bindingTables, (flags & 4) != 0, fromJavaProject);
            ast.setFlag(flags | Integer.MIN_VALUE);
        } else {
            resolver = new BindingResolver();
            ast.setFlag(flags);
        }
        ast.setBindingResolver(resolver);
        converter.setAST(ast);
        converter.docParser.setProjectPath(CompilationUnitResolver.getProjectPath(project));
        converter.docParser.setProjectSrcClasspath(CompilationUnitResolver.getSourceClassPaths(project));
        compilationUnit = converter.convert(compilationUnitDeclaration, source);
        compilationUnit.setLineEndTable(compilationUnitDeclaration.compilationResult.getLineSeparatorPositions());
        ast.setDefaultNodeFlag(0);
        ast.setOriginalModificationCount(ast.modificationCount());
        return compilationUnit;
    }

    private static String getProjectPath(IJavaProject project) {
        if (project == null) {
            return null;
        }
        IProject rp = project.getProject();
        if (rp == null) {
            return null;
        }
        IPath location = rp.getLocation();
        if (location == null) {
            return null;
        }
        return location.toOSString();
    }

    private static ArrayList<String> getSourceClassPaths(IJavaProject project) {
        ArrayList<String> srcClassPath = new ArrayList<String>();
        if (project == null) {
            return srcClassPath;
        }
        if (project.getProject() == null) {
            return srcClassPath;
        }
        IClasspathEntry[] resolvedClasspath = null;
        try {
            resolvedClasspath = project.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (resolvedClasspath == null) {
            return srcClassPath;
        }
        IClasspathEntry[] iClasspathEntryArray = resolvedClasspath;
        int n = resolvedClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3 && entry instanceof ClasspathEntry) {
                IPath path = ((ClasspathEntry)entry).getPath();
                srcClassPath.add(path.removeFirstSegments(1).toString());
            }
            ++n2;
        }
        return srcClassPath;
    }

    protected static CompilerOptions getCompilerOptions(Map options, boolean statementsRecovery) {
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.performMethodsFullRecovery = statementsRecovery;
        compilerOptions.performStatementsRecovery = statementsRecovery;
        compilerOptions.parseLiteralExpressionsAsConstants = false;
        compilerOptions.storeAnnotations = true;
        compilerOptions.ignoreSourceFolderWarningOption = true;
        return compilerOptions;
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return false;
            }

            public boolean ignoreAllErrors() {
                return false;
            }
        };
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, false);
    }

    public void process(CompilationUnitDeclaration unit, int i) {
        char[] fileName = unit.compilationResult.getFileName();
        if (this.requestedKeys.get(fileName) == null && this.requestedSources.get(fileName) == null) {
            super.process(unit, i);
        }
    }

    protected void handleInternalException(Throwable internalException, CompilationUnitDeclaration unit, CompilationResult result) {
        super.handleInternalException(internalException, unit, result);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
    }

    protected void handleInternalException(AbortCompilation abortException, CompilationUnitDeclaration unit) {
        super.handleInternalException(abortException, unit);
        if (unit != null) {
            this.removeUnresolvedBindings(unit);
        }
        this.hasCompilationAborted = true;
        this.abortProblem = abortException.problem;
    }

    public static void parse(ICompilationUnit[] compilationUnits, ASTRequestor astRequestor, int apiLevel, Map options, int flags, IProgressMonitor monitor) {
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.ignoreMethodBodies = (flags & 8) != 0;
        CommentRecorderParser parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory()), false);
        int unitLength = compilationUnits.length;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        int i = 0;
        while (i < unitLength) {
            subMonitor.setWorkRemaining(unitLength - i);
            org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)compilationUnits[i];
            CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
            CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse(sourceUnit, compilationResult);
            if (compilationUnitDeclaration.ignoreMethodBodies) {
                compilationUnitDeclaration.ignoreFurtherInvestigation = true;
            } else {
                TypeDeclaration[] types = compilationUnitDeclaration.types;
                if (types != null) {
                    TypeDeclaration[] typeDeclarationArray = types;
                    int n = types.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TypeDeclaration type = typeDeclarationArray[n2];
                        type.parseMethods((Parser)parser, compilationUnitDeclaration);
                        ++n2;
                    }
                }
                CompilationUnit node = CompilationUnitResolver.convert(compilationUnitDeclaration, parser.scanner.getSource(), apiLevel, options, false, null, null, flags, (IProgressMonitor)subMonitor.split(1), true);
                node.setTypeRoot(compilationUnits[i]);
                astRequestor.acceptAST(compilationUnits[i], node);
            }
            ++i;
        }
    }

    public static void parse(String[] sourceUnits, String[] encodings, FileASTRequestor astRequestor, int apiLevel, Map options, int flags, IProgressMonitor monitor) {
        CompilerOptions compilerOptions = new CompilerOptions(options);
        compilerOptions.ignoreMethodBodies = (flags & 8) != 0;
        CommentRecorderParser parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory()), false);
        int unitLength = sourceUnits.length;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)unitLength);
        int i = 0;
        while (i < unitLength) {
            block8: {
                SubMonitor iterationMonitor = subMonitor.split(1);
                char[] contents = null;
                String encoding = encodings != null ? encodings[i] : null;
                try {
                    contents = Util.getFileCharContent((File)new File(sourceUnits[i]), (String)encoding);
                }
                catch (IOException e) {
                    break block8;
                }
                if (contents != null) {
                    org.eclipse.jdt.internal.compiler.batch.CompilationUnit compilationUnit;
                    org.eclipse.jdt.internal.compiler.batch.CompilationUnit sourceUnit = compilationUnit = new org.eclipse.jdt.internal.compiler.batch.CompilationUnit(contents, sourceUnits[i], encoding);
                    CompilationResult compilationResult = new CompilationResult((org.eclipse.jdt.internal.compiler.env.ICompilationUnit)sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
                    CompilationUnitDeclaration compilationUnitDeclaration = parser.dietParse((org.eclipse.jdt.internal.compiler.env.ICompilationUnit)sourceUnit, compilationResult);
                    if (compilationUnitDeclaration.ignoreMethodBodies) {
                        compilationUnitDeclaration.ignoreFurtherInvestigation = true;
                    } else {
                        TypeDeclaration[] types = compilationUnitDeclaration.types;
                        if (types != null) {
                            TypeDeclaration[] typeDeclarationArray = types;
                            int n = types.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TypeDeclaration type = typeDeclarationArray[n2];
                                type.parseMethods((Parser)parser, compilationUnitDeclaration);
                                ++n2;
                            }
                        }
                        CompilationUnit node = CompilationUnitResolver.convert(compilationUnitDeclaration, parser.scanner.getSource(), apiLevel, options, false, null, null, flags, (IProgressMonitor)iterationMonitor, true);
                        node.setTypeRoot(null);
                        astRequestor.acceptAST(sourceUnits[i], node);
                    }
                }
            }
            ++i;
        }
    }

    public static CompilationUnitDeclaration parse(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, Map settings, int flags) {
        return CompilationUnitResolver.parse(sourceUnit, nodeSearcher, settings, flags, null);
    }

    public static CompilationUnitDeclaration parse(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, Map settings, int flags, IJavaProject project) {
        CompilationUnitDeclaration compilationUnitDeclaration;
        block9: {
            CommentRecorderParser parser;
            block7: {
                ASTNode node;
                block10: {
                    TypeDeclaration enclosingTypeDeclaration;
                    block8: {
                        boolean statementsRecovery;
                        if (sourceUnit == null) {
                            throw new IllegalStateException();
                        }
                        CompilerOptions compilerOptions = new CompilerOptions(settings);
                        compilerOptions.performMethodsFullRecovery = statementsRecovery = (flags & 2) != 0;
                        compilerOptions.performStatementsRecovery = statementsRecovery;
                        compilerOptions.ignoreMethodBodies = (flags & 8) != 0;
                        parser = new CommentRecorderParser(new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), compilerOptions, (IProblemFactory)new DefaultProblemFactory()), false);
                        if (project != null) {
                            parser.javadocParser.setProjectPath(CompilationUnitResolver.getProjectPath(project));
                            parser.javadocParser.setProjectSrcClasspath(CompilationUnitResolver.getSourceClassPaths(project));
                        }
                        CompilationResult compilationResult = new CompilationResult(sourceUnit, 0, 0, compilerOptions.maxProblemsPerUnit);
                        compilationUnitDeclaration = parser.dietParse(sourceUnit, compilationResult);
                        if (compilationUnitDeclaration.ignoreMethodBodies) {
                            compilationUnitDeclaration.ignoreFurtherInvestigation = true;
                            return compilationUnitDeclaration;
                        }
                        if (nodeSearcher == null) break block7;
                        char[] source = parser.scanner.getSource();
                        int searchPosition = nodeSearcher.position;
                        if (searchPosition < 0 || searchPosition > source.length) {
                            return compilationUnitDeclaration;
                        }
                        compilationUnitDeclaration.traverse((ASTVisitor)nodeSearcher, compilationUnitDeclaration.scope);
                        node = nodeSearcher.found;
                        if (node == null) {
                            return compilationUnitDeclaration;
                        }
                        enclosingTypeDeclaration = nodeSearcher.enclosingType;
                        if (!(node instanceof AbstractMethodDeclaration)) break block8;
                        ((AbstractMethodDeclaration)node).parseStatements((Parser)parser, compilationUnitDeclaration);
                        break block9;
                    }
                    if (enclosingTypeDeclaration == null) break block9;
                    if (!(node instanceof Initializer)) break block10;
                    ((Initializer)node).parseStatements((Parser)parser, enclosingTypeDeclaration, compilationUnitDeclaration);
                    break block9;
                }
                if (!(node instanceof TypeDeclaration)) break block9;
                ((TypeDeclaration)node).parseMethods((Parser)parser, compilationUnitDeclaration);
                break block9;
            }
            TypeDeclaration[] types = compilationUnitDeclaration.types;
            if (types != null) {
                TypeDeclaration[] typeDeclarationArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeDeclaration type = typeDeclarationArray[n2];
                    type.parseMethods((Parser)parser, compilationUnitDeclaration);
                    ++n2;
                }
            }
        }
        return compilationUnitDeclaration;
    }

    public static void resolve(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, int apiLevel, Map options, IJavaProject javaProject, WorkingCopyOwner owner, int flags, IProgressMonitor monitor) {
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        try {
            try {
                int amountOfWork = (compilationUnits.length + bindingKeys.length) * 2;
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)amountOfWork);
                environment = new CancelableNameEnvironment((JavaProject)javaProject, owner, (IProgressMonitor)subMonitor);
                problemFactory = new CancelableProblemFactory((IProgressMonitor)subMonitor);
                CompilerOptions compilerOptions = CompilationUnitResolver.getCompilerOptions(options, (flags & 2) != 0);
                compilerOptions.ignoreMethodBodies = (flags & 8) != 0;
                CompilationUnitResolver resolver = new CompilationUnitResolver((INameEnvironment)environment, CompilationUnitResolver.getHandlingPolicy(), compilerOptions, CompilationUnitResolver.getRequestor(), (IProblemFactory)problemFactory, (IProgressMonitor)subMonitor, javaProject != null);
                resolver.resolve(compilationUnits, bindingKeys, requestor, apiLevel, options, owner, flags);
                if (NameLookup.VERBOSE) {
                    environment.printTimeSpent();
                }
            }
            catch (JavaModelException e) {
                CompilationUnitResolver.parse(compilationUnits, requestor, apiLevel, options, flags, monitor);
                if (environment != null) {
                    environment.setMonitor(null);
                }
                if (problemFactory != null) {
                    problemFactory.monitor = null;
                }
            }
        }
        finally {
            if (environment != null) {
                environment.setMonitor(null);
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
        }
    }

    public static void resolve(String[] sourceUnits, String[] encodings, String[] bindingKeys, FileASTRequestor requestor, int apiLevel, Map options, List classpaths, int flags, IProgressMonitor monitor) {
        INameEnvironmentWithProgress environment = null;
        CancelableProblemFactory problemFactory = null;
        try {
            int amountOfWork = (sourceUnits.length + bindingKeys.length) * 2;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)amountOfWork);
            FileSystem.Classpath[] allEntries = new FileSystem.Classpath[classpaths.size()];
            classpaths.toArray(allEntries);
            environment = new NameEnvironmentWithProgress(allEntries, null, (IProgressMonitor)subMonitor);
            problemFactory = new CancelableProblemFactory((IProgressMonitor)subMonitor);
            CompilerOptions compilerOptions = CompilationUnitResolver.getCompilerOptions(options, (flags & 2) != 0);
            compilerOptions.ignoreMethodBodies = (flags & 8) != 0;
            CompilationUnitResolver resolver = new CompilationUnitResolver((INameEnvironment)environment, CompilationUnitResolver.getHandlingPolicy(), compilerOptions, CompilationUnitResolver.getRequestor(), (IProblemFactory)problemFactory, (IProgressMonitor)subMonitor, false);
            resolver.resolve(sourceUnits, encodings, bindingKeys, requestor, apiLevel, options, flags);
            if (NameLookup.VERBOSE && environment instanceof CancelableNameEnvironment) {
                CancelableNameEnvironment cancelableNameEnvironment = (CancelableNameEnvironment)environment;
                cancelableNameEnvironment.printTimeSpent();
            }
        }
        finally {
            if (environment != null) {
                environment.setMonitor(null);
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
        }
    }

    public static CompilationUnitDeclaration resolve(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, IJavaProject javaProject, List classpaths, NodeSearcher nodeSearcher, Map options, WorkingCopyOwner owner, int flags, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnitDeclaration unit = null;
        INameEnvironmentWithProgress environment = null;
        CancelableProblemFactory problemFactory = null;
        CompilationUnitResolver resolver = null;
        try {
            boolean ignoreMethodBodies;
            if (javaProject == null) {
                FileSystem.Classpath[] allEntries = new FileSystem.Classpath[classpaths.size()];
                classpaths.toArray(allEntries);
                environment = new NameEnvironmentWithProgress(allEntries, null, monitor);
            } else {
                environment = new CancelableNameEnvironment((JavaProject)javaProject, owner, monitor);
            }
            problemFactory = new CancelableProblemFactory(monitor);
            CompilerOptions compilerOptions = CompilationUnitResolver.getCompilerOptions(options, (flags & 2) != 0);
            compilerOptions.ignoreMethodBodies = ignoreMethodBodies = (flags & 8) != 0;
            resolver = new CompilationUnitResolver((INameEnvironment)environment, CompilationUnitResolver.getHandlingPolicy(), compilerOptions, CompilationUnitResolver.getRequestor(), (IProblemFactory)problemFactory, monitor, javaProject != null);
            boolean analyzeAndGenerateCode = !ignoreMethodBodies;
            unit = resolver.resolve(null, sourceUnit, nodeSearcher, true, analyzeAndGenerateCode, analyzeAndGenerateCode);
            if (resolver.hasCompilationAborted) {
                CompilationUnitDeclaration unitDeclaration = CompilationUnitResolver.parse(sourceUnit, nodeSearcher, options, flags);
                if (unit != null) {
                    int problemCount = unit.compilationResult.problemCount;
                    if (problemCount != 0) {
                        unitDeclaration.compilationResult.problems = new CategorizedProblem[problemCount];
                        System.arraycopy(unit.compilationResult.problems, 0, unitDeclaration.compilationResult.problems, 0, problemCount);
                        unitDeclaration.compilationResult.problemCount = problemCount;
                    }
                } else if (resolver.abortProblem != null) {
                    unitDeclaration.compilationResult.problemCount = 1;
                    unitDeclaration.compilationResult.problems = new CategorizedProblem[]{resolver.abortProblem};
                }
                CompilationUnitDeclaration compilationUnitDeclaration = unitDeclaration;
                return compilationUnitDeclaration;
            }
            if (NameLookup.VERBOSE && environment instanceof CancelableNameEnvironment) {
                CancelableNameEnvironment cancelableNameEnvironment = (CancelableNameEnvironment)environment;
                cancelableNameEnvironment.printTimeSpent();
            }
            if (unit != null && unit.scope != null && unit.scope.environment != null && unit.scope.environment.unitBeingCompleted == null) {
                unit.scope.environment.unitBeingCompleted = unit;
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit;
            return compilationUnitDeclaration;
        }
        finally {
            if (environment != null) {
                environment.setMonitor(null);
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
        }
    }

    public static IBinding[] resolve(IJavaElement[] elements, int apiLevel, Map compilerOptions, IJavaProject javaProject, WorkingCopyOwner owner, int flags, IProgressMonitor monitor) {
        return ASTParser.resolve(elements, apiLevel, compilerOptions, javaProject, owner, flags, CompilationUnitResolver.getInstance(), monitor);
    }

    public void removeUnresolvedBindings(CompilationUnitDeclaration compilationUnitDeclaration) {
        TypeDeclaration[] types = compilationUnitDeclaration.types;
        if (types != null) {
            TypeDeclaration[] typeDeclarationArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration type = typeDeclarationArray[n2];
                this.removeUnresolvedBindings(type);
                ++n2;
            }
        }
    }

    private void removeUnresolvedBindings(TypeDeclaration type) {
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields;
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            TypeDeclaration[] typeDeclarationArray = memberTypes;
            int n = memberTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration memberType = typeDeclarationArray[n2];
                this.removeUnresolvedBindings(memberType);
                ++n2;
            }
        }
        if (type.binding != null && (type.binding.modifiers & 0x2000000) != 0) {
            type.binding = null;
        }
        if ((fields = type.fields) != null) {
            int i = 0;
            int max = fields.length;
            while (i < max) {
                if (fields[i].binding != null && (fields[i].binding.modifiers & 0x2000000) != 0) {
                    fields[i].binding = null;
                }
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            int max = methods.length;
            while (i < max) {
                if (methods[i].binding != null && (methods[i].binding.modifiers & 0x2000000) != 0) {
                    methods[i].binding = null;
                }
                ++i;
            }
        }
    }

    private void resolve(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor astRequestor, int apiLevel, Map compilerOptions, WorkingCopyOwner owner, int flags) {
        astRequestor.additionalBindingResolver = this::createBinding;
        this.bindingTables = new DefaultBindingResolver.BindingTables();
        CompilationUnitDeclaration unit = null;
        try {
            try {
                int length = compilationUnits.length;
                org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] sourceUnits = new org.eclipse.jdt.internal.compiler.env.ICompilationUnit[length];
                System.arraycopy(compilationUnits, 0, sourceUnits, 0, length);
                this.beginToCompile(sourceUnits, bindingKeys);
                int i = 0;
                while (i < this.totalUnits) {
                    if (this.resolvedRequestedSourcesAndKeys(i)) {
                        while (i < this.totalUnits) {
                            this.unitsToProcess[i].cleanUp();
                            this.unitsToProcess[i] = null;
                            ++i;
                        }
                        break;
                    }
                    unit = this.unitsToProcess[i];
                    try {
                        Object key;
                        super.process(unit, i);
                        char[] fileName = unit.compilationResult.getFileName();
                        ICompilationUnit source = (ICompilationUnit)this.requestedSources.get(fileName);
                        if (source != null) {
                            CompilationResult compilationResult = unit.compilationResult;
                            org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = compilationResult.compilationUnit;
                            char[] contents = sourceUnit.getContents();
                            AST ast = AST.newAST(apiLevel, "enabled".equals(this.options.getMap().get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures")));
                            ast.setFlag(flags | Integer.MIN_VALUE);
                            ast.setDefaultNodeFlag(2);
                            ASTConverter converter = new ASTConverter(compilerOptions, true, this.monitor);
                            DefaultBindingResolver resolver = new DefaultBindingResolver(unit.scope, owner, this.bindingTables, (flags & 4) != 0, this.fromJavaProject);
                            ast.setBindingResolver(resolver);
                            converter.setAST(ast);
                            CompilationUnit compilationUnit = converter.convert(unit, contents);
                            compilationUnit.setTypeRoot(source);
                            compilationUnit.setLineEndTable(compilationResult.getLineSeparatorPositions());
                            ast.setDefaultNodeFlag(0);
                            ast.setOriginalModificationCount(ast.modificationCount());
                            try {
                                astRequestor.acceptAST(source, compilationUnit);
                            }
                            catch (RuntimeException e) {
                                throw new RuntimeException("Error on " + String.valueOf(source.getPath()), e);
                            }
                            this.worked(1);
                            this.requestedSources.put(fileName, null);
                        }
                        if ((key = this.requestedKeys.get(fileName)) != null) {
                            if (key instanceof BindingKeyResolver) {
                                this.reportBinding(key, astRequestor, owner, unit);
                                this.worked(1);
                            } else if (key instanceof ArrayList) {
                                Iterator iterator = ((ArrayList)key).iterator();
                                while (iterator.hasNext()) {
                                    this.reportBinding(iterator.next(), astRequestor, owner, unit);
                                    this.worked(1);
                                }
                            }
                            this.requestedKeys.put(fileName, null);
                        }
                    }
                    finally {
                        unit.cleanUp();
                    }
                    this.unitsToProcess[i] = null;
                    this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
                    ++i;
                }
                DefaultBindingResolver resolver = new DefaultBindingResolver(this.lookupEnvironment, owner, this.bindingTables, (flags & 4) != 0, true);
                Object[] keys = this.requestedKeys.valueTable;
                int j = 0;
                int keysLength = keys.length;
                while (j < keysLength) {
                    BindingKeyResolver keyResolver = (BindingKeyResolver)keys[j];
                    if (keyResolver != null) {
                        Binding compilerBinding = keyResolver.getCompilerBinding();
                        IBinding binding = compilerBinding == null ? null : resolver.getBinding(compilerBinding);
                        astRequestor.acceptBinding(((BindingKeyResolver)this.requestedKeys.valueTable[j]).getKey(), binding);
                        this.worked(1);
                    }
                    ++j;
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (AbortCompilation e) {
                this.handleInternalException(e, unit);
                astRequestor.additionalBindingResolver = null;
            }
            catch (Error | RuntimeException e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
        }
        finally {
            astRequestor.additionalBindingResolver = null;
        }
    }

    private void resolve(String[] sourceCompilationUnits, String[] encodings, String[] bindingKeys, FileASTRequestor astRequestor, int apiLevel, Map compilerOptions, int flags) {
        astRequestor.compilationUnitResolver = this;
        this.bindingTables = new DefaultBindingResolver.BindingTables();
        CompilationUnitDeclaration unit = null;
        try {
            try {
                int length = sourceCompilationUnits.length;
                org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] sourceUnits = new org.eclipse.jdt.internal.compiler.env.ICompilationUnit[length];
                int count = 0;
                int i = 0;
                while (i < length) {
                    block27: {
                        char[] contents = null;
                        String encoding = encodings != null ? encodings[i] : null;
                        String sourceUnitPath = sourceCompilationUnits[i];
                        try {
                            contents = Util.getFileCharContent((File)new File(sourceUnitPath), (String)encoding);
                        }
                        catch (IOException e) {
                            break block27;
                        }
                        if (contents != null) {
                            sourceUnits[count++] = new org.eclipse.jdt.internal.compiler.batch.CompilationUnit(contents, sourceUnitPath, encoding);
                        }
                    }
                    ++i;
                }
                if (count < length) {
                    org.eclipse.jdt.internal.compiler.env.ICompilationUnit[] newArray = new org.eclipse.jdt.internal.compiler.env.ICompilationUnit[count];
                    System.arraycopy(sourceUnits, 0, newArray, 0, count);
                    sourceUnits = newArray;
                }
                this.beginToCompile(sourceUnits, bindingKeys);
                i = 0;
                while (i < this.totalUnits) {
                    if (this.resolvedRequestedSourcesAndKeys(i)) {
                        while (i < this.totalUnits) {
                            this.unitsToProcess[i].cleanUp();
                            this.unitsToProcess[i] = null;
                            ++i;
                        }
                        break;
                    }
                    unit = this.unitsToProcess[i];
                    try {
                        Object key;
                        super.process(unit, i);
                        char[] fileName = unit.compilationResult.getFileName();
                        org.eclipse.jdt.internal.compiler.env.ICompilationUnit source = (org.eclipse.jdt.internal.compiler.env.ICompilationUnit)this.requestedSources.get(fileName);
                        if (source != null) {
                            CompilationResult compilationResult = unit.compilationResult;
                            org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = compilationResult.compilationUnit;
                            char[] contents = sourceUnit.getContents();
                            AST ast = AST.newAST(apiLevel, "enabled".equals(compilerOptions.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures")));
                            ast.setFlag(flags | Integer.MIN_VALUE);
                            ast.setDefaultNodeFlag(2);
                            ASTConverter converter = new ASTConverter(compilerOptions, true, this.monitor);
                            DefaultBindingResolver resolver = new DefaultBindingResolver(unit.scope, null, this.bindingTables, (flags & 4) != 0, this.fromJavaProject);
                            ast.setBindingResolver(resolver);
                            converter.setAST(ast);
                            CompilationUnit compilationUnit = converter.convert(unit, contents);
                            compilationUnit.setTypeRoot(null);
                            compilationUnit.setLineEndTable(compilationResult.getLineSeparatorPositions());
                            ast.setDefaultNodeFlag(0);
                            ast.setOriginalModificationCount(ast.modificationCount());
                            astRequestor.acceptAST(new String(source.getFileName()), compilationUnit);
                            this.worked(1);
                            this.requestedSources.put(fileName, null);
                        }
                        if ((key = this.requestedKeys.get(fileName)) != null) {
                            if (key instanceof BindingKeyResolver) {
                                this.reportBinding(key, astRequestor, unit);
                                this.worked(1);
                            } else if (key instanceof ArrayList) {
                                Iterator iterator = ((ArrayList)key).iterator();
                                while (iterator.hasNext()) {
                                    this.reportBinding(iterator.next(), astRequestor, unit);
                                    this.worked(1);
                                }
                            }
                            this.requestedKeys.put(fileName, null);
                        }
                    }
                    finally {
                        unit.cleanUp();
                    }
                    this.unitsToProcess[i] = null;
                    this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
                    ++i;
                }
                DefaultBindingResolver resolver = new DefaultBindingResolver(this.lookupEnvironment, null, this.bindingTables, (flags & 4) != 0, true);
                Object[] keys = this.requestedKeys.valueTable;
                int j = 0;
                int keysLength = keys.length;
                while (j < keysLength) {
                    BindingKeyResolver keyResolver = (BindingKeyResolver)keys[j];
                    if (keyResolver != null) {
                        Binding compilerBinding = keyResolver.getCompilerBinding();
                        IBinding binding = compilerBinding == null ? null : resolver.getBinding(compilerBinding);
                        astRequestor.acceptBinding(((BindingKeyResolver)this.requestedKeys.valueTable[j]).getKey(), binding);
                        this.worked(1);
                    }
                    ++j;
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (AbortCompilation e) {
                this.handleInternalException(e, unit);
                astRequestor.compilationUnitResolver = null;
            }
            catch (Error | RuntimeException e) {
                this.handleInternalException(e, unit, null);
                throw e;
            }
        }
        finally {
            astRequestor.compilationUnitResolver = null;
        }
    }

    private void reportBinding(Object key, ASTRequestor astRequestor, WorkingCopyOwner owner, CompilationUnitDeclaration unit) {
        BindingKeyResolver keyResolver = (BindingKeyResolver)key;
        Binding compilerBinding = keyResolver.getCompilerBinding();
        if (compilerBinding != null) {
            DefaultBindingResolver resolver = new DefaultBindingResolver(unit.scope, owner, this.bindingTables, false, this.fromJavaProject);
            AnnotationBinding annotationBinding = keyResolver.getAnnotationBinding();
            IBinding binding = annotationBinding != null ? resolver.getAnnotationInstance(annotationBinding) : resolver.getBinding(compilerBinding);
            if (binding != null) {
                astRequestor.acceptBinding(keyResolver.getKey(), binding);
            }
        }
    }

    private void reportBinding(Object key, FileASTRequestor astRequestor, CompilationUnitDeclaration unit) {
        BindingKeyResolver keyResolver = (BindingKeyResolver)key;
        Binding compilerBinding = keyResolver.getCompilerBinding();
        if (compilerBinding != null) {
            DefaultBindingResolver resolver = new DefaultBindingResolver(unit.scope, null, this.bindingTables, false, this.fromJavaProject);
            AnnotationBinding annotationBinding = keyResolver.getAnnotationBinding();
            IBinding binding = annotationBinding != null ? resolver.getAnnotationInstance(annotationBinding) : resolver.getBinding(compilerBinding);
            if (binding != null) {
                astRequestor.acceptBinding(keyResolver.getKey(), binding);
            }
        }
    }

    private CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, NodeSearcher nodeSearcher, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        try {
            if (unit == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new org.eclipse.jdt.internal.compiler.env.ICompilationUnit[]{sourceUnit});
                int i = 0;
                int max = this.totalUnits;
                while (i < max) {
                    CompilationUnitDeclaration currentCompilationUnitDeclaration = this.unitsToProcess[i];
                    if (currentCompilationUnitDeclaration != null && currentCompilationUnitDeclaration.compilationResult.compilationUnit == sourceUnit) {
                        unit = currentCompilationUnitDeclaration;
                        break;
                    }
                    ++i;
                }
                if (unit == null) {
                    unit = this.unitsToProcess[0];
                }
            } else {
                this.lookupEnvironment.buildTypeBindings(unit, null);
                this.lookupEnvironment.completeTypeBindings();
            }
            if (nodeSearcher == null) {
                this.parser.getMethodBodies(unit);
            } else {
                int searchPosition = nodeSearcher.position;
                char[] source = sourceUnit.getContents();
                int length = source.length;
                if (searchPosition >= 0 && searchPosition <= length) {
                    unit.traverse((ASTVisitor)nodeSearcher, unit.scope);
                    ASTNode node = nodeSearcher.found;
                    if (node != null) {
                        int[] oldLineEnds = this.parser.scanner.lineEnds;
                        int oldLinePtr = this.parser.scanner.linePtr;
                        this.parser.scanner.setSource(source, unit.compilationResult);
                        TypeDeclaration enclosingTypeDeclaration = nodeSearcher.enclosingType;
                        if (node instanceof AbstractMethodDeclaration) {
                            ((AbstractMethodDeclaration)node).parseStatements(this.parser, unit);
                        } else if (enclosingTypeDeclaration != null) {
                            if (node instanceof Initializer) {
                                ((Initializer)node).parseStatements(this.parser, enclosingTypeDeclaration, unit);
                            } else if (node instanceof TypeDeclaration) {
                                ((TypeDeclaration)node).parseMethods(this.parser, unit);
                            }
                        }
                        this.parser.scanner.lineEnds = oldLineEnds;
                        this.parser.scanner.linePtr = oldLinePtr;
                    }
                }
            }
            if (unit.scope != null) {
                CompilationUnitDeclaration previousUnit = this.lookupEnvironment.unitBeingCompleted;
                this.lookupEnvironment.unitBeingCompleted = unit;
                try {
                    unit.scope.faultInTypes();
                    if (unit.scope != null && verifyMethods) {
                        unit.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                    }
                    unit.resolve();
                    if (analyzeCode) {
                        unit.analyseCode();
                    }
                    if (generateCode) {
                        unit.generateCode();
                    }
                    unit.finalizeProblems();
                }
                finally {
                    this.lookupEnvironment.unitBeingCompleted = previousUnit;
                }
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(unit.compilationResult.tagAsAccepted());
            return unit;
        }
        catch (AbortCompilation e) {
            this.handleInternalException(e, unit);
            return unit == null ? this.unitsToProcess[0] : unit;
        }
        catch (Error | RuntimeException e) {
            this.handleInternalException(e, unit, null);
            throw e;
        }
    }

    public CompilationUnitDeclaration resolve(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(null, sourceUnit, null, verifyMethods, analyzeCode, generateCode);
    }

    boolean resolvedRequestedSourcesAndKeys(int unitIndexToProcess) {
        Object[] keys;
        Object[] sources;
        if (unitIndexToProcess < this.requestedSources.size() && unitIndexToProcess < this.requestedKeys.size()) {
            return false;
        }
        Object[] objectArray = sources = this.requestedSources.valueTable;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            Object source = objectArray[n2];
            if (source != null) {
                return false;
            }
            ++n2;
        }
        Object[] objectArray2 = keys = this.requestedKeys.valueTable;
        int n3 = keys.length;
        n = 0;
        while (n < n3) {
            Object key = objectArray2[n];
            if (key != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration unit, org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean verifyMethods, boolean analyzeCode, boolean generateCode) {
        return this.resolve(unit, sourceUnit, null, verifyMethods, analyzeCode, generateCode);
    }

    public static CompilationUnit toCompilationUnit(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean initialNeedsToResolveBinding, IJavaProject project, List<FileSystem.Classpath> classpaths, NodeSearcher nodeSearcher, int apiLevel, Map<String, String> compilerOptions, WorkingCopyOwner parsedUnitWorkingCopyOwner, WorkingCopyOwner typeRootWorkingCopyOwner, int flags, IProgressMonitor monitor) {
        CompilationUnitDeclaration compilationUnitDeclaration = null;
        boolean needsToResolveBindingsState = initialNeedsToResolveBinding;
        try {
            if (initialNeedsToResolveBinding) {
                try {
                    compilationUnitDeclaration = CompilationUnitResolver.resolve(sourceUnit, project, classpaths, nodeSearcher, compilerOptions, parsedUnitWorkingCopyOwner, flags, monitor);
                }
                catch (JavaModelException e) {
                    compilationUnitDeclaration = CompilationUnitResolver.parse(sourceUnit, nodeSearcher, compilerOptions, flags &= 0xFFFFFFFB);
                    needsToResolveBindingsState = false;
                }
            } else {
                compilationUnitDeclaration = CompilationUnitResolver.parse(sourceUnit, nodeSearcher, compilerOptions, flags, project);
                needsToResolveBindingsState = false;
            }
            CompilationUnit compilationUnit = CompilationUnitResolver.convert(compilationUnitDeclaration, sourceUnit.getContents(), apiLevel, compilerOptions, needsToResolveBindingsState, typeRootWorkingCopyOwner, needsToResolveBindingsState ? new DefaultBindingResolver.BindingTables() : null, flags, monitor, project != null, project);
            return compilationUnit;
        }
        finally {
            if (compilationUnitDeclaration != null && initialNeedsToResolveBinding) {
                compilationUnitDeclaration.cleanUp();
            }
        }
    }

    private void worked(int work) {
        if (this.monitor != null) {
            if (this.monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.monitor.worked(work);
        }
    }

    private static final class ECJCompilationUnitResolver
    implements ICompilationUnitResolver {
        private ECJCompilationUnitResolver() {
        }

        @Override
        public void resolve(String[] sourceFilePaths, String[] encodings, String[] bindingKeys, FileASTRequestor requestor, int apiLevel, Map<String, String> compilerOptions, List<FileSystem.Classpath> classpath, int flags, IProgressMonitor monitor) {
            CompilationUnitResolver.resolve(sourceFilePaths, encodings, bindingKeys, requestor, apiLevel, compilerOptions, classpath, flags, monitor);
        }

        @Override
        public void parse(ICompilationUnit[] compilationUnits, ASTRequestor requestor, int apiLevel, Map<String, String> compilerOptions, int flags, IProgressMonitor monitor) {
            CompilationUnitResolver.parse(compilationUnits, requestor, apiLevel, compilerOptions, flags, monitor);
        }

        @Override
        public void parse(String[] sourceFilePaths, String[] encodings, FileASTRequestor requestor, int apiLevel, Map<String, String> compilerOptions, int flags, IProgressMonitor monitor) {
            CompilationUnitResolver.parse(sourceFilePaths, encodings, requestor, apiLevel, compilerOptions, flags, monitor);
        }

        @Override
        public void resolve(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, int apiLevel, Map<String, String> compilerOptions, IJavaProject project, WorkingCopyOwner workingCopyOwner, int flags, IProgressMonitor monitor) {
            CompilationUnitResolver.resolve(compilationUnits, bindingKeys, requestor, apiLevel, compilerOptions, project, workingCopyOwner, flags, monitor);
        }

        @Override
        public CompilationUnit toCompilationUnit(org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit, boolean initialNeedsToResolveBinding, IJavaProject project, List<FileSystem.Classpath> classpaths, int focalPosition, int apiLevel, Map<String, String> compilerOptions, WorkingCopyOwner parsedUnitWorkingCopyOwner, WorkingCopyOwner typeRootWorkingCopyOwner, int flags, IProgressMonitor monitor) {
            return CompilationUnitResolver.toCompilationUnit(sourceUnit, initialNeedsToResolveBinding, project, classpaths, focalPosition == -1 ? null : new NodeSearcher(focalPosition), apiLevel, compilerOptions, parsedUnitWorkingCopyOwner, typeRootWorkingCopyOwner, flags, monitor);
        }
    }

    static class IntArrayList {
        public int[] list = new int[5];
        public int length = 0;

        IntArrayList() {
        }

        public void add(int i) {
            if (this.list.length == this.length) {
                this.list = new int[this.length * 2];
                System.arraycopy(this.list, 0, this.list, 0, this.length);
            }
            this.list[this.length++] = i;
        }
    }
}

