/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationCompilationUnitWithEcj;
import org.eclipse.scout.sdk.core.java.model.api.IImport;
import org.eclipse.scout.sdk.core.java.model.api.internal.ImportImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.ImportSpi;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class DeclarationImportWithEcj
extends AbstractJavaElementWithEcj<IImport>
implements ImportSpi {
    private final ImportReference m_astNode;
    private final DeclarationCompilationUnitWithEcj m_cu;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<String> m_fqName;
    private final FinalValue<String> m_simpleName;
    private final FinalValue<String> m_qualifier;

    protected DeclarationImportWithEcj(AbstractJavaEnvironment env, DeclarationCompilationUnitWithEcj owner, ImportReference astNode) {
        super(env);
        this.m_astNode = astNode;
        this.m_cu = owner;
        this.m_source = new FinalValue();
        this.m_fqName = new FinalValue();
        this.m_simpleName = new FinalValue();
        this.m_qualifier = new FinalValue();
    }

    public ImportSpi internalFindNewElement() {
        CompilationUnitSpi newCu = this.getCompilationUnit().internalFindNewElement();
        if (newCu == null) {
            return null;
        }
        return newCu.getImports().stream().filter(newImport -> newImport.getName().equals(this.getName())).filter(newImport -> newImport.isStatic() == this.isStatic()).findFirst().orElse(null);
    }

    protected IImport internalCreateApi() {
        return new ImportImplementor((ImportSpi)this);
    }

    public ImportReference getInternalImportReference() {
        return this.m_astNode;
    }

    public String getName() {
        return (String)this.m_fqName.computeIfAbsentAndGet(() -> {
            Object name = CharOperation.toString((char[][])this.m_astNode.getImportName());
            if (this.m_astNode.trailingStarPosition > 0) {
                name = (String)name + ".*";
            }
            return name;
        });
    }

    public String getElementName() {
        return (String)this.m_simpleName.computeIfAbsentAndGet(() -> new String(this.m_astNode.tokens[this.m_astNode.tokens.length - 1]));
    }

    public String getQualifier() {
        return (String)this.m_qualifier.computeIfAbsentAndGet(() -> {
            char[][] importName = this.m_astNode.tokens;
            char[][] qualifier = CharOperation.subarray((char[][])importName, (int)0, (int)(importName.length - 1));
            return CharOperation.toString((char[][])qualifier);
        });
    }

    public DeclarationCompilationUnitWithEcj getCompilationUnit() {
        return this.m_cu;
    }

    public boolean isStatic() {
        return this.m_astNode.isStatic();
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> this.javaEnvWithEcj().getSource(this.m_cu, this.m_astNode.declarationSourceStart, this.m_astNode.declarationSourceEnd));
    }
}

