/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.earmodules;

import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.m2e.wtp.earmodules.EarModule;

public abstract class AbstractEarModule
implements EarModule {
    private String uri;
    private Artifact artifact;
    private String groupId;
    private String artifactId;
    private String classifier;
    protected String bundleDir;
    protected String bundleFileName;
    protected boolean excluded;
    protected Boolean unpack = null;
    protected String altDeploymentDescriptor;

    public AbstractEarModule() {
    }

    public AbstractEarModule(Artifact a) {
        this.setArtifact(a);
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    void setArtifact(Artifact a) {
        this.artifact = a;
        this.groupId = a.getGroupId();
        this.artifactId = a.getArtifactId();
        this.classifier = a.getClassifier();
    }

    @Override
    public String getUri() {
        if (this.uri == null) {
            Object bd = this.getBundleDir();
            if (StringUtils.isEmpty((String)bd) || "/".equals(bd)) {
                this.uri = this.getBundleFileName();
            } else {
                if (!((String)bd).endsWith("/")) {
                    bd = (String)bd + "/";
                }
                if (((String)bd).startsWith("/")) {
                    bd = ((String)bd).substring(1);
                }
                this.uri = (String)bd + this.getBundleFileName();
            }
        }
        return this.uri;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getBundleDir() {
        if (this.bundleDir != null) {
            this.bundleDir = AbstractEarModule.cleanBundleDir(this.bundleDir);
        }
        return this.bundleDir;
    }

    @Override
    public String getBundleFileName() {
        return this.bundleFileName;
    }

    @Override
    public String getAltDeploymentDescriptor() {
        return this.altDeploymentDescriptor;
    }

    @Override
    public boolean isExcluded() {
        return this.excluded;
    }

    @Override
    public Boolean shouldUnpack() {
        return this.unpack;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType()).append(":").append(this.groupId).append(":").append(this.artifactId);
        if (this.classifier != null) {
            sb.append(":").append(this.classifier);
        }
        if (this.artifact != null) {
            sb.append(":").append(this.artifact.getVersion());
        }
        return sb.toString();
    }

    static String cleanBundleDir(String bundleDir) {
        if (bundleDir == null) {
            return bundleDir;
        }
        if (!((String)(bundleDir = ((String)bundleDir).replace('\\', '/'))).startsWith("/")) {
            bundleDir = "/" + (String)bundleDir;
        }
        return bundleDir;
    }

    void setBundleDir(String bundleDir) {
        if (StringUtils.isBlank((String)this.uri)) {
            this.bundleDir = bundleDir;
        }
    }

    void setBundleFileName(String fileName) {
        if (StringUtils.isBlank((String)this.uri)) {
            this.bundleFileName = fileName;
        }
    }

    void setUri(String uri) {
        this.uri = uri;
        this.resolveDeploymentInfo();
    }

    private void resolveDeploymentInfo() {
        if (StringUtils.isNotBlank((String)this.uri)) {
            int lastSlash = this.uri.lastIndexOf(47);
            if (lastSlash == this.uri.length() - 1) {
                throw new IllegalArgumentException("module uri (" + this.uri + ") : can not end with a / ");
            }
            if (lastSlash > 0) {
                this.bundleDir = this.uri.substring(0, lastSlash);
                this.bundleFileName = this.uri.substring(lastSlash + 1);
            } else {
                this.bundleFileName = this.uri.replace("/", "");
            }
            this.bundleDir = AbstractEarModule.cleanBundleDir(this.bundleDir);
            if (StringUtils.isBlank((String)this.bundleFileName)) {
                throw new IllegalArgumentException("module uri must contain a file name ");
            }
        }
    }

    void setExcluded(boolean excluded) {
        this.excluded = excluded;
    }

    void setAltDeploymentDescriptor(String altDeploymentDescriptor) {
        this.altDeploymentDescriptor = altDeploymentDescriptor;
    }

    void setShouldUnpack(Boolean unpack) {
        this.unpack = unpack;
    }

    @Override
    public Xpp3Dom getAsDom() {
        Xpp3Dom moduleDom = new Xpp3Dom(this.getModuleType());
        Xpp3Dom groupIdDom = new Xpp3Dom("groupId");
        groupIdDom.setValue(this.getGroupId());
        moduleDom.addChild(groupIdDom);
        Xpp3Dom artifactIdDom = new Xpp3Dom("artifactId");
        artifactIdDom.setValue(this.getArtifactId());
        moduleDom.addChild(artifactIdDom);
        Xpp3Dom uriDom = new Xpp3Dom("uri");
        uriDom.setValue(this.getUri());
        moduleDom.addChild(uriDom);
        Xpp3Dom altDdDom = new Xpp3Dom("altDeploymentDescriptor");
        altDdDom.setValue(this.getAltDeploymentDescriptor());
        moduleDom.addChild(altDdDom);
        Xpp3Dom excludedDom = new Xpp3Dom("excluded");
        excludedDom.setValue(Boolean.toString(this.isExcluded()));
        moduleDom.addChild(excludedDom);
        this.setCustomValues(moduleDom);
        return moduleDom;
    }

    protected String getModuleType() {
        return "jarModule";
    }

    protected void setCustomValues(Xpp3Dom module) {
    }
}

