/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.facet;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCorePlugin;

public abstract class WebAppConfigurator {
    private final IProject _project;

    public static WebAppConfigurator getConfigurator(IProject project) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj == null) {
            FaceletCorePlugin.log("Error getting web app configurator", new Throwable());
            return null;
        }
        if (webAppObj instanceof WebApp) {
            return new JavaEEWebAppConfigurator(project);
        }
        if (webAppObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            return new J2EEWebAppConfigurator(project);
        }
        return null;
    }

    WebAppConfigurator(IProject project) {
        this._project = project;
    }

    public abstract void addContextParam(String var1, String var2, boolean var3);

    public abstract void removeContextParam(String var1, String var2);

    public abstract void addListener(String var1, boolean var2);

    public abstract void removeListener(String var1);

    protected void executeChange(Runnable runnable) {
        IPath webXMLPath = new Path("WEB-INF").append("web.xml");
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.getProject());
        provider.modify(runnable, webXMLPath);
    }

    protected IProject getProject() {
        return this._project;
    }

    private static class J2EEWebAppConfigurator
    extends WebAppConfigurator {
        public J2EEWebAppConfigurator(IProject project) {
            super(project);
        }

        @Override
        public void addContextParam(final String paramName, final String paramValue, final boolean addEvenIfPresent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this.getProject()).getModelObject();
                    if (addEvenIfPresent || !this.isContextParamPresent(webApp, paramName)) {
                        org.eclipse.jst.j2ee.common.ParamValue newParamValue = CommonFactory.eINSTANCE.createParamValue();
                        newParamValue.setName(paramName);
                        newParamValue.setValue(paramValue);
                        webApp.getContextParams().add((Object)newParamValue);
                    }
                }
            };
            this.executeChange(runnable);
        }

        @Override
        public void removeContextParam(final String paramName, final String paramVal) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this.getProject()).getModelObject();
                    Iterator it = webApp.getContextParams().iterator();
                    while (it.hasNext()) {
                        org.eclipse.jst.j2ee.common.ParamValue paramValue = (org.eclipse.jst.j2ee.common.ParamValue)it.next();
                        if (!paramName.equals(paramValue.getName().trim()) || !paramVal.equals(paramValue.getValue().trim())) continue;
                        it.remove();
                    }
                }
            };
            this.executeChange(runnable);
        }

        private boolean isContextParamPresent(org.eclipse.jst.j2ee.webapplication.WebApp webApp, String paramName) {
            for (org.eclipse.jst.j2ee.common.ParamValue paramValue : webApp.getContextParams()) {
                if (!paramName.equals(paramValue.getName().trim())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addListener(final String listenerClass, final boolean addEvenIfPresent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this.getProject()).getModelObject();
                    if (addEvenIfPresent || !this.isListenerPresent(webApp, listenerClass)) {
                        Listener listener = CommonFactory.eINSTANCE.createListener();
                        listener.setListenerClassName(listenerClass);
                        webApp.getListeners().add((Object)listener);
                    }
                }
            };
            this.executeChange(runnable);
        }

        @Override
        public void removeListener(final String listenerClass) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)ModelProviderManager.getModelProvider((IProject)this.getProject()).getModelObject();
                    Iterator listenerIt = webApp.getListeners().iterator();
                    while (listenerIt.hasNext()) {
                        Listener listener = (Listener)listenerIt.next();
                        if (!listenerClass.equals(listener.getListenerClassName().trim())) continue;
                        listenerIt.remove();
                    }
                }
            };
            this.executeChange(runnable);
        }

        private boolean isListenerPresent(org.eclipse.jst.j2ee.webapplication.WebApp webApp, String listenerClass) {
            for (Listener listener : webApp.getListeners()) {
                if (!listenerClass.equals(listener.getListenerClassName().trim())) continue;
                return true;
            }
            return false;
        }
    }

    private static class JavaEEWebAppConfigurator
    extends WebAppConfigurator {
        public JavaEEWebAppConfigurator(IProject project) {
            super(project);
        }

        @Override
        public void addContextParam(final String paramName, final String paramValue, final boolean addEvenIfPresent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this.getProject()).getModelObject();
                    if (addEvenIfPresent || !this.isContextParamPresent(webApp, paramName)) {
                        ParamValue newParamValue = JavaeeFactory.eINSTANCE.createParamValue();
                        newParamValue.setParamName(paramName);
                        newParamValue.setParamValue(paramValue);
                        webApp.getContextParams().add(newParamValue);
                    }
                }
            };
            this.executeChange(runnable);
        }

        @Override
        public void removeContextParam(final String paramName, final String paramVal) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this.getProject()).getModelObject();
                    Iterator it = webApp.getContextParams().iterator();
                    while (it.hasNext()) {
                        ParamValue paramValue = (ParamValue)it.next();
                        if (!paramName.equals(paramValue.getParamName().trim()) || !paramVal.equals(paramValue.getParamValue().trim())) continue;
                        it.remove();
                    }
                }
            };
            this.executeChange(runnable);
        }

        private boolean isContextParamPresent(WebApp webApp, String paramName) {
            for (ParamValue paramValue : webApp.getContextParams()) {
                if (!paramName.equals(paramValue.getParamName().trim())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void addListener(final String listenerClass, final boolean addEvenIfPresent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this.getProject()).getModelObject();
                    if (addEvenIfPresent || !this.isListenerPresent(webApp, listenerClass)) {
                        org.eclipse.jst.javaee.core.Listener listener = JavaeeFactory.eINSTANCE.createListener();
                        listener.setListenerClass(listenerClass);
                        webApp.getListeners().add(listener);
                    }
                }
            };
            this.executeChange(runnable);
        }

        @Override
        public void removeListener(final String listenerClass) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WebApp webApp = (WebApp)ModelProviderManager.getModelProvider((IProject)this.getProject()).getModelObject();
                    Iterator listenerIt = webApp.getListeners().iterator();
                    while (listenerIt.hasNext()) {
                        org.eclipse.jst.javaee.core.Listener listener = (org.eclipse.jst.javaee.core.Listener)listenerIt.next();
                        if (!listenerClass.equals(listener.getListenerClass().trim())) continue;
                        listenerIt.remove();
                    }
                }
            };
            this.executeChange(runnable);
        }

        private boolean isListenerPresent(WebApp webApp, String listenerClass) {
            for (org.eclipse.jst.javaee.core.Listener listener : webApp.getListeners()) {
                if (!listenerClass.equals(listener.getListenerClass().trim())) continue;
                return true;
            }
            return false;
        }
    }
}

