/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.appconfig;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public abstract class EObjectValidationVisitor {
    private EStructuralFeature _structuralFeature;
    private Map _childFeatures;
    private final String _version;
    protected static final EObjectValidationVisitor[] NO_CHILDREN = new EObjectValidationVisitor[0];

    public EObjectValidationVisitor(String version) {
        this._version = version;
    }

    private EObjectValidationVisitor getVisitorForFeature(EStructuralFeature feature) {
        if (this._childFeatures == null) {
            this._childFeatures = new HashMap();
            EObjectValidationVisitor[] children = this.getChildNodeValidators();
            int i = 0;
            while (i < children.length) {
                EObjectValidationVisitor child = children[i];
                this._childFeatures.put(child.getStructuralFeature(), child);
                ++i;
            }
        }
        return (EObjectValidationVisitor)this._childFeatures.get(feature);
    }

    public EObjectValidationVisitor(EStructuralFeature structuralFeature, String version) {
        this(version);
        this._structuralFeature = structuralFeature;
    }

    public final void validate(EObject eObject, List messages, IFile file) {
        this.doValidate(eObject, messages, file);
        EList features = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            EObjectValidationVisitor visitor = this.getVisitorForFeature(feature);
            if (visitor == null) continue;
            Object obj = eObject.eGet(feature);
            if (obj instanceof List && feature.isMany()) {
                for (Object child : (List)obj) {
                    if (!(child instanceof EObject)) continue;
                    visitor.validate((EObject)child, messages, file);
                }
                continue;
            }
            if (!(obj instanceof EObject)) continue;
            visitor.validate((EObject)obj, messages, file);
        }
    }

    protected abstract void doValidate(EObject var1, List var2, IFile var3);

    protected abstract EObjectValidationVisitor[] getChildNodeValidators();

    protected final EStructuralFeature getStructuralFeature() {
        return this._structuralFeature;
    }

    protected final String getVersion() {
        return this._version;
    }

    protected JSFVersion getJSFVersion() {
        return JSFVersion.valueOfString(this._version);
    }

    protected static void addMessageInfo(List messages, IMessage message, EObject eObj, IFile file) {
        if (message != null) {
            message.setOffset(AppConfigValidationUtil.getStartOffset(eObj));
            message.setLength(AppConfigValidationUtil.getLength(eObj));
            message.setTargetObject((Object)file);
            messages.add(message);
        }
    }
}

