/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.server.tomcat.core.internal.IMimeMapping;
import org.eclipse.jst.server.tomcat.core.internal.MimeMapping;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebAppDocument {
    protected boolean isWebAppDirty;
    protected Document webAppDocument;

    public WebAppDocument(IPath path) throws Exception {
        this.webAppDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(new FileInputStream(path.toFile())));
    }

    public WebAppDocument(IFile file) throws Exception {
        this.webAppDocument = XMLUtil.getDocumentBuilder().parse(new InputSource(file.getContents()));
    }

    public void addMimeMapping(int index, IMimeMapping map) {
        Trace.trace((byte)4, "Adding mime mapping " + index + " " + map.getMimeType() + " " + map.getExtension());
        Element element = this.webAppDocument.getDocumentElement();
        Element mapping = XMLUtil.createChildElement(this.webAppDocument, element, index, "mime-mapping");
        XMLUtil.insertText(this.webAppDocument, mapping, "\n\t");
        XMLUtil.createTextChildElement(this.webAppDocument, mapping, "extension", map.getExtension());
        XMLUtil.insertText(this.webAppDocument, mapping, "\n\t");
        XMLUtil.createTextChildElement(this.webAppDocument, mapping, "mime-type", map.getMimeType());
        XMLUtil.insertText(this.webAppDocument, mapping, "\n");
        this.isWebAppDirty = true;
    }

    public List getMimeMappings() {
        ArrayList<MimeMapping> map = new ArrayList<MimeMapping>();
        Element root = this.webAppDocument.getDocumentElement();
        Iterator iterator = XMLUtil.getNodeIterator(root, "mime-mapping");
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String mimeType = XMLUtil.getSubNodeValue(element, "mime-type");
            String extension = XMLUtil.getSubNodeValue(element, "extension");
            MimeMapping mm = new MimeMapping(extension, mimeType);
            map.add(mm);
        }
        return map;
    }

    public void modifyMimeMapping(int index, IMimeMapping map) {
        Element element = this.webAppDocument.getDocumentElement();
        NodeList list = element.getElementsByTagName("mime-mapping");
        Element element2 = (Element)list.item(index);
        XMLUtil.setNodeValue(element2.getElementsByTagName("extension").item(0), "extension", map.getExtension());
        XMLUtil.setNodeValue(element2.getElementsByTagName("mime-type").item(0), "mime-type", map.getMimeType());
        this.isWebAppDirty = true;
    }

    public void removeMimeMapping(int index) {
        Element element = this.webAppDocument.getDocumentElement();
        NodeList list = element.getElementsByTagName("mime-mapping");
        Node node = list.item(index);
        element.removeChild(node);
        this.isWebAppDirty = true;
    }

    public void save(String path, boolean forceDirty) throws IOException {
        if (forceDirty || this.isWebAppDirty) {
            XMLUtil.save(path, this.webAppDocument);
        }
    }

    public void save(IFile file, IProgressMonitor monitor) throws Exception {
        block14: {
            if (file.exists() && !this.isWebAppDirty) {
                return;
            }
            byte[] data = XMLUtil.getContents(this.webAppDocument);
            InputStream in = null;
            try {
                try {
                    in = new ByteArrayInputStream(data);
                    if (file.exists()) {
                        file.setContents(in, true, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                    } else {
                        file.create(in, true, ProgressUtil.getSubMonitorFor(monitor, 200));
                    }
                }
                catch (Exception exception) {
                    try {
                        in.close();
                    }
                    catch (Exception exception2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        this.isWebAppDirty = false;
    }
}

