/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.AbstractIconDialogWithHardcodedScope;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.FindContributionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.FindIconDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.UriDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class IconDialog
extends Dialog
implements UriDialog {
    private Text txtUri;
    private Text txtBundle;
    private Text txtIcon;
    private Text txtPath;
    public String uri = "";
    private String bundle = "";
    private String icon = "";
    private String path = "";
    protected boolean ignoreModify;
    private final IEclipseContext context;
    static Pattern patternIcon = Pattern.compile("platform:/plugin/*([^/]+)/((.*)/)?([^/]+)");

    public IconDialog(Shell parentShell, IEclipseContext context) {
        super(parentShell);
        this.context = context;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.IconDialog_uriEditor);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, false));
        ToolBar toolBar = new ToolBar(composite, 524288);
        toolBar.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lbl = new Label(composite, 0);
        lbl.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbl.setText(Messages.IconDialog_uri);
        this.txtUri = new Text(composite, 18436);
        this.txtUri.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtUri.setText("platform://plugin/");
        this.txtUri.addModifyListener(e -> {
            if (this.ignoreModify) {
                return;
            }
            this.ignoreModify = true;
            this.setUri(this.txtUri.getText());
            this.txtBundle.setText(this.bundle);
            this.txtPath.setText(this.path);
            this.txtIcon.setText(this.icon);
            this.ignoreModify = false;
            parent.pack();
        });
        ModifyListener listener = e -> {
            if (this.ignoreModify) {
                return;
            }
            this.ignoreModify = true;
            String prefix = "platform:/plugin/";
            this.setUri(prefix + this.txtBundle.getText() + "/" + this.txtPath.getText() + "/" + this.txtIcon.getText());
            this.txtUri.setText(this.getUri());
            this.ignoreModify = false;
        };
        Link lbl2 = new Link(composite, 0);
        lbl2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbl2.setText("<A>" + Messages.IconDialog_bundle + "</A>");
        this.txtBundle = new Text(composite, 18436);
        this.txtBundle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtBundle.addModifyListener(listener);
        lbl2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String uri;
                Matcher matcher;
                IEclipseContext childCtx = IconDialog.this.context.createChild();
                childCtx.set(Bundle.class, (Object)FrameworkUtil.getBundle(FindContributionDialog.class));
                childCtx.set("bundle", (Object)IconDialog.this.getBundle());
                childCtx.set("package", (Object)IconDialog.this.getPath());
                childCtx.set("mode", (Object)"show-bundles");
                FindContributionDialog dlg = new FindContributionDialog(childCtx);
                if (dlg.open() == 0 && (matcher = IconDialog.this.getMatcher(uri = IconDialog.this.getUri(dlg))).matches()) {
                    IconDialog.this.txtBundle.setText(matcher.group(1));
                }
            }
        });
        lbl2 = new Link(composite, 0);
        lbl2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbl2.setText("path");
        this.txtPath = new Text(composite, 18436);
        this.txtPath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtPath.addModifyListener(listener);
        lbl2 = new Link(composite, 0);
        lbl2.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbl2.setText("<A>" + Messages.IconDialog_icon + "</A>");
        this.txtIcon = new Text(composite, 18436);
        this.txtIcon.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtIcon.addModifyListener(listener);
        lbl2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEclipseContext childCtx = IconDialog.this.context.createChild();
                childCtx.set(Bundle.class, (Object)FrameworkUtil.getBundle(FindContributionDialog.class));
                childCtx.set(Messages.IconDialog_bundle, (Object)IconDialog.this.getBundle());
                childCtx.set(Messages.IconDialog_folder, (Object)IconDialog.this.getPath());
                AbstractIconDialogWithHardcodedScope dlg = new AbstractIconDialogWithHardcodedScope(IconDialog.this.getParentShell(), childCtx){

                    @Override
                    protected String getShellTitle() {
                        return Messages.IconDialog_selectIcon;
                    }

                    @Override
                    protected String getDialogTitle() {
                        return Messages.IconDialog_selectIcon_TITLE;
                    }

                    @Override
                    protected String getDialogMessage() {
                        return Messages.IconDialog_selectIcon_MESSAGE;
                    }
                };
                if (dlg.open() == 0) {
                    IconDialog.this.txtUri.setText(dlg.getValue());
                }
            }
        });
        ToolItem btnFind = new ToolItem(toolBar, 8);
        btnFind.setText(Messages.IconDialog_find + "...");
        btnFind.setImage(new Image((Device)this.getShell().getDisplay(), this.getClass().getResourceAsStream("/icons/full/obj16/find.png")));
        btnFind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEclipseContext childCtx = IconDialog.this.context.createChild();
                FindIconDialog dlg = new FindIconDialog(IconDialog.this.getParentShell(), childCtx);
                if (dlg.open() == 0) {
                    IconDialog.this.txtUri.setText(dlg.getValue());
                    IconDialog.this.getShell().pack();
                }
            }
        });
        ToolItem btnRemove = new ToolItem(toolBar, 8);
        btnRemove.setText("Remove");
        btnRemove.setImage(new Image((Device)this.getShell().getDisplay(), this.getClass().getResourceAsStream("/icons/full/obj16/remove_filter.png")));
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconDialog.this.txtUri.setText("");
                IconDialog.this.close();
            }
        });
        this.txtUri.setText(this.uri);
        this.txtBundle.setText(this.bundle);
        this.txtIcon.setText(this.icon);
        return composite;
    }

    protected String getUri(FindContributionDialog dlg) {
        return dlg.getPlatformUri();
    }

    @Override
    public int open() {
        int ret = super.open();
        return ret;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public void setUri(String uri) {
        this.uri = uri == null ? "" : uri.toString();
        Matcher matcher = this.getMatcher(this.uri);
        if (matcher.matches()) {
            this.bundle = matcher.group(1);
            this.path = matcher.group(3);
            if (this.path == null) {
                this.path = "";
            }
            this.icon = matcher.group(4);
        } else {
            this.bundle = "";
            this.path = "";
            this.icon = "";
        }
    }

    protected String getBundle() {
        return this.bundle;
    }

    protected void setBundle(String bundle) {
        this.bundle = bundle;
    }

    protected String getIcon() {
        return this.icon;
    }

    protected void setIcon(String icon) {
        this.icon = icon;
    }

    protected String getPath() {
        return this.path;
    }

    protected void setPath(String pakage) {
        this.path = pakage;
    }

    private Matcher getMatcher(String uri) {
        Matcher matcher = patternIcon.matcher(uri);
        return matcher;
    }
}

