/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.lemminx.client.IXMLSettingFeature;
import org.eclipse.lemminx.services.IXMLNotificationService;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageType;

public abstract class AbstractXMLNotifier {
    private final IXMLNotificationService notificationService;
    protected final Map<IXMLSettingFeature, Set<String>> cache;

    public AbstractXMLNotifier(IXMLNotificationService notificationService) {
        this.notificationService = notificationService;
        this.cache = new HashMap<IXMLSettingFeature, Set<String>>();
    }

    public boolean existsInCache(IXMLSettingFeature key, String value) {
        return this.cache.get(key) != null && this.cache.get(key).contains(value);
    }

    public boolean existsInCache(IXMLSettingFeature key, Set<String> values) {
        return this.cache.get(key) != null && this.cache.get(key).equals(values);
    }

    public void addToCache(IXMLSettingFeature key, String value) {
        if (this.cache.get(key) == null) {
            this.cache.put(key, new HashSet());
        }
        this.cache.get(key).add(value);
    }

    public void setCacheValues(IXMLSettingFeature key, Set<String> values) {
        this.evictKey(key);
        this.cache.put(key, new HashSet<String>(values));
    }

    public void evictKey(IXMLSettingFeature key) {
        Set<String> setToEvict = this.cache.get(key);
        if (setToEvict != null) {
            setToEvict.clear();
        }
    }

    public void evictValue(String value) {
        for (Set<String> set : this.cache.values()) {
            set.remove(value);
        }
    }

    protected void sendNotification(String message, MessageType messageType, Command ... commands) {
        this.notificationService.sendNotification(message, messageType, commands);
    }

    protected SharedSettings getSharedSettings() {
        return this.notificationService.getSharedSettings();
    }
}

