/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.db.internal.driver;

import java.util.HashMap;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.internal.driver.DB2;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapter;
import org.eclipse.jpt.jpa.db.internal.driver.DTPDriverAdapterFactory;
import org.eclipse.jpt.jpa.db.internal.driver.Derby;
import org.eclipse.jpt.jpa.db.internal.driver.HSQLDB;
import org.eclipse.jpt.jpa.db.internal.driver.Informix;
import org.eclipse.jpt.jpa.db.internal.driver.MaxDB;
import org.eclipse.jpt.jpa.db.internal.driver.MySQL;
import org.eclipse.jpt.jpa.db.internal.driver.Oracle;
import org.eclipse.jpt.jpa.db.internal.driver.PostgreSQL;
import org.eclipse.jpt.jpa.db.internal.driver.SQLServer;
import org.eclipse.jpt.jpa.db.internal.driver.Sybase;
import org.eclipse.jpt.jpa.db.internal.driver.Unknown;

public class DTPDriverAdapterManager {
    private final HashMap<String, DTPDriverAdapterFactory> adapterFactories = this.buildAdapterFactories();
    private static final DTPDriverAdapterManager INSTANCE = new DTPDriverAdapterManager();
    private static final DTPDriverAdapterFactory UNRECOGNIZED_ADAPTER_FACTORY = new Unknown.Factory();

    public static DTPDriverAdapterManager instance() {
        return INSTANCE;
    }

    private DTPDriverAdapterManager() {
    }

    private HashMap<String, DTPDriverAdapterFactory> buildAdapterFactories() {
        HashMap<String, DTPDriverAdapterFactory> factories = new HashMap<String, DTPDriverAdapterFactory>();
        this.addAdapterFactoriesTo(factories);
        return factories;
    }

    private void addAdapterFactoriesTo(HashMap<String, DTPDriverAdapterFactory> factories) {
        this.addAdapterFactoryTo(new DB2.Factory(), factories);
        this.addAdapterFactoryTo(new Derby.Factory(), factories);
        this.addAdapterFactoryTo(new HSQLDB.Factory(), factories);
        this.addAdapterFactoryTo(new Informix.Factory(), factories);
        this.addAdapterFactoryTo(new MaxDB.Factory(), factories);
        this.addAdapterFactoryTo(new MySQL.Factory(), factories);
        this.addAdapterFactoryTo(new Oracle.Factory(), factories);
        this.addAdapterFactoryTo(new PostgreSQL.Factory(), factories);
        this.addAdapterFactoryTo(new SQLServer.Factory(), factories);
        this.addAdapterFactoryTo(new Sybase.Factory(), factories);
    }

    private void addAdapterFactoryTo(DTPDriverAdapterFactory factory, HashMap<String, DTPDriverAdapterFactory> factories) {
        String[] stringArray = factory.getSupportedVendors();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.addAdapterFactoryTo(name, factory, factories);
            ++n2;
        }
    }

    private void addAdapterFactoryTo(String name, DTPDriverAdapterFactory factory, HashMap<String, DTPDriverAdapterFactory> factories) {
        if (factories.put(name, factory) != null) {
            throw new IllegalArgumentException("Duplicate adapter factory: " + name);
        }
    }

    public DTPDriverAdapter buildAdapter(String dtpVendorName, Database database) {
        return this.getAdapterFactory(dtpVendorName).buildAdapter(database);
    }

    private DTPDriverAdapterFactory getAdapterFactory(String dtpVendorName) {
        DTPDriverAdapterFactory factory = this.adapterFactories.get(dtpVendorName);
        return factory != null ? factory : UNRECOGNIZED_ADAPTER_FACTORY;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

